/*
 * Decompiled with CFR 0.152.
 */
package crypto.cryslhandler;

import crypto.rules.CrySLMethod;
import de.darmstadt.tu.crossing.crySL.Aggregate;
import de.darmstadt.tu.crossing.crySL.Domainmodel;
import de.darmstadt.tu.crossing.crySL.Event;
import de.darmstadt.tu.crossing.crySL.Method;
import de.darmstadt.tu.crossing.crySL.Object;
import de.darmstadt.tu.crossing.crySL.ObjectDecl;
import de.darmstadt.tu.crossing.crySL.Par;
import de.darmstadt.tu.crossing.crySL.ParList;
import de.darmstadt.tu.crossing.crySL.SuperType;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CryslReaderUtils {
    public static final String outerFileSeparator = System.getProperty("file.separator");
    public static final String innerFileSeparator = "/";

    protected static List<CrySLMethod> resolveAggregateToMethodeNames(Event leaf) {
        if (leaf instanceof Aggregate) {
            Aggregate ev = (Aggregate)leaf;
            return CryslReaderUtils.dealWithAggregate(ev);
        }
        ArrayList<CrySLMethod> statements = new ArrayList<CrySLMethod>();
        CrySLMethod stringifyMethodSignature = CryslReaderUtils.stringifyMethodSignature(leaf);
        if (stringifyMethodSignature != null) {
            statements.add(stringifyMethodSignature);
        }
        return statements;
    }

    protected static List<CrySLMethod> dealWithAggregate(Aggregate ev) {
        ArrayList<CrySLMethod> statements = new ArrayList<CrySLMethod>();
        for (Event lab : ev.getLab()) {
            if (lab instanceof Aggregate) {
                statements.addAll(CryslReaderUtils.dealWithAggregate((Aggregate)lab));
                continue;
            }
            statements.add(CryslReaderUtils.stringifyMethodSignature(lab));
        }
        return statements;
    }

    protected static CrySLMethod stringifyMethodSignature(Event lab) {
        if (!(lab instanceof SuperType)) {
            return null;
        }
        Method method = ((SuperType)lab).getMeth();
        String methodName = method.getMethName().getSimpleName();
        if (methodName == null) {
            methodName = ((Domainmodel)method.eContainer().eContainer().eContainer()).getJavaType().getSimpleName();
        }
        String qualifiedName = ((Domainmodel)method.eContainer().eContainer().eContainer()).getJavaType().getQualifiedName() + "." + methodName;
        ArrayList<Map.Entry<String, String>> pars = new ArrayList<Map.Entry<String, String>>();
        Object returnValue = method.getLeftSide();
        AbstractMap.SimpleEntry<String, String> returnObject = null;
        if (returnValue != null && returnValue.getName() != null) {
            ObjectDecl v = (ObjectDecl)returnValue.eContainer();
            returnObject = new AbstractMap.SimpleEntry<String, String>(returnValue.getName(), v.getObjectType().getQualifiedName() + (v.getArray() != null ? v.getArray() : ""));
        } else {
            returnObject = new AbstractMap.SimpleEntry<String, String>("_", "void");
        }
        ParList parList = method.getParList();
        if (parList != null) {
            for (Par par : parList.getParameters()) {
                String parValue = "_";
                if (par.getVal() != null && par.getVal().getName() != null) {
                    ObjectDecl objectDecl = (ObjectDecl)par.getVal().eContainer();
                    parValue = par.getVal().getName();
                    String parType = objectDecl.getObjectType().getIdentifier() + (objectDecl.getArray() != null ? objectDecl.getArray() : "");
                    pars.add(new AbstractMap.SimpleEntry<String, String>(parValue, parType));
                    continue;
                }
                pars.add(new AbstractMap.SimpleEntry<String, String>(parValue, "AnyType"));
            }
        }
        return new CrySLMethod(qualifiedName, pars, new ArrayList<Boolean>(), returnObject);
    }

    public static File getResourceFromWithin(String inputPath) {
        return new File(inputPath);
    }
}

