/*
 * Decompiled with CFR 0.152.
 */
package crypto.cryslhandler;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import crypto.cryslhandler.CryslReaderUtils;
import crypto.cryslhandler.StateMachineGraphBuilder;
import crypto.exceptions.CryptoAnalysisException;
import crypto.interfaces.ICrySLPredicateParameter;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLArithmeticConstraint;
import crypto.rules.CrySLComparisonConstraint;
import crypto.rules.CrySLCondPredicate;
import crypto.rules.CrySLConstraint;
import crypto.rules.CrySLForbiddenMethod;
import crypto.rules.CrySLMethod;
import crypto.rules.CrySLObject;
import crypto.rules.CrySLPredicate;
import crypto.rules.CrySLRule;
import crypto.rules.CrySLSplitter;
import crypto.rules.CrySLValueConstraint;
import crypto.rules.ParEqualsPredicate;
import crypto.rules.StateMachineGraph;
import crypto.rules.StateNode;
import crypto.rules.TransitionEdge;
import de.darmstadt.tu.crossing.CrySLStandaloneSetup;
import de.darmstadt.tu.crossing.constraints.CrySLArithmeticOperator;
import de.darmstadt.tu.crossing.constraints.CrySLComparisonOperator;
import de.darmstadt.tu.crossing.constraints.CrySLLogicalOperator;
import de.darmstadt.tu.crossing.crySL.Aggregate;
import de.darmstadt.tu.crossing.crySL.ArithmeticExpression;
import de.darmstadt.tu.crossing.crySL.ArithmeticOperator;
import de.darmstadt.tu.crossing.crySL.ArrayElements;
import de.darmstadt.tu.crossing.crySL.ComparingOperator;
import de.darmstadt.tu.crossing.crySL.ComparisonExpression;
import de.darmstadt.tu.crossing.crySL.Constraint;
import de.darmstadt.tu.crossing.crySL.DestroysBlock;
import de.darmstadt.tu.crossing.crySL.Domainmodel;
import de.darmstadt.tu.crossing.crySL.EnsuresBlock;
import de.darmstadt.tu.crossing.crySL.Event;
import de.darmstadt.tu.crossing.crySL.Expression;
import de.darmstadt.tu.crossing.crySL.ForbMethod;
import de.darmstadt.tu.crossing.crySL.ForbiddenBlock;
import de.darmstadt.tu.crossing.crySL.Literal;
import de.darmstadt.tu.crossing.crySL.LiteralExpression;
import de.darmstadt.tu.crossing.crySL.LogicalImply;
import de.darmstadt.tu.crossing.crySL.LogicalOperator;
import de.darmstadt.tu.crossing.crySL.ObjectDecl;
import de.darmstadt.tu.crossing.crySL.Order;
import de.darmstadt.tu.crossing.crySL.PreDefinedPredicates;
import de.darmstadt.tu.crossing.crySL.Pred;
import de.darmstadt.tu.crossing.crySL.PredLit;
import de.darmstadt.tu.crossing.crySL.ReqPred;
import de.darmstadt.tu.crossing.crySL.RequiredBlock;
import de.darmstadt.tu.crossing.crySL.SimpleOrder;
import de.darmstadt.tu.crossing.crySL.SuPar;
import de.darmstadt.tu.crossing.crySL.SuParList;
import de.darmstadt.tu.crossing.crySL.SuperType;
import de.darmstadt.tu.crossing.crySL.UnaryPreExpression;
import de.darmstadt.tu.crossing.crySL.UseBlock;
import de.darmstadt.tu.crossing.crySL.impl.DomainmodelImpl;
import de.darmstadt.tu.crossing.crySL.impl.ObjectImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class CrySLModelReader {
    private List<CrySLForbiddenMethod> forbiddenMethods = null;
    private StateMachineGraph smg = null;
    private XtextResourceSet resourceSet;
    public static final String cryslFileEnding = ".crysl";
    private static final String INT = "int";
    private static final String THIS = "this";
    private static final String ANY_TYPE = "AnyType";
    private static final String NULL = "null";
    private static final String UNDERSCORE = "_";

    public CrySLModelReader() throws MalformedURLException {
        CrySLStandaloneSetup crySLStandaloneSetup = new CrySLStandaloneSetup();
        Injector injector = crySLStandaloneSetup.createInjectorAndDoEMFRegistration();
        this.resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        String a = System.getProperty("java.class.path");
        String[] l = a.split(";");
        URL[] classpath = new URL[l.length];
        for (int i = 0; i < classpath.length; ++i) {
            classpath[i] = new File(l[i]).toURI().toURL();
        }
        URLClassLoader ucl = new URLClassLoader(classpath);
        this.resourceSet.setClasspathURIContext((Object)new URLClassLoader(classpath));
        new ClasspathTypeProvider((ClassLoader)ucl, (ResourceSet)this.resourceSet, null, null);
        this.resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
    }

    public CrySLRule readRule(InputStream stream, String virtualFileName) throws IllegalArgumentException, IOException, CryptoAnalysisException {
        if (!virtualFileName.endsWith(cryslFileEnding)) {
            throw new CryptoAnalysisException("The prefix of " + virtualFileName + " does not correspond to " + cryslFileEnding);
        }
        URI uri = URI.createURI((String)virtualFileName);
        Resource resource = (Resource)this.resourceSet.getURIResourceMap().get(uri);
        if (resource == null) {
            resource = this.resourceSet.createResource(uri);
            resource.load(stream, Collections.EMPTY_MAP);
        }
        return this.createRuleFromResource(resource);
    }

    public CrySLRule readRule(File ruleFile) throws CryptoAnalysisException {
        String fileName = ruleFile.getName();
        String extension = fileName.substring(fileName.lastIndexOf("."));
        if (!cryslFileEnding.equals(extension) && !fileName.endsWith(cryslFileEnding)) {
            return null;
        }
        if (!extension.equals(cryslFileEnding)) {
            throw new CryptoAnalysisException("The prefix of " + fileName + "  does not correspond to " + cryslFileEnding);
        }
        Resource resource = this.resourceSet.getResource(URI.createFileURI((String)ruleFile.getAbsolutePath()), true);
        return this.createRuleFromResource(resource);
    }

    private CrySLRule createRuleFromResource(Resource resource) throws CryptoAnalysisException {
        if (resource == null) {
            throw new CryptoAnalysisException("Internal error creating a CrySL rule: 'resource parameter was null'.");
        }
        EObject eObject = (EObject)resource.getContents().get(0);
        Domainmodel dm = (Domainmodel)eObject;
        String curClass = dm.getJavaType().getQualifiedName();
        RequiredBlock events = dm.getReq_events();
        EnsuresBlock ensure = dm.getEnsure();
        HashMap pre_preds = Maps.newHashMap();
        DestroysBlock destroys = dm.getDestroy();
        Expression order = dm.getOrder();
        if (order instanceof Order) {
            this.validateOrder((Order)order);
        }
        if (destroys != null) {
            pre_preds.putAll(this.getKills((EList<Constraint>)destroys.getPred()));
        }
        if (ensure != null) {
            pre_preds.putAll(this.getPredicates((List<Constraint>)ensure.getPred()));
        }
        this.smg = new StateMachineGraphBuilder(order, events).buildSMG();
        ForbiddenBlock forbEvent = dm.getForbEvent();
        this.forbiddenMethods = forbEvent != null ? this.getForbiddenMethods((EList<ForbMethod>)forbEvent.getForb_methods()) : Lists.newArrayList();
        ArrayList constraints = dm.getReqConstraints() != null ? this.buildUpConstraints((List<Constraint>)dm.getReqConstraints().getReq()) : Lists.newArrayList();
        constraints.addAll(dm.getRequire() != null ? this.collectRequiredPredicates((EList<ReqPred>)dm.getRequire().getPred()) : Lists.newArrayList());
        List<Map.Entry<String, String>> objects = this.getObjects(dm.getUsage());
        ArrayList actPreds = Lists.newArrayList();
        for (ParEqualsPredicate pred : pre_preds.keySet()) {
            SuperType cond = (SuperType)pre_preds.get(pred);
            if (cond == null) {
                actPreds.add(pred.tobasicPredicate());
                continue;
            }
            actPreds.add(new CrySLCondPredicate(pred.getBaseObject(), pred.getPredName(), pred.getParameters(), pred.isNegated(), this.getStatesForMethods(CryslReaderUtils.resolveAggregateToMethodeNames((Event)cond)), pred.getConstraint()));
        }
        return new CrySLRule(curClass, objects, this.forbiddenMethods, this.smg, constraints, actPreds);
    }

    private void validateOrder(Order order) {
        ArrayList<String> collected = new ArrayList<String>();
        collected.addAll(this.collectLabelsFromExpression(order.getLeft()));
        collected.addAll(this.collectLabelsFromExpression(order.getRight()));
    }

    private List<String> collectLabelsFromExpression(Expression exp) {
        ArrayList<String> collected = new ArrayList<String>();
        if (exp instanceof Order || exp instanceof SimpleOrder) {
            collected.addAll(this.collectLabelsFromExpression(exp.getLeft()));
            collected.addAll(this.collectLabelsFromExpression(exp.getRight()));
        } else {
            for (Event ev : exp.getOrderEv()) {
                if (!(ev instanceof SuperType)) continue;
                if (ev instanceof Aggregate) {
                    for (Event lab : ((Aggregate)ev).getLab()) {
                        if (lab instanceof SuperType) {
                            collected.add(((SuperType)lab).getName());
                            continue;
                        }
                        throw new ClassCastException("Parser error in the line after definition of label " + (String)collected.get(collected.size() - 1));
                    }
                    continue;
                }
                collected.add(((SuperType)ev).getName());
            }
        }
        return collected;
    }

    private Map<? extends ParEqualsPredicate, ? extends SuperType> getKills(EList<Constraint> eList) {
        HashMap<ParEqualsPredicate, SuperType> preds = new HashMap<ParEqualsPredicate, SuperType>();
        for (Constraint cons : eList) {
            String curClass = ((DomainmodelImpl)cons.eContainer().eContainer()).getJavaType().getQualifiedName();
            Pred pred = cons.getPredLit().getPred();
            ArrayList<ICrySLPredicateParameter> variables = new ArrayList<ICrySLPredicateParameter>();
            if (pred.getParList() != null) {
                boolean firstPar = true;
                for (SuPar var : pred.getParList().getParameters()) {
                    if (var.getVal() != null) {
                        ObjectImpl object = (ObjectImpl)((LiteralExpression)var.getVal().getLit().getName()).getValue();
                        String name = object.getName();
                        String type = ((ObjectDecl)object.eContainer()).getObjectType().getQualifiedName();
                        if (name == null) {
                            name = THIS;
                            type = curClass;
                        }
                        variables.add(new CrySLObject(name, type));
                    } else if (firstPar) {
                        variables.add(new CrySLObject(THIS, curClass));
                    } else {
                        variables.add(new CrySLObject(UNDERSCORE, NULL));
                    }
                    firstPar = false;
                }
            }
            String meth = pred.getPredName();
            SuperType cond = cons.getLabelCond();
            if (cond == null) {
                preds.put(new ParEqualsPredicate(null, meth, variables, true), null);
                continue;
            }
            preds.put(new ParEqualsPredicate(null, meth, variables, true), cond);
        }
        return preds;
    }

    private Map<? extends ParEqualsPredicate, ? extends SuperType> getPredicates(List<Constraint> predList) {
        HashMap<ParEqualsPredicate, SuperType> preds = new HashMap<ParEqualsPredicate, SuperType>();
        for (Constraint cons : predList) {
            Pred pred = cons.getPredLit().getPred();
            String curClass = ((DomainmodelImpl)cons.eContainer().eContainer()).getJavaType().getQualifiedName();
            ArrayList<ICrySLPredicateParameter> variables = new ArrayList<ICrySLPredicateParameter>();
            if (pred.getParList() != null) {
                boolean firstPar = true;
                for (SuPar var : pred.getParList().getParameters()) {
                    if (var.getVal() != null) {
                        ObjectImpl object = (ObjectImpl)((LiteralExpression)var.getVal().getLit().getName()).getValue();
                        String type = ((ObjectDecl)object.eContainer()).getObjectType().getQualifiedName();
                        String name = object.getName();
                        if (name == null) {
                            name = THIS;
                            type = curClass;
                        }
                        variables.add(new CrySLObject(name, type));
                    } else if (firstPar) {
                        variables.add(new CrySLObject(THIS, curClass));
                    } else {
                        variables.add(new CrySLObject(UNDERSCORE, NULL));
                    }
                    firstPar = false;
                }
            }
            CrySLPredicate ensPredCons = this.extractReqPred((ReqPred)cons.getPredLit());
            String meth = pred.getPredName();
            SuperType cond = cons.getLabelCond();
            if (cond == null) {
                preds.put(new ParEqualsPredicate(null, meth, variables, false, ensPredCons.getConstraint()), null);
                continue;
            }
            preds.put(new ParEqualsPredicate(null, meth, variables, false, ensPredCons.getConstraint()), cond);
        }
        return preds;
    }

    private List<ISLConstraint> buildUpConstraints(List<Constraint> constraints) {
        ArrayList<ISLConstraint> slCons = new ArrayList<ISLConstraint>();
        for (Constraint cons : constraints) {
            ISLConstraint constraint = this.getConstraint(cons);
            if (constraint == null) continue;
            slCons.add(constraint);
        }
        return slCons;
    }

    private ISLConstraint getConstraint(Constraint cons) {
        if (cons == null) {
            return null;
        }
        ISLConstraint slci = null;
        if (cons instanceof ArithmeticExpression) {
            ArithmeticExpression ae = (ArithmeticExpression)cons;
            String op = new CrySLArithmeticOperator((ArithmeticOperator)ae.getOperator()).toString();
            CrySLArithmeticConstraint.ArithOp operator = CrySLArithmeticConstraint.ArithOp.n;
            if ("+".equals(op)) {
                operator = CrySLArithmeticConstraint.ArithOp.p;
            }
            ObjectDecl leftObj = (ObjectDecl)((ObjectImpl)((LiteralExpression)((LiteralExpression)((LiteralExpression)ae.getLeftExpression()).getCons()).getName()).getValue()).eContainer();
            CrySLObject leftSide = new CrySLObject(leftObj.getObjectName().getName(), leftObj.getObjectType().getQualifiedName());
            ObjectDecl rightObj = (ObjectDecl)((ObjectImpl)((LiteralExpression)((LiteralExpression)((LiteralExpression)ae.getRightExpression()).getCons()).getName()).getValue()).eContainer();
            CrySLObject rightSide = new CrySLObject(rightObj.getObjectName().getName(), rightObj.getObjectType().getQualifiedName());
            slci = new CrySLArithmeticConstraint(leftSide, rightSide, operator);
        } else if (cons instanceof LiteralExpression) {
            LiteralExpression lit = (LiteralExpression)cons;
            ArrayList<String> parList = new ArrayList<String>();
            if (lit.getLitsleft() != null) {
                for (Literal a : lit.getLitsleft().getParameters()) {
                    parList.add(CrySLModelReader.filterQuotes(a.getVal()));
                }
            }
            if (lit.getCons() instanceof PreDefinedPredicates) {
                slci = this.getPredefinedPredicate(lit);
            } else {
                String part = ((ArrayElements)lit.getCons()).getCons().getPart();
                if (part != null) {
                    LiteralExpression name = (LiteralExpression)((ArrayElements)lit.getCons()).getCons().getLit().getName();
                    SuperType object = name.getValue();
                    CrySLObject variable = new CrySLObject(object.getName(), ((ObjectDecl)object.eContainer()).getObjectType().getQualifiedName(), new CrySLSplitter(Integer.parseInt(((ArrayElements)lit.getCons()).getCons().getInd()), CrySLModelReader.filterQuotes(((ArrayElements)lit.getCons()).getCons().getSplit())));
                    slci = new CrySLValueConstraint(variable, parList);
                } else {
                    String consPred = ((ArrayElements)lit.getCons()).getCons().getConsPred();
                    if (consPred != null) {
                        LiteralExpression name = (LiteralExpression)((ArrayElements)lit.getCons()).getCons().getLit().getName();
                        SuperType object = name.getValue();
                        if (consPred.equals("alg(")) {
                            int ind = 0;
                            CrySLObject variable = new CrySLObject(object.getName(), ((ObjectDecl)object.eContainer()).getObjectType().getQualifiedName(), new CrySLSplitter(ind, CrySLModelReader.filterQuotes("/")));
                            slci = new CrySLValueConstraint(variable, parList);
                        } else if (consPred.equals("mode(")) {
                            int ind = 1;
                            CrySLObject variable = new CrySLObject(object.getName(), ((ObjectDecl)object.eContainer()).getObjectType().getQualifiedName(), new CrySLSplitter(ind, CrySLModelReader.filterQuotes("/")));
                            slci = new CrySLValueConstraint(variable, parList);
                        } else if (consPred.equals("pad(")) {
                            int ind = 2;
                            CrySLObject variable = new CrySLObject(object.getName(), ((ObjectDecl)object.eContainer()).getObjectType().getQualifiedName(), new CrySLSplitter(ind, CrySLModelReader.filterQuotes("/")));
                            slci = new CrySLValueConstraint(variable, parList);
                        }
                    } else {
                        LiteralExpression name = (LiteralExpression)((ArrayElements)lit.getCons()).getCons().getName();
                        if (name == null) {
                            name = (LiteralExpression)((ArrayElements)lit.getCons()).getCons().getLit().getName();
                        }
                        SuperType object = name.getValue();
                        CrySLObject variable = new CrySLObject(object.getName(), ((ObjectDecl)object.eContainer()).getObjectType().getQualifiedName());
                        slci = new CrySLValueConstraint(variable, parList);
                    }
                }
            }
        } else if (cons instanceof ComparisonExpression) {
            ComparisonExpression comp = (ComparisonExpression)cons;
            CrySLComparisonConstraint.CompOp op = null;
            switch (new CrySLComparisonOperator((ComparingOperator)comp.getOperator()).toString()) {
                case ">": {
                    op = CrySLComparisonConstraint.CompOp.g;
                    break;
                }
                case "<": {
                    op = CrySLComparisonConstraint.CompOp.l;
                    break;
                }
                case ">=": {
                    op = CrySLComparisonConstraint.CompOp.ge;
                    break;
                }
                case "<=": {
                    op = CrySLComparisonConstraint.CompOp.le;
                    break;
                }
                case "!=": {
                    op = CrySLComparisonConstraint.CompOp.neq;
                    break;
                }
                default: {
                    op = CrySLComparisonConstraint.CompOp.eq;
                }
            }
            Constraint leftExpression = comp.getLeftExpression();
            CrySLArithmeticConstraint left = leftExpression instanceof LiteralExpression ? this.convertLiteralToArithmetic(leftExpression) : (leftExpression instanceof ArithmeticExpression ? this.convertArithExpressionToArithmeticConstraint(leftExpression) : (CrySLArithmeticConstraint)leftExpression);
            Constraint rightExpression = comp.getRightExpression();
            CrySLArithmeticConstraint right = rightExpression instanceof LiteralExpression ? this.convertLiteralToArithmetic(rightExpression) : this.convertArithExpressionToArithmeticConstraint(rightExpression);
            slci = new CrySLComparisonConstraint(left, right, op);
        } else if (cons instanceof UnaryPreExpression) {
            UnaryPreExpression un = (UnaryPreExpression)cons;
            ArrayList<ICrySLPredicateParameter> vars = new ArrayList<ICrySLPredicateParameter>();
            Pred innerPredicate = (Pred)un.getEnclosedExpression();
            if (innerPredicate.getParList() != null) {
                for (SuPar sup : innerPredicate.getParList().getParameters()) {
                    vars.add(new CrySLObject(UNDERSCORE, NULL));
                }
            }
            slci = new CrySLPredicate(null, innerPredicate.getPredName(), vars, true);
        } else if (cons instanceof Pred) {
            if (((Pred)cons).getPredName() != null && !((Pred)cons).getPredName().isEmpty()) {
                ArrayList<ICrySLPredicateParameter> vars = new ArrayList<ICrySLPredicateParameter>();
                SuParList parList = ((Pred)cons).getParList();
                if (parList != null) {
                    for (SuPar sup : parList.getParameters()) {
                        vars.add(new CrySLObject(UNDERSCORE, NULL));
                    }
                }
                slci = new CrySLPredicate(null, ((Pred)cons).getPredName(), vars, false);
            }
        } else if (cons instanceof Constraint) {
            CrySLConstraint.LogOps op = null;
            EObject operator = cons.getOperator();
            if (operator instanceof LogicalImply) {
                op = CrySLConstraint.LogOps.implies;
            } else {
                switch (new CrySLLogicalOperator((LogicalOperator)operator).toString()) {
                    case "&&": {
                        op = CrySLConstraint.LogOps.and;
                        break;
                    }
                    case "||": {
                        op = CrySLConstraint.LogOps.or;
                        break;
                    }
                    default: {
                        System.err.println("Sign " + operator.toString() + " was not properly translated.");
                        op = CrySLConstraint.LogOps.and;
                    }
                }
            }
            slci = new CrySLConstraint(this.getConstraint(cons.getLeftExpression()), this.getConstraint(cons.getRightExpression()), op);
        }
        return slci;
    }

    private List<CrySLForbiddenMethod> getForbiddenMethods(EList<ForbMethod> methods) {
        ArrayList<CrySLForbiddenMethod> methodSignatures = new ArrayList<CrySLForbiddenMethod>();
        for (ForbMethod fm : methods) {
            JvmExecutable meth = fm.getJavaMeth();
            ArrayList<Map.Entry<String, String>> pars = new ArrayList<Map.Entry<String, String>>();
            for (JvmFormalParameter par : meth.getParameters()) {
                pars.add(new AbstractMap.SimpleEntry<String, String>(par.getSimpleName(), par.getParameterType().getSimpleName()));
            }
            ArrayList<CrySLMethod> crysl = new ArrayList<CrySLMethod>();
            Event alternative = fm.getRep();
            if (alternative != null) {
                crysl.addAll(CryslReaderUtils.resolveAggregateToMethodeNames(alternative));
            }
            methodSignatures.add(new CrySLForbiddenMethod(new CrySLMethod(meth.getDeclaringType().getIdentifier() + "." + meth.getSimpleName(), pars, null, new AbstractMap.SimpleEntry<String, String>(UNDERSCORE, ANY_TYPE)), false, crysl));
        }
        return methodSignatures;
    }

    private List<ISLConstraint> collectRequiredPredicates(EList<ReqPred> requiredPreds) {
        ArrayList<ISLConstraint> preds = new ArrayList<ISLConstraint>();
        for (ReqPred pred : requiredPreds) {
            ISLConstraint reqPred = null;
            if (pred instanceof PredLit) {
                reqPred = this.extractReqPred(pred);
            } else {
                ReqPred left = pred.getLeftExpression();
                PredLit right = pred.getRightExpression();
                List<CrySLPredicate> altPreds = this.retrieveReqPredFromAltPreds(left);
                altPreds.add(this.extractReqPred((ReqPred)right));
                reqPred = new CrySLConstraint(altPreds.get(0), altPreds.get(1), CrySLConstraint.LogOps.or);
                for (int i = 2; i < altPreds.size(); ++i) {
                    reqPred = new CrySLConstraint(reqPred, altPreds.get(i), CrySLConstraint.LogOps.or);
                }
            }
            preds.add(reqPred);
        }
        return preds;
    }

    private List<CrySLPredicate> retrieveReqPredFromAltPreds(ReqPred left) {
        ArrayList<CrySLPredicate> preds = new ArrayList<CrySLPredicate>();
        if (left instanceof PredLit) {
            preds.add(this.extractReqPred(left));
        } else {
            preds.addAll(this.retrieveReqPredFromAltPreds(left.getLeftExpression()));
            preds.add(this.extractReqPred((ReqPred)left.getRightExpression()));
        }
        return preds;
    }

    private List<Map.Entry<String, String>> getObjects(UseBlock usage) {
        ArrayList<Map.Entry<String, String>> objects = new ArrayList<Map.Entry<String, String>>();
        for (ObjectDecl obj : usage.getObjects()) {
            objects.add(new AbstractMap.SimpleEntry<String, String>(obj.getObjectType().getIdentifier(), obj.getObjectName().getName()));
        }
        return objects;
    }

    private Set<StateNode> getStatesForMethods(List<CrySLMethod> condMethods) {
        HashSet<StateNode> predGens = new HashSet<StateNode>();
        if (condMethods.size() != 0) {
            for (TransitionEdge methTrans : this.smg.getAllTransitions()) {
                List<CrySLMethod> transLabel = methTrans.getLabel();
                if (transLabel.size() <= 0 || !transLabel.equals(condMethods) && (condMethods.size() != 1 || !transLabel.contains(condMethods.get(0)))) continue;
                predGens.add(methTrans.getRight());
            }
        }
        return predGens;
    }

    private ISLConstraint getPredefinedPredicate(LiteralExpression lit) {
        String pred = ((PreDefinedPredicates)lit.getCons()).getPredName();
        CrySLPredicate slci = null;
        switch (pred) {
            case "callTo": {
                ArrayList<ICrySLPredicateParameter> methodsToBeCalled = new ArrayList<ICrySLPredicateParameter>();
                methodsToBeCalled.addAll(CryslReaderUtils.resolveAggregateToMethodeNames((Event)((PreDefinedPredicates)lit.getCons()).getObj().get(0)));
                slci = new CrySLPredicate(null, pred, methodsToBeCalled, false);
                break;
            }
            case "noCallTo": {
                ArrayList<ICrySLPredicateParameter> methodsNotToBeCalled = new ArrayList<ICrySLPredicateParameter>();
                List<CrySLMethod> resolvedMethodNames = CryslReaderUtils.resolveAggregateToMethodeNames((Event)((PreDefinedPredicates)lit.getCons()).getObj().get(0));
                for (CrySLMethod csm : resolvedMethodNames) {
                    this.forbiddenMethods.add(new CrySLForbiddenMethod(csm, true));
                    methodsNotToBeCalled.add(csm);
                }
                slci = new CrySLPredicate(null, pred, methodsNotToBeCalled, false);
                break;
            }
            case "neverTypeOf": {
                ArrayList<ICrySLPredicateParameter> varNType = new ArrayList<ICrySLPredicateParameter>();
                de.darmstadt.tu.crossing.crySL.Object object = (de.darmstadt.tu.crossing.crySL.Object)((PreDefinedPredicates)lit.getCons()).getObj().get(0);
                String type = ((ObjectDecl)object.eContainer()).getObjectType().getQualifiedName();
                varNType.add(new CrySLObject(object.getName(), type));
                String qualifiedName = ((PreDefinedPredicates)lit.getCons()).getType().getType().getQualifiedName();
                varNType.add(new CrySLObject(qualifiedName, NULL));
                slci = new CrySLPredicate(null, pred, varNType, false);
                break;
            }
            case "length": {
                ArrayList<ICrySLPredicateParameter> variables = new ArrayList<ICrySLPredicateParameter>();
                de.darmstadt.tu.crossing.crySL.Object objectL = (de.darmstadt.tu.crossing.crySL.Object)((PreDefinedPredicates)lit.getCons()).getObj().get(0);
                String typeL = ((ObjectDecl)objectL.eContainer()).getObjectType().getQualifiedName();
                variables.add(new CrySLObject(objectL.getName(), typeL));
                slci = new CrySLPredicate(null, pred, variables, false);
                break;
            }
            case "notHardCoded": {
                ArrayList<ICrySLPredicateParameter> variables1 = new ArrayList<ICrySLPredicateParameter>();
                de.darmstadt.tu.crossing.crySL.Object objectL1 = (de.darmstadt.tu.crossing.crySL.Object)((PreDefinedPredicates)lit.getCons()).getObj().get(0);
                String typeL1 = ((ObjectDecl)objectL1.eContainer()).getObjectType().getQualifiedName();
                variables1.add(new CrySLObject(objectL1.getName(), typeL1));
                slci = new CrySLPredicate(null, pred, variables1, false);
                break;
            }
            case "instanceOf": {
                ArrayList<ICrySLPredicateParameter> varInstOf = new ArrayList<ICrySLPredicateParameter>();
                de.darmstadt.tu.crossing.crySL.Object objInstOf = (de.darmstadt.tu.crossing.crySL.Object)((PreDefinedPredicates)lit.getCons()).getObj().get(0);
                String instOfType = ((ObjectDecl)objInstOf.eContainer()).getObjectType().getQualifiedName();
                varInstOf.add(new CrySLObject(objInstOf.getName(), instOfType));
                String typeName = ((PreDefinedPredicates)lit.getCons()).getType().getType().getQualifiedName();
                varInstOf.add(new CrySLObject(typeName, NULL));
                slci = new CrySLPredicate(null, pred, varInstOf, false);
                break;
            }
            default: {
                new RuntimeException();
            }
        }
        return slci;
    }

    private CrySLArithmeticConstraint convertLiteralToArithmetic(Constraint expression) {
        ICrySLPredicateParameter name;
        LiteralExpression cons = (LiteralExpression)((LiteralExpression)expression).getCons();
        if (cons instanceof PreDefinedPredicates) {
            name = this.getPredefinedPredicate((LiteralExpression)expression);
        } else {
            EObject constraint = cons.getName();
            String object = this.getValueOfLiteral(constraint);
            name = constraint instanceof LiteralExpression ? new CrySLObject(object, ((ObjectDecl)((ObjectImpl)((LiteralExpression)constraint).getValue()).eContainer()).getObjectType().getQualifiedName()) : new CrySLObject(object, INT);
        }
        return new CrySLArithmeticConstraint(name, new CrySLObject("0", INT), CrySLArithmeticConstraint.ArithOp.p);
    }

    private CrySLArithmeticConstraint convertArithExpressionToArithmeticConstraint(Constraint expression) {
        ArithmeticExpression ar = (ArithmeticExpression)expression;
        String leftValue = this.getValueOfLiteral((EObject)ar.getLeftExpression());
        String rightValue = this.getValueOfLiteral((EObject)ar.getRightExpression());
        CrySLArithmeticOperator aop = new CrySLArithmeticOperator((ArithmeticOperator)ar.getOperator());
        CrySLArithmeticConstraint.ArithOp operator = null;
        switch (aop.toString()) {
            case "+": {
                operator = CrySLArithmeticConstraint.ArithOp.p;
                break;
            }
            case "-": {
                operator = CrySLArithmeticConstraint.ArithOp.n;
                break;
            }
            case "%": {
                operator = CrySLArithmeticConstraint.ArithOp.m;
                break;
            }
            default: {
                operator = CrySLArithmeticConstraint.ArithOp.p;
            }
        }
        CrySLArithmeticConstraint right = new CrySLArithmeticConstraint(new CrySLObject(leftValue, this.getTypeName(ar.getLeftExpression(), leftValue)), new CrySLObject(rightValue, this.getTypeName(ar.getRightExpression(), rightValue)), operator);
        return right;
    }

    private CrySLPredicate extractReqPred(ReqPred pred) {
        ArrayList<ICrySLPredicateParameter> variables = new ArrayList<ICrySLPredicateParameter>();
        PredLit innerPred = (PredLit)pred;
        EObject cons = innerPred.getCons();
        ISLConstraint conditional = null;
        if (cons instanceof Constraint) {
            conditional = this.getConstraint((Constraint)cons);
        } else if (cons instanceof Pred) {
            conditional = this.getPredicate((Pred)cons);
        }
        if (innerPred.getPred().getParList() != null) {
            for (SuPar var : innerPred.getPred().getParList().getParameters()) {
                if (var.getVal() != null) {
                    LiteralExpression lit = var.getVal();
                    ObjectImpl object = (ObjectImpl)((LiteralExpression)lit.getLit().getName()).getValue();
                    String type = ((ObjectDecl)object.eContainer()).getObjectType().getQualifiedName();
                    String variable = object.getName();
                    String part = var.getVal().getPart();
                    if (part != null) {
                        variables.add(new CrySLObject(variable, type, new CrySLSplitter(Integer.parseInt(lit.getInd()), CrySLModelReader.filterQuotes(lit.getSplit()))));
                        continue;
                    }
                    String consPred = var.getVal().getConsPred();
                    if (consPred != null) {
                        int ind;
                        if (consPred.equals("alg(")) {
                            ind = 0;
                            variables.add(new CrySLObject(variable, type, new CrySLSplitter(ind, CrySLModelReader.filterQuotes("/"))));
                            continue;
                        }
                        if (consPred.equals("mode(")) {
                            ind = 1;
                            variables.add(new CrySLObject(variable, type, new CrySLSplitter(ind, CrySLModelReader.filterQuotes("/"))));
                            continue;
                        }
                        if (!consPred.equals("pad(")) continue;
                        ind = 2;
                        variables.add(new CrySLObject(variable, type, new CrySLSplitter(ind, CrySLModelReader.filterQuotes("/"))));
                        continue;
                    }
                    variables.add(new CrySLObject(variable, type));
                    continue;
                }
                variables.add(new CrySLObject(UNDERSCORE, NULL));
            }
        }
        return new CrySLPredicate(null, innerPred.getPred().getPredName(), variables, innerPred.getNot() != null, conditional);
    }

    private ISLConstraint getPredicate(Pred pred) {
        ArrayList<ICrySLPredicateParameter> variables = new ArrayList<ICrySLPredicateParameter>();
        if (pred.getParList() != null) {
            for (SuPar var : pred.getParList().getParameters()) {
                if (var.getVal() != null) {
                    LiteralExpression lit = var.getVal();
                    ObjectImpl object = (ObjectImpl)((LiteralExpression)lit.getLit().getName()).getValue();
                    String type = ((ObjectDecl)object.eContainer()).getObjectType().getQualifiedName();
                    String variable = object.getName();
                    String part = var.getVal().getPart();
                    if (part != null) {
                        variables.add(new CrySLObject(variable, type, new CrySLSplitter(Integer.parseInt(lit.getInd()), CrySLModelReader.filterQuotes(lit.getSplit()))));
                        continue;
                    }
                    String consPred = var.getVal().getConsPred();
                    if (consPred != null) {
                        int ind;
                        if (consPred.equals("alg(")) {
                            ind = 0;
                            variables.add(new CrySLObject(variable, type, new CrySLSplitter(ind, CrySLModelReader.filterQuotes("/"))));
                            continue;
                        }
                        if (consPred.equals("mode(")) {
                            ind = 1;
                            variables.add(new CrySLObject(variable, type, new CrySLSplitter(ind, CrySLModelReader.filterQuotes("/"))));
                            continue;
                        }
                        if (!consPred.equals("pad(")) continue;
                        ind = 2;
                        variables.add(new CrySLObject(variable, type, new CrySLSplitter(ind, CrySLModelReader.filterQuotes("/"))));
                        continue;
                    }
                    variables.add(new CrySLObject(variable, type));
                    continue;
                }
                variables.add(new CrySLObject(UNDERSCORE, NULL));
            }
        }
        return new CrySLPredicate(null, pred.getPredName(), variables, ((PredLit)pred.eContainer()).getNot() != null, null);
    }

    private String getValueOfLiteral(EObject name) {
        EObject cons;
        SuperType preValue;
        String value = "";
        value = name instanceof LiteralExpression ? ((preValue = ((LiteralExpression)name).getValue()) != null ? preValue.getName() : ((cons = ((LiteralExpression)name).getCons()) instanceof LiteralExpression ? this.getValueOfLiteral(((LiteralExpression)cons).getName()) : "")) : ((Literal)name).getVal();
        return CrySLModelReader.filterQuotes(value);
    }

    private String getTypeName(Constraint constraint, String value) {
        String typeName = "";
        try {
            Integer.parseInt(value);
            typeName = INT;
        }
        catch (NumberFormatException ex) {
            typeName = ((ObjectDecl)((LiteralExpression)((LiteralExpression)((LiteralExpression)constraint).getCons()).getName()).getValue().eContainer()).getObjectType().getQualifiedName();
        }
        return typeName;
    }

    private static String filterQuotes(String dirty) {
        return CharMatcher.anyOf((CharSequence)"\"").removeFrom((CharSequence)dirty);
    }
}

