/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis.errors;

import boomerang.jimple.Statement;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import crypto.analysis.IAnalysisSeed;
import crypto.analysis.errors.ErrorVisitor;
import crypto.analysis.errors.ErrorWithObjectAllocation;
import crypto.rules.CrySLRule;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import soot.SootMethod;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;

public class TypestateError
extends ErrorWithObjectAllocation {
    private Collection<SootMethod> expectedMethodCalls;
    private Set<String> expectedMethodCallsSet = Sets.newHashSet();

    public TypestateError(Statement stmt, CrySLRule rule, IAnalysisSeed object, Collection<SootMethod> expectedMethodCalls) {
        super(stmt, rule, object);
        this.expectedMethodCalls = expectedMethodCalls;
        for (SootMethod method : expectedMethodCalls) {
            this.expectedMethodCallsSet.add(method.getSignature());
        }
    }

    public Collection<SootMethod> getExpectedMethodCalls() {
        return this.expectedMethodCalls;
    }

    @Override
    public void accept(ErrorVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toErrorMarkerString() {
        StringBuilder msg = new StringBuilder();
        boolean useSignatures = this.useSignatures();
        msg.append("Unexpected call to method ");
        Statement location = this.getErrorLocation();
        msg.append(this.getCalledMethodString(location, useSignatures));
        msg.append(this.getObjectType());
        HashSet<String> altMethods = new HashSet<String>();
        for (SootMethod expectedCall : this.expectedMethodCalls) {
            if (useSignatures) {
                altMethods.add(expectedCall.getSignature().replace("<", "").replace(">", ""));
                continue;
            }
            altMethods.add(expectedCall.getName().replace("<", "").replace(">", ""));
        }
        if (altMethods.isEmpty()) {
            msg.append(".");
        } else {
            msg.append(". Expect a call to one of the following methods ");
            msg.append(Joiner.on((String)",").join(altMethods));
        }
        return msg.toString();
    }

    private String getCalledMethodString(Statement location, boolean useSignature) {
        Stmt stmt = (Stmt)location.getUnit().get();
        if (stmt.containsInvokeExpr()) {
            if (useSignature) {
                return stmt.getInvokeExpr().getMethod().getSignature();
            }
            return stmt.getInvokeExpr().getMethod().getName();
        }
        return stmt.toString();
    }

    private boolean useSignatures() {
        Stmt stmt;
        Optional stmtOptional;
        Statement errorLocation = this.getErrorLocation();
        if (errorLocation.isCallsite() && (stmtOptional = errorLocation.getUnit()).isPresent() && (stmt = (Stmt)stmtOptional.get()).containsInvokeExpr()) {
            InvokeExpr call = stmt.getInvokeExpr();
            SootMethod calledMethod = call.getMethod();
            for (SootMethod expectedCall : this.getExpectedMethodCalls()) {
                if (!calledMethod.getName().equals(expectedCall.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.expectedMethodCallsSet == null ? 0 : this.expectedMethodCallsSet.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypestateError other = (TypestateError)obj;
        return !(this.expectedMethodCallsSet == null ? other.expectedMethodCallsSet != null : this.expectedMethodCallsSet != other.expectedMethodCallsSet);
    }
}

