/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis.errors;

import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import com.google.common.base.CharMatcher;
import crypto.analysis.IAnalysisSeed;
import crypto.analysis.errors.ErrorVisitor;
import crypto.analysis.errors.ErrorWithObjectAllocation;
import crypto.extractparameter.CallSiteWithExtractedValue;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLArithmeticConstraint;
import crypto.rules.CrySLComparisonConstraint;
import crypto.rules.CrySLConstraint;
import crypto.rules.CrySLPredicate;
import crypto.rules.CrySLRule;
import crypto.rules.CrySLSplitter;
import crypto.rules.CrySLValueConstraint;
import java.util.List;
import java.util.Set;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.Stmt;
import soot.jimple.internal.AbstractInvokeExpr;
import sync.pds.solver.nodes.Node;

public class ConstraintError
extends ErrorWithObjectAllocation {
    private ISLConstraint brokenConstraint;
    private CallSiteWithExtractedValue callSiteWithParamIndex;

    public ConstraintError(CallSiteWithExtractedValue cs, CrySLRule rule, IAnalysisSeed objectLocation, ISLConstraint con) {
        super(cs.getCallSite().stmt(), rule, objectLocation);
        this.callSiteWithParamIndex = cs;
        this.brokenConstraint = con;
    }

    public ISLConstraint getBrokenConstraint() {
        return this.brokenConstraint;
    }

    @Override
    public void accept(ErrorVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Set<Node<Statement, Val>> getDataFlowPath() {
        return this.callSiteWithParamIndex.getVal().getDataFlowPath();
    }

    public CallSiteWithExtractedValue getCallSiteWithExtractedValue() {
        return this.callSiteWithParamIndex;
    }

    @Override
    public String toErrorMarkerString() {
        return this.callSiteWithParamIndex.toString() + this.evaluateBrokenConstraint(this.brokenConstraint);
    }

    private String evaluateBrokenConstraint(ISLConstraint brokenConstraint) {
        StringBuilder msg = new StringBuilder();
        if (brokenConstraint instanceof CrySLPredicate) {
            CrySLPredicate brokenPred = (CrySLPredicate)brokenConstraint;
            switch (brokenPred.getPredName()) {
                case "neverTypeOf": {
                    msg.append(" should never be of type ");
                    msg.append(brokenPred.getParameters().get(1).getName());
                    msg.append(".");
                    break;
                }
                case "notHardCoded": {
                    msg.append(" should never be hardcoded.");
                }
            }
        } else {
            if (brokenConstraint instanceof CrySLValueConstraint) {
                return this.evaluateValueConstraint((CrySLValueConstraint)brokenConstraint);
            }
            if (brokenConstraint instanceof CrySLArithmeticConstraint) {
                CrySLArithmeticConstraint brokenArthConstraint = (CrySLArithmeticConstraint)brokenConstraint;
                msg.append(brokenArthConstraint.getLeft());
                msg.append(" ");
                msg.append((Object)brokenArthConstraint.getOperator());
                msg.append(" ");
                msg.append(brokenArthConstraint.getRight());
            } else if (brokenConstraint instanceof CrySLComparisonConstraint) {
                CrySLComparisonConstraint brokenCompCons = (CrySLComparisonConstraint)brokenConstraint;
                msg.append("Variable ");
                msg.append(brokenCompCons.getLeft().getLeft().getName());
                msg.append("must be ");
                msg.append(this.evaluateCompOp(brokenCompCons.getOperator()));
                msg.append(brokenCompCons.getRight().getLeft().getName());
            } else if (brokenConstraint instanceof CrySLConstraint) {
                CrySLConstraint crySLConstraint = (CrySLConstraint)brokenConstraint;
                ISLConstraint leftSide = crySLConstraint.getLeft();
                ISLConstraint rightSide = crySLConstraint.getRight();
                switch (crySLConstraint.getOperator()) {
                    case and: {
                        msg.append(this.evaluateBrokenConstraint(leftSide));
                        msg.append(" or ");
                        msg.append(this.evaluateBrokenConstraint(rightSide));
                        break;
                    }
                    case implies: {
                        msg.append(this.evaluateBrokenConstraint(rightSide));
                        break;
                    }
                    case or: {
                        msg.append(this.evaluateBrokenConstraint(leftSide));
                        msg.append(" and ");
                        msg.append(this.evaluateBrokenConstraint(rightSide));
                        break;
                    }
                }
            }
        }
        return msg.toString();
    }

    private String evaluateCompOp(CrySLComparisonConstraint.CompOp operator) {
        switch (operator) {
            case ge: {
                return " at least ";
            }
            case g: {
                return " greater than ";
            }
            case l: {
                return " lesser than ";
            }
            case le: {
                return " at most ";
            }
        }
        return "equal to";
    }

    private String evaluateValueConstraint(CrySLValueConstraint brokenConstraint) {
        StringBuilder msg = new StringBuilder();
        msg.append(" should be any of ");
        CrySLSplitter splitter = brokenConstraint.getVar().getSplitter();
        if (splitter != null) {
            Stmt stmt = (Stmt)this.callSiteWithParamIndex.getVal().stmt().getUnit().get();
            String[] splitValues = new String[]{""};
            if (stmt instanceof AssignStmt) {
                Value rightSide = ((AssignStmt)stmt).getRightOp();
                if (rightSide instanceof Constant) {
                    splitValues = ConstraintError.filterQuotes(rightSide.toString()).split(splitter.getSplitter());
                } else if (rightSide instanceof AbstractInvokeExpr) {
                    List args = ((AbstractInvokeExpr)rightSide).getArgs();
                    for (Value arg : args) {
                        if (!arg.getType().toQuotedString().equals(brokenConstraint.getVar().getJavaType())) continue;
                        splitValues = ConstraintError.filterQuotes(arg.toString()).split(splitter.getSplitter());
                        break;
                    }
                }
            } else {
                splitValues = ConstraintError.filterQuotes(((ValueBox)stmt.getInvokeExpr().getUseBoxes().get(0)).getValue().toString()).split(splitter.getSplitter());
            }
            if (splitValues.length >= splitter.getIndex()) {
                for (int i = 0; i < splitter.getIndex(); ++i) {
                    msg.append(splitValues[i]);
                    msg.append(splitter.getSplitter());
                }
            }
        }
        msg.append("{");
        for (String val : brokenConstraint.getValueRange()) {
            if (val.isEmpty()) {
                msg.append("Empty String");
            } else {
                msg.append(val);
            }
            msg.append(", ");
        }
        msg.delete(msg.length() - 2, msg.length());
        return msg.append('}').toString();
    }

    public static String filterQuotes(String dirty) {
        return CharMatcher.anyOf((CharSequence)"\"").removeFrom((CharSequence)dirty);
    }

    @Override
    public int hashCode() {
        int paramIndex = this.callSiteWithParamIndex.getCallSite().getIndex();
        Value parameterValue = this.callSiteWithParamIndex.getVal().getValue();
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + paramIndex;
        result = 31 * result + (parameterValue == null ? 0 : parameterValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstraintError other = (ConstraintError)obj;
        if (this.callSiteWithParamIndex.getCallSite().getIndex() != other.callSiteWithParamIndex.getCallSite().getIndex()) {
            return false;
        }
        return !(this.callSiteWithParamIndex.getVal().getValue() == null ? other.callSiteWithParamIndex.getVal().getValue() != null : !this.callSiteWithParamIndex.getVal().getValue().equals(other.callSiteWithParamIndex.getVal().getValue()));
    }
}

