/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis;

import crypto.exceptions.CryptoAnalysisParserException;

public class CryptoScannerSettings {
    private ControlGraph controlGraph = null;
    private RulesetPathType rulesetPathType = null;
    private String rulesetPathDir = null;
    private String rulesetPathZip = null;
    private String sootPath = "";
    private String applicationPath = null;
    private String softwareIdentifier = "";
    private String reportDirectory = null;
    private ReportFormat reportFormat = null;
    private boolean preAnalysis;
    private boolean visualization;
    private boolean providerDetectionAnalysis;

    public CryptoScannerSettings() {
        this.setControlGraph(ControlGraph.CHA);
        this.setRulesetPathType(RulesetPathType.NONE);
        this.setPreAnalysis(false);
        this.setVisualization(false);
        this.setProviderDetectionAnalysis(false);
    }

    public ControlGraph getControlGraph() {
        return this.controlGraph;
    }

    public void setControlGraph(ControlGraph controlGraph) {
        this.controlGraph = controlGraph;
    }

    public RulesetPathType getRulesetPathType() {
        return this.rulesetPathType;
    }

    public void setRulesetPathType(RulesetPathType rulesetPathType) {
        this.rulesetPathType = rulesetPathType;
    }

    public String getRulesetPathDir() {
        return this.rulesetPathDir;
    }

    public void setRulesetPathDir(String rulesPath) {
        this.rulesetPathDir = rulesPath;
    }

    public String getRulesetPathZip() {
        return this.rulesetPathZip;
    }

    public void setRulesetPathZip(String rulesetPathZip) {
        this.rulesetPathZip = rulesetPathZip;
    }

    public String getSootPath() {
        return this.sootPath;
    }

    public void setSootPath(String sootClasspath) {
        this.sootPath = sootClasspath;
    }

    public String getApplicationPath() {
        return this.applicationPath;
    }

    public void setApplicationPath(String applicationClasspath) {
        this.applicationPath = applicationClasspath;
    }

    public String getSoftwareIdentifier() {
        return this.softwareIdentifier;
    }

    public void setSoftwareIdentifier(String softwareIdentifier) {
        this.softwareIdentifier = softwareIdentifier;
    }

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    public void setReportDirectory(String reportDirectory) {
        this.reportDirectory = reportDirectory;
    }

    public ReportFormat getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(ReportFormat reportFormat) {
        this.reportFormat = reportFormat;
    }

    public boolean isPreAnalysis() {
        return this.preAnalysis;
    }

    public void setPreAnalysis(boolean preAnalysis) {
        this.preAnalysis = preAnalysis;
    }

    public boolean isVisualization() {
        return this.visualization;
    }

    public void setVisualization(boolean visualization) {
        this.visualization = visualization;
    }

    public boolean isProviderDetectionAnalysis() {
        return this.providerDetectionAnalysis;
    }

    public void setProviderDetectionAnalysis(boolean providerDetectionAnalysis) {
        this.providerDetectionAnalysis = providerDetectionAnalysis;
    }

    public void parseSettingsFromCLI(String[] settings) throws CryptoAnalysisParserException {
        int mandatorySettings = 0;
        if (settings == null) {
            CryptoScannerSettings.showErrorMessage();
        }
        block26: for (int i = 0; i < settings.length; ++i) {
            switch (settings[i].toLowerCase()) {
                case "--cg": {
                    this.parseControlGraphValue(settings[i + 1]);
                    ++i;
                    continue block26;
                }
                case "--rulesdir": {
                    if (this.rulesetPathType != RulesetPathType.NONE) {
                        throw new CryptoAnalysisParserException("An error occured while parsing --rulesDir option. There should be only one option between --rulesDir and --rulesZip.");
                    }
                    this.setRulesetPathType(RulesetPathType.DIR);
                    this.setRulesetPathDir(settings[i + 1]);
                    ++i;
                    ++mandatorySettings;
                    continue block26;
                }
                case "--ruleszip": {
                    if (this.rulesetPathType != RulesetPathType.NONE) {
                        throw new CryptoAnalysisParserException("An error occured while parsing --rulesDir option. There should be only one option between --rulesDir and --rulesZip.");
                    }
                    this.setRulesetPathType(RulesetPathType.ZIP);
                    this.setRulesetPathZip(settings[i + 1]);
                    ++mandatorySettings;
                    ++i;
                    continue block26;
                }
                case "--apppath": {
                    this.setApplicationPath(settings[i + 1]);
                    ++i;
                    ++mandatorySettings;
                    continue block26;
                }
                case "--sootpath": {
                    this.setSootPath(settings[i + 1]);
                    ++i;
                    continue block26;
                }
                case "--identifier": {
                    this.setSoftwareIdentifier(settings[i + 1]);
                    ++i;
                    continue block26;
                }
                case "--reportpath": {
                    this.setReportDirectory(settings[i + 1]);
                    ++i;
                    continue block26;
                }
                case "--reportformat": {
                    this.parseReportFormatValue(settings[i + 1]);
                    ++i;
                    continue block26;
                }
                case "--preanalysis": {
                    this.setPreAnalysis(true);
                    continue block26;
                }
                case "--visualization": {
                    this.setVisualization(true);
                    continue block26;
                }
                case "--providerdetection": {
                    this.setProviderDetectionAnalysis(true);
                    continue block26;
                }
                default: {
                    CryptoScannerSettings.showErrorMessage(settings[i]);
                }
            }
        }
        if (mandatorySettings != 2) {
            CryptoScannerSettings.showErrorMessage();
        }
    }

    private void parseControlGraphValue(String value) throws CryptoAnalysisParserException {
        String CGValue;
        switch (CGValue = value.toLowerCase()) {
            case "cha": {
                this.setControlGraph(ControlGraph.CHA);
                break;
            }
            case "spark": {
                this.setControlGraph(ControlGraph.SPARK);
                break;
            }
            case "sparklib": {
                this.setControlGraph(ControlGraph.SPARKLIB);
                break;
            }
            default: {
                throw new CryptoAnalysisParserException("Incorrect value " + CGValue + " for --cg option. Available options are: CHA, SPARK and SPARKLIB.\n");
            }
        }
    }

    private void parseReportFormatValue(String value) throws CryptoAnalysisParserException {
        String reportFormatValue;
        switch (reportFormatValue = value.toLowerCase()) {
            case "txt": {
                this.setReportFormat(ReportFormat.TXT);
                break;
            }
            case "sarif": {
                this.setReportFormat(ReportFormat.SARIF);
                break;
            }
            case "csv": {
                this.setReportFormat(ReportFormat.CSV);
                break;
            }
            default: {
                throw new CryptoAnalysisParserException("Incorrect value " + reportFormatValue + " for --reportFormat option. Available options are: TXT, SARIF and CSV.\n");
            }
        }
    }

    private static void showErrorMessage() throws CryptoAnalysisParserException {
        String errorMessage = "An error occurred while trying to parse the CLI arguments.\nThe default command for running CryptoAnalysis is: \njava -cp <jar_location_of_cryptoanalysis> crypto.HeadlessCryptoScanner \\\r\n \t\t--rulesDir <absolute_path_to_crysl_source_code_format_rules> \\\r\n       --appPath <absolute_application_path>\n";
        throw new CryptoAnalysisParserException(errorMessage);
    }

    private static void showErrorMessage(String arg) throws CryptoAnalysisParserException {
        String errorMessage = "An error occured while trying to parse the CLI argument: " + arg + ".\nThe default command for running CryptoAnalysis is: \njava -cp <jar_location_of_cryptoanalysis> crypto.HeadlessCryptoScanner \\\r\n      --rulesDir <absolute_path_to_crysl_rules> \\\r\n      --appPath <absolute_application_path>\n\nAdditional arguments that can be used are:\n--cg <selection_of_call_graph_for_analysis (CHA, SPARK, SPARKLIB)>\n--sootPath <absolute_path_of_whole_project>\n--identifier <identifier_for_labelling_output_files>\n--reportPath <directory_location_for_cognicrypt_report>\n--reportFormat <format of cognicrypt_report (TXT, SARIF, CSV)>\n--preanalysis (enables pre-analysis)\n--visualization (enables the visualization, but also requires --reportPath option to be set)\n--providerDetection (enables provider detection analysis)\n";
        throw new CryptoAnalysisParserException(errorMessage);
    }

    public static enum RulesetPathType {
        DIR,
        ZIP,
        NONE;

    }

    public static enum ReportFormat {
        TXT,
        SARIF,
        CSV;

    }

    public static enum ControlGraph {
        CHA,
        SPARK,
        SPARKLIB;

    }
}

