/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis;

import boomerang.ForwardQuery;
import boomerang.callgraph.ObservableICFG;
import boomerang.debugger.Debugger;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.ForwardBoomerangResults;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import crypto.analysis.CrySLResultsReporter;
import crypto.analysis.CryptoScanner;
import crypto.analysis.EnsuredCrySLPredicate;
import crypto.analysis.IAnalysisSeed;
import crypto.rules.StateMachineGraph;
import crypto.rules.StateNode;
import crypto.typestate.ExtendedIDEALAnaylsis;
import crypto.typestate.SootBasedStateMachineGraph;
import ideal.IDEALSeedSolver;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;
import sync.pds.solver.nodes.Node;
import typestate.TransitionFunction;

public class AnalysisSeedWithEnsuredPredicate
extends IAnalysisSeed {
    private ForwardBoomerangResults<TransitionFunction> analysisResults;
    private Set<EnsuredCrySLPredicate> ensuredPredicates = Sets.newHashSet();
    private ExtendedIDEALAnaylsis problem;
    private boolean analyzed;

    public AnalysisSeedWithEnsuredPredicate(CryptoScanner cryptoScanner, Node<Statement, Val> delegate) {
        super(cryptoScanner, (Statement)delegate.stmt(), (Val)delegate.fact(), TransitionFunction.one());
    }

    @Override
    public void execute() {
        this.cryptoScanner.getAnalysisListener().seedStarted(this);
        ExtendedIDEALAnaylsis solver = this.getOrCreateAnalysis();
        solver.run((ForwardQuery)this);
        this.analysisResults = solver.getResults();
        for (EnsuredCrySLPredicate pred : this.ensuredPredicates) {
            this.ensurePredicates(pred);
        }
        this.cryptoScanner.getAnalysisListener().onSeedFinished(this, this.analysisResults);
        this.analyzed = true;
    }

    protected void ensurePredicates(EnsuredCrySLPredicate pred) {
        if (this.analysisResults == null) {
            return;
        }
        for (Table.Cell c : this.analysisResults.asStatementValWeightTable().cellSet()) {
            this.predicateHandler.addNewPred(this, (Statement)c.getRowKey(), (Val)c.getColumnKey(), pred);
        }
    }

    private ExtendedIDEALAnaylsis getOrCreateAnalysis() {
        this.problem = new ExtendedIDEALAnaylsis(){

            @Override
            protected ObservableICFG<Unit, SootMethod> icfg() {
                return AnalysisSeedWithEnsuredPredicate.this.cryptoScanner.icfg();
            }

            @Override
            public SootBasedStateMachineGraph getStateMachine() {
                StateMachineGraph m = new StateMachineGraph();
                StateNode s = new StateNode("0", true, true){

                    @Override
                    public String toString() {
                        return "";
                    }
                };
                m.addNode(s);
                m.createNewEdge(Lists.newLinkedList(), s, s);
                return new SootBasedStateMachineGraph(m);
            }

            @Override
            public CrySLResultsReporter analysisListener() {
                return AnalysisSeedWithEnsuredPredicate.this.cryptoScanner.getAnalysisListener();
            }

            @Override
            protected Debugger<TransitionFunction> debugger(IDEALSeedSolver<TransitionFunction> solver) {
                return AnalysisSeedWithEnsuredPredicate.this.cryptoScanner.debugger(solver, AnalysisSeedWithEnsuredPredicate.this);
            }
        };
        return this.problem;
    }

    public void addEnsuredPredicate(EnsuredCrySLPredicate pred) {
        if (this.ensuredPredicates.add(pred) && this.analyzed) {
            this.ensurePredicates(pred);
        }
    }

    public String toString() {
        return "AnalysisSeedWithEnsuredPredicate:" + this.asNode() + " " + this.ensuredPredicates;
    }

    @Override
    public Set<Node<Statement, Val>> getDataFlowPath() {
        return this.analysisResults.getDataFlowPath();
    }
}

