/*
 * Decompiled with CFR 0.152.
 */
package crypto;

import boomerang.callgraph.ObservableDynamicICFG;
import boomerang.callgraph.ObservableICFG;
import boomerang.debugger.Debugger;
import boomerang.debugger.IDEVizDebugger;
import boomerang.preanalysis.BoomerangPretransformer;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import crypto.analysis.CrySLAnalysisListener;
import crypto.analysis.CrySLResultsReporter;
import crypto.analysis.CryptoScanner;
import crypto.analysis.CryptoScannerSettings;
import crypto.analysis.IAnalysisSeed;
import crypto.exceptions.CryptoAnalysisException;
import crypto.exceptions.CryptoAnalysisParserException;
import crypto.preanalysis.SeedFactory;
import crypto.providerdetection.ProviderDetection;
import crypto.reporting.CSVReporter;
import crypto.reporting.CommandLineReporter;
import crypto.reporting.ErrorMarkerListener;
import crypto.reporting.SARIFReporter;
import crypto.reporting.TXTReporter;
import crypto.rules.CrySLRule;
import crypto.rules.CrySLRuleReader;
import ideal.IDEALSeedSolver;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.EntryPoints;
import soot.G;
import soot.PackManager;
import soot.PhaseOptions;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootMethod;
import soot.Transform;
import soot.Transformer;
import soot.Unit;
import soot.options.Options;
import typestate.TransitionFunction;

public abstract class HeadlessCryptoScanner {
    private static CryptoScannerSettings settings = new CryptoScannerSettings();
    private boolean hasSeeds;
    private static Stopwatch callGraphWatch;
    private static List<CrySLRule> rules;
    private static String rulesetRootPath;
    private static final Logger LOGGER;

    public static void main(String[] args) {
        HeadlessCryptoScanner scanner = HeadlessCryptoScanner.createFromCLISettings(args);
        scanner.exec();
    }

    public static HeadlessCryptoScanner createFromCLISettings(String[] args) {
        try {
            settings.parseSettingsFromCLI(args);
        }
        catch (CryptoAnalysisParserException e) {
            LOGGER.error("Parser failed with error: " + e.getClass().toString(), (Throwable)e);
        }
        HeadlessCryptoScanner scanner = new HeadlessCryptoScanner(){

            @Override
            protected String applicationClassPath() {
                return settings.getApplicationPath();
            }

            @Override
            protected List<CrySLRule> getRules() {
                switch (settings.getRulesetPathType()) {
                    case DIR: {
                        try {
                            rules.addAll(CrySLRuleReader.readFromDirectory(new File(settings.getRulesetPathDir())));
                            rulesetRootPath = settings.getRulesetPathDir().substring(0, settings.getRulesetPathDir().lastIndexOf(File.separator));
                        }
                        catch (CryptoAnalysisException e) {
                            LOGGER.error("Error happened when getting the CrySL rules from the specified directory: " + settings.getRulesetPathDir(), (Throwable)e);
                        }
                        break;
                    }
                    case ZIP: {
                        try {
                            rules.addAll(CrySLRuleReader.readFromZipFile(new File(settings.getRulesetPathZip())));
                            rulesetRootPath = settings.getRulesetPathZip().substring(0, settings.getRulesetPathZip().lastIndexOf(File.separator));
                        }
                        catch (CryptoAnalysisException e) {
                            LOGGER.error("Error happened when getting the CrySL rules from the specified file: " + settings.getRulesetPathZip(), (Throwable)e);
                        }
                        break;
                    }
                    default: {
                        LOGGER.error("Error happened when getting the CrySL rules from the specified file.");
                    }
                }
                return rules;
            }
        };
        return scanner;
    }

    public void exec() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (this.isPreAnalysis()) {
            try {
                this.initializeSootWithEntryPointAllReachable(false);
            }
            catch (CryptoAnalysisException e) {
                LOGGER.error("Error happened when executing HeadlessCryptoScanner.", (Throwable)e);
            }
            LOGGER.info("Pre-Analysis soot setup done in {} ", (Object)stopwatch);
            this.checkIfUsesObject();
            LOGGER.info("Pre-Analysis  finished in {}", (Object)stopwatch);
        }
        if (!this.isPreAnalysis() || this.hasSeeds()) {
            LOGGER.info("Using call graph algorithm {}", (Object)this.callGraphAlgorithm());
            try {
                this.initializeSootWithEntryPointAllReachable(true);
            }
            catch (CryptoAnalysisException e) {
                LOGGER.error("Error happened when executing HeadlessCryptoScanner.", (Throwable)e);
            }
            LOGGER.info("Analysis soot setup done in {} ", (Object)stopwatch);
            this.analyse();
            LOGGER.info("Analysis finished in {}", (Object)stopwatch);
        }
    }

    public boolean hasSeeds() {
        return this.hasSeeds;
    }

    private void checkIfUsesObject() {
        final SeedFactory seedFactory = new SeedFactory(rules);
        PackManager.v().getPack("jap").add(new Transform("jap.myTransform", (Transformer)new BodyTransformer(){

            protected void internalTransform(Body body, String phase, Map options) {
                if (!body.getMethod().getDeclaringClass().isApplicationClass()) {
                    return;
                }
                for (Unit u : body.getUnits()) {
                    seedFactory.generate(body.getMethod(), u);
                }
            }
        }));
        PhaseOptions.v().setPhaseOption("jap.npc", "on");
        PackManager.v().runPacks();
        this.hasSeeds = seedFactory.hasSeeds();
    }

    private void analyse() {
        Transform transform = new Transform("wjtp.ifds", this.createAnalysisTransformer());
        PackManager.v().getPack("wjtp").add(transform);
        callGraphWatch = Stopwatch.createStarted();
        PackManager.v().getPack("cg").apply();
        PackManager.v().getPack("wjtp").apply();
    }

    public String toString() {
        String s = "HeadllessCryptoScanner: \n";
        s = s + "\tSoftwareIdentifier: " + this.softwareIdentifier() + "\n";
        s = s + "\tApplicationClassPath: " + this.applicationClassPath() + "\n";
        s = s + "\tSootClassPath: " + this.sootClassPath() + "\n\n";
        return s;
    }

    private Transformer createAnalysisTransformer() {
        return new SceneTransformer(){

            protected void internalTransform(String phaseName, Map<String, String> options) {
                ErrorMarkerListener fileReporter;
                BoomerangPretransformer.v().reset();
                BoomerangPretransformer.v().apply();
                final ObservableDynamicICFG observableDynamicICFG = new ObservableDynamicICFG(false);
                List rules = rules;
                if (HeadlessCryptoScanner.this.reportFormat() != null) {
                    switch (HeadlessCryptoScanner.this.reportFormat()) {
                        case SARIF: {
                            fileReporter = new SARIFReporter(HeadlessCryptoScanner.this.getOutputFolder(), rules);
                            break;
                        }
                        case CSV: {
                            fileReporter = new CSVReporter(HeadlessCryptoScanner.this.getOutputFolder(), HeadlessCryptoScanner.this.softwareIdentifier(), rules, callGraphWatch.elapsed(TimeUnit.MILLISECONDS));
                            break;
                        }
                        default: {
                            fileReporter = new TXTReporter(HeadlessCryptoScanner.this.getOutputFolder(), rules);
                            break;
                        }
                    }
                } else {
                    fileReporter = new CommandLineReporter(rules);
                }
                final CrySLResultsReporter reporter = new CrySLResultsReporter();
                if (HeadlessCryptoScanner.this.getAdditionalListener() != null) {
                    reporter.addReportListener(HeadlessCryptoScanner.this.getAdditionalListener());
                }
                CryptoScanner scanner = new CryptoScanner(){

                    @Override
                    public ObservableICFG<Unit, SootMethod> icfg() {
                        return observableDynamicICFG;
                    }

                    @Override
                    public CrySLResultsReporter getAnalysisListener() {
                        return reporter;
                    }

                    @Override
                    public Debugger<TransitionFunction> debugger(IDEALSeedSolver<TransitionFunction> solver, IAnalysisSeed seed) {
                        if (HeadlessCryptoScanner.this.enableVisualization()) {
                            if (HeadlessCryptoScanner.this.getOutputFolder() == null) {
                                LOGGER.error("The visualization requires the --reportDir option.");
                            }
                            File vizFile = new File(HeadlessCryptoScanner.this.getOutputFolder() + "/viz/ObjectId#" + seed.getObjectId() + ".json");
                            vizFile.getParentFile().mkdirs();
                            return new IDEVizDebugger(vizFile, this.icfg());
                        }
                        return super.debugger(solver, seed);
                    }
                };
                reporter.addReportListener(fileReporter);
                if (HeadlessCryptoScanner.this.providerDetection()) {
                    String detectedProvider;
                    ProviderDetection providerDetection = new ProviderDetection();
                    if (rulesetRootPath == null) {
                        rulesetRootPath = System.getProperty("user.dir") + File.separator + "src" + File.separator + "main" + File.separator + "resources";
                    }
                    if ((detectedProvider = providerDetection.doAnalysis((ObservableICFG<Unit, SootMethod>)observableDynamicICFG, rulesetRootPath)) != null) {
                        rules.clear();
                        switch (settings.getRulesetPathType()) {
                            case DIR: {
                                rules.addAll(providerDetection.chooseRules(rulesetRootPath + File.separator + detectedProvider));
                                break;
                            }
                            case ZIP: {
                                rules.addAll(providerDetection.chooseRulesZip(rulesetRootPath + File.separator + detectedProvider + ".zip"));
                                break;
                            }
                            default: {
                                rules.addAll(providerDetection.chooseRules(rulesetRootPath + File.separator + detectedProvider));
                            }
                        }
                    }
                }
                scanner.scan(rules);
            }
        };
    }

    protected CrySLAnalysisListener getAdditionalListener() {
        return null;
    }

    private void initializeSootWithEntryPointAllReachable(boolean wholeProgram) throws CryptoAnalysisException {
        G.v();
        G.reset();
        Options.v().set_whole_program(wholeProgram);
        switch (this.callGraphAlgorithm()) {
            case CHA: {
                Options.v().setPhaseOption("cg.cha", "on");
                break;
            }
            case SPARKLIB: {
                Options.v().setPhaseOption("cg.spark", "on");
                Options.v().setPhaseOption("cg", "library:any-subtype");
                break;
            }
            case SPARK: {
                Options.v().setPhaseOption("cg.spark", "on");
                break;
            }
            default: {
                throw new CryptoAnalysisException("No call graph option selected out of: CHA, SPARK_LIBRARY and SPARK");
            }
        }
        Options.v().set_output_format(12);
        Options.v().set_no_bodies_for_excluded(true);
        Options.v().set_allow_phantom_refs(true);
        Options.v().set_keep_line_number(true);
        if (HeadlessCryptoScanner.getJavaVersion() < 9) {
            Options.v().set_prepend_classpath(true);
            Options.v().set_soot_classpath(this.sootClassPath() + File.pathSeparator + HeadlessCryptoScanner.pathToJCE());
        } else if (HeadlessCryptoScanner.getJavaVersion() >= 9 && !this.isModularProject()) {
            Options.v().set_soot_classpath("VIRTUAL_FS_FOR_JDK" + File.pathSeparator + this.sootClassPath());
        } else if (HeadlessCryptoScanner.getJavaVersion() >= 9 && this.isModularProject()) {
            Options.v().set_prepend_classpath(true);
            Options.v().set_soot_modulepath(this.sootClassPath());
        }
        Options.v().set_process_dir(Arrays.asList(this.applicationClassPath().split(File.pathSeparator)));
        Options.v().set_include(this.getIncludeList());
        Options.v().set_exclude(this.getExcludeList());
        Options.v().set_full_resolver(true);
        Scene.v().loadNecessaryClasses();
        Scene.v().setEntryPoints(this.getEntryPoints());
    }

    private List<SootMethod> getEntryPoints() {
        ArrayList entryPoints = Lists.newArrayList();
        entryPoints.addAll(EntryPoints.v().application());
        entryPoints.addAll(EntryPoints.v().methodsOfApplicationClasses());
        return entryPoints;
    }

    private List<String> getIncludeList() {
        LinkedList<String> includeList = new LinkedList<String>();
        includeList.add("java.lang.AbstractStringBuilder");
        includeList.add("java.lang.Boolean");
        includeList.add("java.lang.Byte");
        includeList.add("java.lang.Class");
        includeList.add("java.lang.Integer");
        includeList.add("java.lang.Long");
        includeList.add("java.lang.Object");
        includeList.add("java.lang.String");
        includeList.add("java.lang.StringCoding");
        includeList.add("java.lang.StringIndexOutOfBoundsException");
        return includeList;
    }

    private List<String> getExcludeList() {
        LinkedList<String> exList = new LinkedList<String>();
        List<CrySLRule> rules = this.getRules();
        for (CrySLRule r : rules) {
            exList.add(r.getClassName());
        }
        return exList;
    }

    protected abstract List<CrySLRule> getRules();

    public static void setRules(List<CrySLRule> rules) {
        HeadlessCryptoScanner.rules = rules;
    }

    protected abstract String applicationClassPath();

    protected CryptoScannerSettings.ControlGraph callGraphAlgorithm() {
        return settings.getControlGraph();
    }

    protected String sootClassPath() {
        return settings.getSootPath();
    }

    protected String softwareIdentifier() {
        return settings.getSoftwareIdentifier();
    }

    protected String getOutputFolder() {
        return settings.getReportDirectory();
    }

    protected boolean isPreAnalysis() {
        return settings.isPreAnalysis();
    }

    protected boolean enableVisualization() {
        return settings.isVisualization();
    }

    protected CryptoScannerSettings.ReportFormat reportFormat() {
        return settings.getReportFormat();
    }

    protected boolean providerDetection() {
        return settings.isProviderDetectionAnalysis();
    }

    private static String pathToJCE() {
        return System.getProperty("java.home") + File.separator + "lib" + File.separator + "jce.jar";
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    private boolean isModularProject() {
        String applicationClassPath = this.applicationClassPath();
        File dirName = new File(applicationClassPath);
        String moduleFile = dirName + File.separator + "module-info.class";
        boolean check = new File(moduleFile).exists();
        return check;
    }

    static {
        rules = Lists.newArrayList();
        LOGGER = LoggerFactory.getLogger(HeadlessCryptoScanner.class);
    }
}

