/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iem.crypto;

import boomerang.callgraph.BoomerangICFG;
import boomerang.callgraph.ObservableICFG;
import boomerang.callgraph.ObservableStaticICFG;
import boomerang.preanalysis.BoomerangPretransformer;
import com.google.common.collect.Lists;
import crypto.analysis.CrySLResultsReporter;
import crypto.analysis.CryptoScanner;
import crypto.analysis.ICrySLResultsListener;
import crypto.analysis.errors.AbstractError;
import crypto.exceptions.CryptoAnalysisException;
import crypto.reporting.CollectErrorListener;
import crypto.reporting.CommandLineReporter;
import crypto.rules.CrySLRule;
import crypto.rules.CrySLRuleReader;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.SetupApplication;
import soot.jimple.infoflow.android.config.SootConfigForAndroid;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.options.Options;

public class CogniCryptAndroidAnalysis {
    private static final Logger logger = LoggerFactory.getLogger(CogniCryptAndroidAnalysis.class);
    private final String apkFile;
    private final String platformsDirectory;
    private final String rulesDirectory;
    private final String outputDir;
    private final Collection<String> applicationClassFilter;

    public static void main(String ... args) throws CryptoAnalysisException {
        CogniCryptAndroidAnalysis analysis = args[3] != null ? new CogniCryptAndroidAnalysis(args[0], args[1], args[2], args[3], Lists.newArrayList()) : new CogniCryptAndroidAnalysis(args[0], args[1], args[2], Lists.newArrayList());
        analysis.run();
    }

    public CogniCryptAndroidAnalysis(String apkFile, String platformsDirectory, String rulesDirectory, Collection<String> applicationClassFilter) {
        this(apkFile, platformsDirectory, rulesDirectory, null, applicationClassFilter);
    }

    public CogniCryptAndroidAnalysis(String apkFile, String platformsDirectory, String rulesDirectory, String outputDir, Collection<String> applicationClassFilter) {
        this.apkFile = apkFile;
        this.platformsDirectory = platformsDirectory;
        this.rulesDirectory = rulesDirectory;
        this.applicationClassFilter = applicationClassFilter;
        this.outputDir = outputDir;
    }

    public Collection<AbstractError> run() throws CryptoAnalysisException {
        logger.info("Running static analysis on APK file " + this.apkFile);
        logger.info("with Android Platforms dir " + this.platformsDirectory);
        this.constructCallGraph();
        return this.runCryptoAnalysis();
    }

    public String getApkFile() {
        return this.apkFile;
    }

    public String getPlatformsDirectory() {
        return this.platformsDirectory;
    }

    public String getRulesDirectory() {
        return this.rulesDirectory;
    }

    public Collection<String> getApplicationClassFilter() {
        return this.applicationClassFilter;
    }

    private void constructCallGraph() {
        InfoflowAndroidConfiguration config = new InfoflowAndroidConfiguration();
        config.setCallgraphAlgorithm(InfoflowConfiguration.CallgraphAlgorithm.CHA);
        config.getCallbackConfig().setEnableCallbacks(false);
        config.setCodeEliminationMode(InfoflowConfiguration.CodeEliminationMode.NoCodeElimination);
        config.getAnalysisFileConfig().setAndroidPlatformDir(this.platformsDirectory);
        config.getAnalysisFileConfig().setTargetAPKFile(this.apkFile);
        config.setMergeDexFiles(true);
        SetupApplication flowDroid = new SetupApplication(config);
        SootConfigForAndroid sootConfigForAndroid = new SootConfigForAndroid(){

            public void setSootOptions(Options options, InfoflowConfiguration config) {
                options.set_keep_line_number(true);
            }
        };
        flowDroid.setSootConfig((IInfoflowConfig)sootConfigForAndroid);
        logger.info("Constructing call graph");
        flowDroid.constructCallgraph();
        logger.info("Done constructing call graph");
    }

    private Collection<AbstractError> runCryptoAnalysis() throws CryptoAnalysisException {
        this.prepareAnalysis();
        final ObservableStaticICFG icfg = new ObservableStaticICFG(new BoomerangICFG(false));
        List<CrySLRule> rules = this.getRules();
        final CrySLResultsReporter reporter = new CrySLResultsReporter();
        CollectErrorListener errorListener = new CollectErrorListener();
        reporter.addReportListener((ICrySLResultsListener)errorListener);
        reporter.addReportListener((ICrySLResultsListener)new CommandLineReporter(this.outputDir, rules));
        CryptoScanner scanner = new CryptoScanner(){

            public ObservableICFG<Unit, SootMethod> icfg() {
                return icfg;
            }

            public CrySLResultsReporter getAnalysisListener() {
                return reporter;
            }
        };
        logger.info("Loaded " + rules.size() + " CrySL rules");
        logger.info("Running CogniCrypt Analysis");
        scanner.scan(rules);
        logger.info("Finished CogniCrypt Analysis");
        System.gc();
        return errorListener.getErrors();
    }

    private void prepareAnalysis() {
        BoomerangPretransformer.v().reset();
        BoomerangPretransformer.v().apply();
        if (!this.applicationClassFilter.isEmpty()) {
            for (SootClass c : Scene.v().getClasses()) {
                for (String filter : this.applicationClassFilter) {
                    if (c.getName().contains(filter)) {
                        c.setApplicationClass();
                        continue;
                    }
                    c.setLibraryClass();
                }
            }
        }
        logger.info("Application classes: " + Scene.v().getApplicationClasses().size());
        logger.info("Library classes: " + Scene.v().getLibraryClasses().size());
    }

    protected List<CrySLRule> getRules() throws CryptoAnalysisException {
        if (this.rulesDirectory == null) {
            throw new RuntimeException("Please specify a directory the CrySL rules ( .crysl Files) are located in.");
        }
        CrySLRuleReader reader = new CrySLRuleReader();
        File[] listFiles = new File(this.rulesDirectory).listFiles();
        List<File> files = Arrays.asList(listFiles);
        List rules = reader.readFromSourceFiles(files);
        if (rules.isEmpty()) {
            throw new CryptoAnalysisException("No CrySL rules found in " + this.rulesDirectory);
        }
        return rules;
    }
}

