/*
 * Decompiled with CFR 0.152.
 */
package wpds.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.List;
import wpds.impl.NormalRule;
import wpds.impl.PopRule;
import wpds.impl.PushRule;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.IPushdownSystem;
import wpds.interfaces.Location;
import wpds.interfaces.State;
import wpds.wildcard.Wildcard;

public class PreStar<N extends Location, D extends State, W extends Weight> {
    private LinkedList<Transition<N, D>> worklist = Lists.newLinkedList();
    private IPushdownSystem<N, D, W> pds;
    private WeightedPAutomaton<N, D, W> fa;

    public WeightedPAutomaton<N, D, W> prestar(IPushdownSystem<N, D, W> pds, WeightedPAutomaton<N, D, W> initialAutomaton) {
        this.pds = pds;
        this.worklist = Lists.newLinkedList(initialAutomaton.getTransitions());
        this.fa = initialAutomaton;
        for (Transition<N, D> transition : Sets.newHashSet(this.fa.getTransitions())) {
            W w = this.fa.getOne();
            this.fa.addWeightForTransition(transition, w);
        }
        for (PopRule popRule : pds.getPopRules()) {
            this.update(new Transition(popRule.getS1(), popRule.getL1(), popRule.getS2()), popRule.getWeight(), Lists.newLinkedList());
        }
        while (!this.worklist.isEmpty()) {
            Transition<N, D> t2 = this.worklist.removeFirst();
            for (NormalRule<Object, Object, W> normalRule : pds.getNormalRulesEnding(t2.getStart(), t2.getLabel())) {
                LinkedList<Transition<N, D>> previous = Lists.newLinkedList();
                previous.add(t2);
                this.update(new Transition(normalRule.getS1(), normalRule.getL1(), t2.getTarget()), normalRule.getWeight(), previous);
            }
            for (PushRule<Object, Object, W> pushRule : pds.getPushRulesEnding(t2.getStart(), t2.getLabel())) {
                for (Transition transition : Sets.newHashSet(this.fa.getTransitions())) {
                    LinkedList<Transition<N, D>> previous;
                    if (transition.getLabel().equals(pushRule.getCallSite())) {
                        previous = Lists.newLinkedList();
                        previous.add(t2);
                        previous.add(transition);
                        this.update(new Transition(pushRule.getS1(), pushRule.getL1(), transition.getTarget()), pushRule.getWeight(), previous);
                        continue;
                    }
                    if (!(pushRule.getCallSite() instanceof Wildcard)) continue;
                    previous = Lists.newLinkedList();
                    previous.add(t2);
                    previous.add(transition);
                    this.update(new Transition<Object, Object>(pushRule.getS1(), transition.getLabel(), transition.getTarget()), pushRule.getWeight(), previous);
                }
            }
            for (PushRule<Object, Object, W> pushRule : pds.getPushRules()) {
                if (!(pushRule.getCallSite() instanceof Wildcard) && !pushRule.getCallSite().equals(t2.getString())) continue;
                Transition tdash = new Transition(pushRule.getS2(), pushRule.getL2(), t2.getTarget());
                if (!this.fa.getTransitions().contains(tdash)) continue;
                LinkedList<Transition<N, D>> linkedList = Lists.newLinkedList();
                linkedList.add(tdash);
                linkedList.add(t2);
                Object label = pushRule.getCallSite() instanceof Wildcard ? t2.getLabel() : pushRule.getL1();
                this.update(new Transition<Object, Object>(pushRule.getS1(), label, t2.getTarget()), pushRule.getWeight(), linkedList);
            }
        }
        return this.fa;
    }

    private void update(Transition<N, D> trans, W weight, List<Transition<N, D>> previous) {
        if (trans.getLabel() instanceof Wildcard) {
            throw new RuntimeException("INVALID TRANSITION");
        }
        this.fa.addTransition(trans);
        W lt = this.getOrCreateWeight(trans);
        Object fr = weight;
        for (Transition<N, D> prev : previous) {
            fr = ((Weight)fr).extendWith((Weight)this.getOrCreateWeight(prev));
        }
        Weight newLt = ((Weight)lt).combineWith((Weight)fr);
        this.fa.addWeightForTransition(trans, newLt);
        if (!lt.equals(newLt)) {
            this.worklist.add(trans);
        }
    }

    private W getOrCreateWeight(Transition<N, D> trans) {
        W w = this.fa.getWeightFor(trans);
        if (w != null) {
            return w;
        }
        W z = this.fa.getZero();
        return z;
    }
}

