/*
 * Decompiled with CFR 0.152.
 */
package typestate.impl.statemachines;

import boomerang.WeightedForwardQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;
import typestate.finiteautomata.TypeStateMachineWeightFunctions;

public class VectorStateMachine
extends TypeStateMachineWeightFunctions {
    public VectorStateMachine() {
        this.addTransition(new MatcherTransition((State)States.INIT, this.addElement(), MatcherTransition.Parameter.This, (State)States.NOT_EMPTY, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.INIT, this.accessElement(), MatcherTransition.Parameter.This, (State)States.ACCESSED_EMPTY, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.NOT_EMPTY, this.accessElement(), MatcherTransition.Parameter.This, (State)States.NOT_EMPTY, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.NOT_EMPTY, this.removeAllElements(), MatcherTransition.Parameter.This, (State)States.INIT, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.INIT, this.removeAllElements(), MatcherTransition.Parameter.This, (State)States.INIT, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.ACCESSED_EMPTY, this.accessElement(), MatcherTransition.Parameter.This, (State)States.ACCESSED_EMPTY, MatcherTransition.Type.OnReturn));
    }

    private Set<SootMethod> removeAllElements() {
        List<SootClass> vectorClasses = this.getSubclassesOf("java.util.Vector");
        Set<SootMethod> selectMethodByName = this.selectMethodByName(vectorClasses, "removeAllElements");
        return selectMethodByName;
    }

    private Set<SootMethod> addElement() {
        List<SootClass> vectorClasses = this.getSubclassesOf("java.util.Vector");
        Set<SootMethod> selectMethodByName = this.selectMethodByName(vectorClasses, "add|addAll|addElement|insertElementAt|set|setElementAt");
        selectMethodByName.add(Scene.v().getMethod("<java.util.Vector: void <init>(java.util.Collection)>"));
        return selectMethodByName;
    }

    private Set<SootMethod> accessElement() {
        List<SootClass> vectorClasses = this.getSubclassesOf("java.util.Vector");
        Set<SootMethod> selectMethodByName = this.selectMethodByName(vectorClasses, "elementAt|firstElement|lastElement|get");
        return selectMethodByName;
    }

    @Override
    public Collection<WeightedForwardQuery<TransitionFunction>> generateSeed(SootMethod m4, Unit unit) {
        if (m4.toString().contains("<clinit>")) {
            return Collections.emptySet();
        }
        return this.generateAtAllocationSiteOf(m4, unit, Vector.class);
    }

    @Override
    protected State initialState() {
        return States.INIT;
    }

    public static enum States implements State
    {
        INIT,
        NOT_EMPTY,
        ACCESSED_EMPTY;


        @Override
        public boolean isErrorState() {
            return this == ACCESSED_EMPTY;
        }

        @Override
        public boolean isInitialState() {
            return false;
        }

        @Override
        public boolean isAccepting() {
            return false;
        }
    }
}

