/*
 * Decompiled with CFR 0.152.
 */
package typestate.impl.statemachines;

import boomerang.WeightedForwardQuery;
import java.net.Socket;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;
import typestate.finiteautomata.TypeStateMachineWeightFunctions;

public class SocketStateMachine
extends TypeStateMachineWeightFunctions {
    public SocketStateMachine() {
        this.addTransition(new MatcherTransition((State)States.INIT, this.connect(), MatcherTransition.Parameter.This, (State)States.CONNECTED, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.ERROR, this.connect(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.CONNECTED, this.useMethods(), MatcherTransition.Parameter.This, (State)States.CONNECTED, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.INIT, this.useMethods(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.CONNECTED, this.connect(), MatcherTransition.Parameter.This, (State)States.CONNECTED, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.ERROR, this.useMethods(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnReturn));
    }

    private Set<SootMethod> socketConstructor() {
        List<SootClass> subclasses = this.getSubclassesOf("java.net.Socket");
        HashSet<SootMethod> out = new HashSet<SootMethod>();
        for (SootClass c : subclasses) {
            for (SootMethod m4 : c.getMethods()) {
                if (!m4.isConstructor()) continue;
                out.add(m4);
            }
        }
        return out;
    }

    private Set<SootMethod> connect() {
        return this.selectMethodByName(this.getSubclassesOf("java.net.Socket"), "connect");
    }

    private Set<SootMethod> useMethods() {
        List<SootClass> subclasses = this.getSubclassesOf("java.net.Socket");
        Set<SootMethod> connectMethod = this.connect();
        HashSet<SootMethod> out = new HashSet<SootMethod>();
        for (SootClass c : subclasses) {
            for (SootMethod m4 : c.getMethods()) {
                if (m4.isConstructor() || !m4.isPublic() || connectMethod.contains(m4) || m4.isStatic() || m4.getName().startsWith("is")) continue;
                out.add(m4);
            }
        }
        return out;
    }

    @Override
    public Collection<WeightedForwardQuery<TransitionFunction>> generateSeed(SootMethod m4, Unit unit) {
        return this.generateAtAllocationSiteOf(m4, unit, Socket.class);
    }

    @Override
    protected State initialState() {
        return States.INIT;
    }

    public static enum States implements State
    {
        INIT,
        CONNECTED,
        ERROR;


        @Override
        public boolean isErrorState() {
            return this == ERROR;
        }

        @Override
        public boolean isInitialState() {
            return false;
        }

        @Override
        public boolean isAccepting() {
            return false;
        }
    }
}

