/*
 * Decompiled with CFR 0.152.
 */
package typestate.impl.statemachines;

import boomerang.WeightedForwardQuery;
import boomerang.jimple.AllocVal;
import boomerang.jimple.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.Stmt;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;
import typestate.finiteautomata.TypeStateMachineWeightFunctions;

public class KeyStoreStateMachine
extends TypeStateMachineWeightFunctions {
    public KeyStoreStateMachine() {
        this.addTransition(new MatcherTransition((State)States.INIT, this.loadMethods(), MatcherTransition.Parameter.This, (State)States.LOADED, MatcherTransition.Type.OnCallToReturn));
        this.addTransition(new MatcherTransition((State)States.LOADED, this.anyMethodOtherThanLoad(), MatcherTransition.Parameter.This, (State)States.LOADED, MatcherTransition.Type.OnCallToReturn));
        this.addTransition(new MatcherTransition((State)States.INIT, this.anyMethodOtherThanLoad(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnCallToReturn));
        this.addTransition(new MatcherTransition((State)States.ERROR, this.anyMethodOtherThanLoad(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnCallToReturn));
    }

    private Set<SootMethod> anyMethodOtherThanLoad() {
        List<SootClass> subclasses = this.getSubclassesOf("java.security.KeyStore");
        Set<SootMethod> loadMethods = this.loadMethods();
        HashSet<SootMethod> out = new HashSet<SootMethod>();
        for (SootClass c : subclasses) {
            for (SootMethod m4 : c.getMethods()) {
                if (!m4.isPublic() || loadMethods.contains(m4) || m4.isStatic()) continue;
                out.add(m4);
            }
        }
        return out;
    }

    private Set<SootMethod> loadMethods() {
        return this.selectMethodByName(this.getSubclassesOf("java.security.KeyStore"), "load");
    }

    private Set<SootMethod> keyStoreConstructor() {
        List<SootClass> subclasses = this.getSubclassesOf("java.security.KeyStore");
        HashSet<SootMethod> out = new HashSet<SootMethod>();
        for (SootClass c : subclasses) {
            for (SootMethod m4 : c.getMethods()) {
                if (!m4.getName().equals("getInstance") || !m4.isStatic()) continue;
                out.add(m4);
            }
        }
        return out;
    }

    public Set<WeightedForwardQuery<TransitionFunction>> generateSeed(SootMethod m4, Unit unit) {
        AssignStmt stmt;
        if (unit instanceof AssignStmt && (stmt = (AssignStmt)unit).containsInvokeExpr() && this.keyStoreConstructor().contains(stmt.getInvokeExpr().getMethod())) {
            return Collections.singleton(new WeightedForwardQuery<TransitionFunction>(new Statement(stmt, m4), new AllocVal(stmt.getLeftOp(), m4, stmt.getRightOp(), new Statement((Stmt)unit, m4)), this.initialTransition()));
        }
        return Collections.emptySet();
    }

    @Override
    protected State initialState() {
        return States.INIT;
    }

    public static enum States implements State
    {
        NONE,
        INIT,
        LOADED,
        ERROR;


        @Override
        public boolean isErrorState() {
            return this == ERROR;
        }

        @Override
        public boolean isInitialState() {
            return false;
        }

        @Override
        public boolean isAccepting() {
            return false;
        }
    }
}

