/*
 * Decompiled with CFR 0.152.
 */
package typestate.impl.statemachines;

import boomerang.WeightedForwardQuery;
import boomerang.jimple.AllocVal;
import boomerang.jimple.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.Edge;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;
import typestate.finiteautomata.TypeStateMachineWeightFunctions;

public class HasNextStateMachine
extends TypeStateMachineWeightFunctions {
    private Set<SootMethod> hasNextMethods;
    private HashSet<SootMethod> res;

    public HasNextStateMachine() {
        this.addTransition(new MatcherTransition((State)States.INIT, this.retrieveNextMethods(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.ERROR, this.retrieveNextMethods(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.HASNEXT, this.retrieveNextMethods(), MatcherTransition.Parameter.This, (State)States.INIT, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.INIT, this.retrieveHasNextMethods(), MatcherTransition.Parameter.This, (State)States.HASNEXT, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.HASNEXT, this.retrieveHasNextMethods(), MatcherTransition.Parameter.This, (State)States.HASNEXT, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.ERROR, this.retrieveHasNextMethods(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnReturn));
    }

    private Set<SootMethod> retrieveHasNextMethods() {
        if (this.hasNextMethods == null) {
            this.hasNextMethods = this.selectMethodByName(this.getImplementersOfIterator("java.util.Iterator"), "hasNext");
        }
        return this.hasNextMethods;
    }

    private Set<SootMethod> retrieveNextMethods() {
        return this.selectMethodByName(this.getImplementersOfIterator("java.util.Iterator"), "next");
    }

    private Set<SootMethod> retrieveIteratorConstructors() {
        if (this.res != null) {
            return this.res;
        }
        Set<SootMethod> selectMethodByName = this.selectMethodByName(Scene.v().getClasses(), "iterator");
        this.res = new HashSet();
        for (SootMethod m4 : selectMethodByName) {
            RefType refType;
            SootClass classs;
            if (!(m4.getReturnType() instanceof RefType) || !(classs = (refType = (RefType)m4.getReturnType()).getSootClass()).equals(Scene.v().getSootClass("java.util.Iterator")) && !Scene.v().getActiveHierarchy().getImplementersOf(Scene.v().getSootClass("java.util.Iterator")).contains(classs)) continue;
            this.res.add(m4);
        }
        return this.res;
    }

    private List<SootClass> getImplementersOfIterator(String className) {
        SootClass sootClass = Scene.v().getSootClass(className);
        List<SootClass> list = Scene.v().getActiveHierarchy().getImplementersOf(sootClass);
        LinkedList<SootClass> res = new LinkedList<SootClass>();
        for (SootClass c : list) {
            res.add(c);
        }
        return res;
    }

    public Set<WeightedForwardQuery<TransitionFunction>> generateSeed(SootMethod method, Unit unit) {
        Iterator<Edge> edIt = Scene.v().getCallGraph().edgesOutOf(unit);
        while (edIt.hasNext()) {
            SootMethod m4 = edIt.next().getTgt().method();
            if (!this.retrieveIteratorConstructors().contains(m4)) continue;
            Stmt stmt = (Stmt)unit;
            InvokeExpr invokeExpr = stmt.getInvokeExpr();
            if (!(stmt instanceof AssignStmt)) continue;
            AssignStmt assignStmt = (AssignStmt)stmt;
            InstanceInvokeExpr iie = (InstanceInvokeExpr)invokeExpr;
            return Collections.singleton(new WeightedForwardQuery<TransitionFunction>(new Statement(stmt, method), new AllocVal(assignStmt.getLeftOp(), method, assignStmt.getLeftOp(), new Statement((Stmt)unit, m4)), this.initialTransition()));
        }
        return Collections.emptySet();
    }

    @Override
    public State initialState() {
        return States.INIT;
    }

    public static enum States implements State
    {
        NONE,
        INIT,
        HASNEXT,
        ERROR;


        @Override
        public boolean isErrorState() {
            return this == ERROR;
        }

        @Override
        public boolean isInitialState() {
            return false;
        }

        @Override
        public boolean isAccepting() {
            return false;
        }
    }
}

