/*
 * Decompiled with CFR 0.152.
 */
package typestate.finiteautomata;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootMethod;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.util.queue.QueueReader;
import typestate.finiteautomata.State;
import typestate.finiteautomata.Transition;

public class MatcherTransition
extends Transition {
    private Collection<SootMethod> matchingMethods = new HashSet<SootMethod>();
    private Type type;
    private Parameter param;

    public MatcherTransition(State from, String methodMatcher, Parameter param, State to, Type type) {
        super(from, to);
        this.type = type;
        this.param = param;
        ReachableMethods methods = Scene.v().getReachableMethods();
        QueueReader<MethodOrMethodContext> listener = methods.listener();
        while (listener.hasNext()) {
            MethodOrMethodContext next = listener.next();
            SootMethod method = next.method();
            if (!Pattern.matches(methodMatcher, method.getSignature())) continue;
            this.matchingMethods.add(method);
        }
    }

    public MatcherTransition(State from, Collection<SootMethod> matchingMethods, Parameter param, State to, Type type) {
        super(from, to);
        this.type = type;
        this.param = param;
        this.matchingMethods = matchingMethods;
    }

    public boolean matches(SootMethod method) {
        return this.matchingMethods.contains(method);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.matchingMethods == null ? 0 : this.matchingMethods.hashCode());
        result = 31 * result + (this.param == null ? 0 : this.param.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MatcherTransition other = (MatcherTransition)obj;
        if (this.matchingMethods == null ? other.matchingMethods != null : !this.matchingMethods.equals(other.matchingMethods)) {
            return false;
        }
        if (this.param != other.param) {
            return false;
        }
        return this.type == other.type;
    }

    public Parameter getParam() {
        return this.param;
    }

    @Override
    public String toString() {
        return super.toString() + " with " + this.matchingMethods;
    }

    public static enum Parameter {
        This,
        Param1,
        Param2;

    }

    public static enum Type {
        OnCall,
        OnReturn,
        None,
        OnCallToReturn,
        OnCallOrOnCallToReturn;

    }
}

