/*
 * Decompiled with CFR 0.152.
 */
package soot.validation;

import java.util.List;
import soot.Body;
import soot.Trap;
import soot.UnitPatchingChain;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum TrapsValidator implements BodyValidator
{
    INSTANCE;


    public static TrapsValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        UnitPatchingChain units = body.getUnits();
        for (Trap t2 : body.getTraps()) {
            if (!units.contains(t2.getBeginUnit())) {
                exception.add(new ValidationException(t2.getBeginUnit(), "begin not in chain in " + body.getMethod()));
            }
            if (!units.contains(t2.getEndUnit())) {
                exception.add(new ValidationException(t2.getEndUnit(), "end not in chain in " + body.getMethod()));
            }
            if (units.contains(t2.getHandlerUnit())) continue;
            exception.add(new ValidationException(t2.getHandlerUnit(), "handler not in chain in " + body.getMethod()));
        }
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

