/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import heros.solver.Pair;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.util.MultiMap;

public abstract class AbstractMultiMap<K, V>
implements MultiMap<K, V>,
Serializable {
    private static final long serialVersionUID = 4558567794548019671L;

    @Override
    public boolean putAll(MultiMap<K, V> m4) {
        boolean hasNew = false;
        for (K key : m4.keySet()) {
            if (!this.putAll(key, m4.get(key))) continue;
            hasNew = true;
        }
        return hasNew;
    }

    @Override
    public boolean putAll(Map<K, Set<V>> m4) {
        boolean hasNew = false;
        for (K key : m4.keySet()) {
            if (!this.putAll(key, m4.get(key))) continue;
            hasNew = true;
        }
        return hasNew;
    }

    @Override
    public boolean isEmpty() {
        return this.numKeys() == 0;
    }

    @Override
    public boolean contains(K key, V value) {
        Set set = this.get(key);
        if (set == null) {
            return false;
        }
        return set.contains(value);
    }

    @Override
    public Iterator<Pair<K, V>> iterator() {
        return new EntryIterator();
    }

    @Override
    public boolean putMap(Map<K, V> m4) {
        boolean hasNew = false;
        for (Map.Entry<K, V> entry : m4.entrySet()) {
            if (!this.put(entry.getKey(), entry.getValue())) continue;
            hasNew = true;
        }
        return hasNew;
    }

    private class EntryIterator
    implements Iterator<Pair<K, V>> {
        Iterator<K> keyIterator;
        Iterator<V> valueIterator;
        K currentKey;

        private EntryIterator() {
            this.keyIterator = AbstractMultiMap.this.keySet().iterator();
            this.valueIterator = null;
            this.currentKey = null;
        }

        @Override
        public boolean hasNext() {
            if (this.valueIterator != null && this.valueIterator.hasNext()) {
                return true;
            }
            this.valueIterator = null;
            this.currentKey = null;
            return this.keyIterator.hasNext();
        }

        @Override
        public Pair<K, V> next() {
            if (this.valueIterator == null) {
                this.currentKey = this.keyIterator.next();
                this.valueIterator = AbstractMultiMap.this.get(this.currentKey).iterator();
            }
            return new Pair(this.currentKey, this.valueIterator.next());
        }

        @Override
        public void remove() {
            if (this.valueIterator == null) {
                return;
            }
            this.valueIterator.remove();
            if (AbstractMultiMap.this.get(this.currentKey).isEmpty()) {
                this.keyIterator.remove();
                this.valueIterator = null;
                this.currentKey = null;
            }
        }
    }
}

