/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.IdentityUnit;
import soot.Local;
import soot.Timers;
import soot.Trap;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.ExceptionalGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.FlowAnalysis;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.toolkits.scalar.LocalDefs;

public class SimpleLocalDefs
implements LocalDefs {
    private LocalDefs def;

    public SimpleLocalDefs(UnitGraph graph) {
        this(graph, FlowAnalysisMode.Automatic);
    }

    public SimpleLocalDefs(UnitGraph graph, FlowAnalysisMode mode) {
        this((DirectedGraph<Unit>)graph, graph.getBody().getLocals(), mode);
    }

    SimpleLocalDefs(DirectedGraph<Unit> graph, Collection<Local> locals, FlowAnalysisMode mode) {
        this(graph, locals.toArray(new Local[locals.size()]), mode);
    }

    SimpleLocalDefs(DirectedGraph<Unit> graph, Local[] locals, boolean omitSSA) {
        this(graph, locals, omitSSA ? FlowAnalysisMode.OmitSSA : FlowAnalysisMode.Automatic);
    }

    SimpleLocalDefs(DirectedGraph<Unit> graph, Local[] locals, FlowAnalysisMode mode) {
        int i;
        Options options = Options.v();
        if (options.time()) {
            Timers.v().defsTimer.start();
        }
        int N2 = locals.length;
        int[] oldNumbers = new int[N2];
        for (i = 0; i < N2; ++i) {
            oldNumbers[i] = locals[i].getNumber();
            locals[i].setNumber(i);
        }
        this.init(graph, locals, mode);
        for (i = 0; i < N2; ++i) {
            locals[i].setNumber(oldNumbers[i]);
        }
        if (options.time()) {
            Timers.v().defsTimer.end();
        }
    }

    private void init(DirectedGraph<Unit> graph, Local[] locals, FlowAnalysisMode mode) {
        boolean omitSSA;
        Object[] unitList = new List[locals.length];
        Arrays.fill(unitList, Collections.emptyList());
        boolean doFlowAnalsis = omitSSA = mode == FlowAnalysisMode.OmitSSA;
        int units = 0;
        for (Unit unit : graph) {
            block5: for (ValueBox box : unit.getDefBoxes()) {
                Value v = box.getValue();
                if (!(v instanceof Local)) continue;
                Local l = (Local)v;
                int lno = l.getNumber();
                switch (unitList[lno].size()) {
                    case 0: {
                        unitList[lno] = Collections.singletonList(unit);
                        if (!omitSSA) continue block5;
                        ++units;
                        continue block5;
                    }
                    case 1: {
                        if (!omitSSA) {
                            ++units;
                        }
                        unitList[lno] = new ArrayList(unitList[lno]);
                        doFlowAnalsis = true;
                    }
                }
                unitList[lno].add(unit);
                ++units;
            }
        }
        this.def = doFlowAnalsis && mode != FlowAnalysisMode.FlowInsensitive ? new FlowAssignment(graph, locals, (List<Unit>[])unitList, units, omitSSA) : new StaticSingleAssignment(locals, (List<Unit>[])unitList);
    }

    @Override
    public List<Unit> getDefsOfAt(Local l, Unit s2) {
        return this.def.getDefsOfAt(l, s2);
    }

    @Override
    public List<Unit> getDefsOf(Local l) {
        return this.def.getDefsOf(l);
    }

    static enum FlowAnalysisMode {
        Automatic,
        OmitSSA,
        FlowInsensitive;

    }

    private static class FlowAssignment
    extends ForwardFlowAnalysis<Unit, FlowBitSet>
    implements LocalDefs {
        final Map<Local, Integer> locals;
        final List<Unit>[] unitList;
        final int[] localRange;
        final Unit[] universe;
        private Map<Unit, Integer> indexOfUnit;

        FlowAssignment(DirectedGraph<Unit> graph, Local[] locals, List<Unit>[] unitList, int units, boolean omitSSA) {
            super(graph);
            int N2 = locals.length;
            this.locals = new HashMap<Local, Integer>(N2 * 3 / 2 + 7);
            this.unitList = unitList;
            this.universe = new Unit[units];
            this.indexOfUnit = new HashMap<Unit, Integer>(units);
            this.localRange = new int[N2 + 1];
            int j = 0;
            int i = 0;
            while (i < N2) {
                if (!unitList[i].isEmpty()) {
                    this.locals.put(locals[i], i);
                    if (unitList[i].size() >= 2) {
                        for (Unit u : unitList[i]) {
                            this.indexOfUnit.put(u, j);
                            this.universe[j++] = u;
                        }
                    } else if (omitSSA) {
                        this.universe[j++] = unitList[i].get(0);
                    }
                }
                this.localRange[++i] = j;
            }
            assert (this.localRange[N2] == units);
            this.doAnalysis();
            this.indexOfUnit.clear();
            this.indexOfUnit = null;
        }

        @Override
        public List<Unit> getDefsOfAt(Local l, Unit s2) {
            Integer lno = this.locals.get(l);
            if (lno == null) {
                return Collections.emptyList();
            }
            int from = this.localRange[lno];
            int to = this.localRange[lno + 1];
            assert (from <= to);
            if (from == to) {
                assert (this.unitList[lno].size() == 1);
                return this.unitList[lno];
            }
            return ((FlowBitSet)this.getFlowBefore(s2)).asList(from, to);
        }

        @Override
        protected boolean omissible(Unit u) {
            if (u.getDefBoxes().isEmpty()) {
                return true;
            }
            for (ValueBox vb : u.getDefBoxes()) {
                Value v = vb.getValue();
                if (!(v instanceof Local)) continue;
                Local l = (Local)v;
                int lno = l.getNumber();
                return this.localRange[lno] == this.localRange[lno + 1];
            }
            return true;
        }

        @Override
        protected FlowAnalysis.Flow getFlow(Unit from, Unit to) {
            ExceptionalGraph g2;
            if (to instanceof IdentityUnit && this.graph instanceof ExceptionalGraph && !(g2 = (ExceptionalGraph)this.graph).getExceptionalPredsOf(to).isEmpty()) {
                for (ExceptionalGraph.ExceptionDest<Unit> exd : g2.getExceptionDests(from)) {
                    Trap trap = exd.getTrap();
                    if (null == trap || trap.getHandlerUnit() != to) continue;
                    return FlowAnalysis.Flow.IN;
                }
            }
            return FlowAnalysis.Flow.OUT;
        }

        @Override
        protected void flowThrough(FlowBitSet in, Unit unit, FlowBitSet out) {
            this.copy(in, out);
            for (ValueBox vb : unit.getDefBoxes()) {
                int to;
                Local l;
                int lno;
                int from;
                Value v = vb.getValue();
                if (!(v instanceof Local) || (from = this.localRange[lno = (l = (Local)v).getNumber()]) == (to = this.localRange[1 + lno])) continue;
                assert (from <= to);
                if (to - from == 1) {
                    out.set(from);
                    continue;
                }
                out.clear(from, to);
                out.set(this.indexOfUnit.get(unit));
            }
        }

        @Override
        protected void copy(FlowBitSet source, FlowBitSet dest) {
            if (dest == source) {
                return;
            }
            dest.clear();
            dest.or(source);
        }

        @Override
        protected FlowBitSet newInitialFlow() {
            return new FlowBitSet();
        }

        @Override
        protected void mergeInto(Unit succNode, FlowBitSet inout, FlowBitSet in) {
            inout.or(in);
        }

        @Override
        protected void merge(FlowBitSet in1, FlowBitSet in2, FlowBitSet out) {
            throw new UnsupportedOperationException("should never be called");
        }

        @Override
        public List<Unit> getDefsOf(Local l) {
            ArrayList<Unit> defs = new ArrayList<Unit>();
            for (Unit u : this.graph) {
                List<Unit> defsOf = this.getDefsOfAt(l, u);
                if (defsOf == null) continue;
                defs.addAll(defsOf);
            }
            return defs;
        }

        class FlowBitSet
        extends BitSet {
            private static final long serialVersionUID = -8348696077189400377L;

            FlowBitSet() {
                super(FlowAssignment.this.universe.length);
            }

            List<Unit> asList(int fromIndex, int toIndex) {
                FlowBitSet bits = this;
                if (FlowAssignment.this.universe.length < toIndex || toIndex < fromIndex || fromIndex < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (fromIndex == toIndex) {
                    return Collections.emptyList();
                }
                if (fromIndex == toIndex - 1) {
                    if (bits.get(fromIndex)) {
                        return Collections.singletonList(FlowAssignment.this.universe[fromIndex]);
                    }
                    return Collections.emptyList();
                }
                int i = bits.nextSetBit(fromIndex);
                if (i < 0 || i >= toIndex) {
                    return Collections.emptyList();
                }
                if (i == toIndex - 1) {
                    return Collections.singletonList(FlowAssignment.this.universe[i]);
                }
                ArrayList<Unit> elements = new ArrayList<Unit>(toIndex - i);
                do {
                    int endOfRun = Math.min(toIndex, bits.nextClearBit(i + 1));
                    do {
                        elements.add(FlowAssignment.this.universe[i++]);
                    } while (i < endOfRun);
                } while (i < toIndex && (i = bits.nextSetBit(i + 1)) >= 0 && i < toIndex);
                return elements;
            }
        }
    }

    private static class StaticSingleAssignment
    implements LocalDefs {
        final Map<Local, List<Unit>> result;

        StaticSingleAssignment(Local[] locals, List<Unit>[] unitList) {
            assert (locals.length == unitList.length);
            int N2 = locals.length;
            this.result = new HashMap<Local, List<Unit>>(N2 * 3 / 2 + 7);
            for (int i = 0; i < N2; ++i) {
                if (unitList[i].isEmpty()) continue;
                assert (unitList[i].size() == 1);
                this.result.put(locals[i], unitList[i]);
            }
        }

        @Override
        public List<Unit> getDefsOfAt(Local l, Unit s2) {
            List<Unit> lst = this.result.get(l);
            if (lst == null) {
                return Collections.emptyList();
            }
            return lst;
        }

        @Override
        public List<Unit> getDefsOf(Local l) {
            return this.getDefsOfAt(l, null);
        }
    }
}

