/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.G;
import soot.Singletons;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.Orderer;

public class SlowPseudoTopologicalOrderer<N>
implements Orderer<N> {
    private Map<N, Integer> stmtToColor;
    private static final int WHITE = 0;
    private static final int GRAY = 1;
    private static final int BLACK = 2;
    private LinkedList<N> order;
    private boolean mIsReversed = false;
    private DirectedGraph<N> graph;
    private List<N> reverseOrder;
    private final HashMap<N, List<N>> succsMap = new HashMap();

    public SlowPseudoTopologicalOrderer(Singletons.Global g2) {
    }

    public static SlowPseudoTopologicalOrderer v() {
        return G.v().soot_toolkits_graph_SlowPseudoTopologicalOrderer();
    }

    public SlowPseudoTopologicalOrderer() {
    }

    public SlowPseudoTopologicalOrderer(boolean isReversed) {
        this.mIsReversed = isReversed;
    }

    @Override
    public List<N> newList(DirectedGraph<N> g2, boolean reverse) {
        this.mIsReversed = reverse;
        return this.computeOrder(g2);
    }

    LinkedList<N> computeOrder(DirectedGraph<N> g2) {
        this.stmtToColor = new HashMap<N, Integer>();
        this.order = new LinkedList();
        this.graph = g2;
        PseudoTopologicalReverseOrderer<N> orderer = new PseudoTopologicalReverseOrderer<N>();
        this.reverseOrder = orderer.newList(g2);
        for (N s2 : g2) {
            this.stmtToColor.put(s2, 0);
        }
        for (N s2 : g2) {
            if (this.stmtToColor.get(s2) != 0) continue;
            this.visitNode(s2);
        }
        return this.order;
    }

    private void visitNode(N startStmt) {
        LinkedList<N> stmtStack = new LinkedList<N>();
        LinkedList<Integer> indexStack = new LinkedList<Integer>();
        this.stmtToColor.put(startStmt, 1);
        stmtStack.addLast(startStmt);
        indexStack.addLast(-1);
        while (!stmtStack.isEmpty()) {
            N childNode;
            int toVisitIndex = (Integer)indexStack.removeLast();
            Object toVisitNode = stmtStack.getLast();
            indexStack.addLast(++toVisitIndex);
            if (toVisitIndex >= this.graph.getSuccsOf(toVisitNode).size()) {
                if (this.mIsReversed) {
                    this.order.addLast(toVisitNode);
                } else {
                    this.order.addFirst(toVisitNode);
                }
                this.stmtToColor.put(toVisitNode, 2);
                stmtStack.removeLast();
                indexStack.removeLast();
                continue;
            }
            List<N> orderedSuccs = this.succsMap.get(toVisitNode);
            if (orderedSuccs == null) {
                orderedSuccs = new LinkedList<N>();
                this.succsMap.put(toVisitNode, orderedSuccs);
                List<N> allsuccs = this.graph.getSuccsOf(toVisitNode);
                for (int i = 0; i < allsuccs.size(); ++i) {
                    int j;
                    N cur = allsuccs.get(i);
                    for (j = 0; j < orderedSuccs.size(); ++j) {
                        int idx2;
                        N comp = orderedSuccs.get(j);
                        int idx1 = this.reverseOrder.indexOf(cur);
                        if (idx1 < (idx2 = this.reverseOrder.indexOf(comp))) break;
                    }
                    orderedSuccs.add(j, cur);
                }
            }
            if (this.stmtToColor.get(childNode = orderedSuccs.get(toVisitIndex)) != 0) continue;
            this.stmtToColor.put(childNode, 1);
            stmtStack.addLast(childNode);
            indexStack.addLast(-1);
        }
    }

    @Deprecated
    public List<N> newList(DirectedGraph<N> g2) {
        return this.computeOrder(g2);
    }

    @Deprecated
    public void setReverseOrder(boolean isReversed) {
        this.mIsReversed = isReversed;
    }

    @Deprecated
    public boolean isReverseOrder() {
        return this.mIsReversed;
    }

    private class PseudoTopologicalReverseOrderer<N> {
        private Map<N, Integer> stmtToColor;
        private static final int WHITE = 0;
        private static final int GRAY = 1;
        private static final int BLACK = 2;
        private LinkedList<N> order;
        private final boolean mIsReversed = false;
        private DirectedGraph<N> graph;

        private PseudoTopologicalReverseOrderer() {
        }

        List<N> newList(DirectedGraph<N> g2) {
            return this.computeOrder(g2);
        }

        LinkedList<N> computeOrder(DirectedGraph<N> g2) {
            this.stmtToColor = new HashMap<N, Integer>();
            this.order = new LinkedList();
            this.graph = g2;
            for (N s2 : g2) {
                this.stmtToColor.put(s2, 0);
            }
            for (N s2 : g2) {
                if (this.stmtToColor.get(s2) != 0) continue;
                this.visitNode(s2);
            }
            return this.order;
        }

        private void visitNode(N startStmt) {
            LinkedList<N> stmtStack = new LinkedList<N>();
            LinkedList<Integer> indexStack = new LinkedList<Integer>();
            this.stmtToColor.put(startStmt, 1);
            stmtStack.addLast(startStmt);
            indexStack.addLast(-1);
            while (!stmtStack.isEmpty()) {
                int toVisitIndex = (Integer)indexStack.removeLast();
                Object toVisitNode = stmtStack.getLast();
                indexStack.addLast(++toVisitIndex);
                if (toVisitIndex >= this.graph.getPredsOf(toVisitNode).size()) {
                    this.order.addFirst(toVisitNode);
                    this.stmtToColor.put(toVisitNode, 2);
                    stmtStack.removeLast();
                    indexStack.removeLast();
                    continue;
                }
                N childNode = this.graph.getPredsOf(toVisitNode).get(toVisitIndex);
                if (this.stmtToColor.get(childNode) != 0) continue;
                this.stmtToColor.put(childNode, 1);
                stmtStack.addLast(childNode);
                indexStack.addLast(-1);
            }
        }
    }
}

