/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.toolkits.graph.HashMutableDirectedGraph;
import soot.toolkits.graph.MutableDirectedGraph;
import soot.toolkits.graph.MutableEdgeLabelledDirectedGraph;

public class HashMutableEdgeLabelledDirectedGraph<N, L>
implements MutableEdgeLabelledDirectedGraph<N, L> {
    private static final Logger logger = LoggerFactory.getLogger(HashMutableEdgeLabelledDirectedGraph.class);
    protected Map<N, List<N>> nodeToPreds = new HashMap<N, List<N>>();
    protected Map<N, List<N>> nodeToSuccs = new HashMap<N, List<N>>();
    protected Map<DGEdge<N>, List<L>> edgeToLabels = new HashMap<DGEdge<N>, List<L>>();
    protected Map<L, List<DGEdge<N>>> labelToEdges = new HashMap<L, List<DGEdge<N>>>();
    protected Set<N> heads = new HashSet<N>();
    protected Set<N> tails = new HashSet<N>();

    private static <T> List<T> getCopy(Collection<? extends T> c) {
        return Collections.unmodifiableList(new ArrayList<T>(c));
    }

    public void clearAll() {
        this.nodeToPreds.clear();
        this.nodeToSuccs.clear();
        this.edgeToLabels.clear();
        this.labelToEdges.clear();
        this.heads.clear();
        this.tails.clear();
    }

    public HashMutableEdgeLabelledDirectedGraph<N, L> clone() {
        HashMutableEdgeLabelledDirectedGraph<N, L> g2 = new HashMutableEdgeLabelledDirectedGraph<N, L>();
        g2.nodeToPreds.putAll(this.nodeToPreds);
        g2.nodeToSuccs.putAll(this.nodeToSuccs);
        g2.edgeToLabels.putAll(this.edgeToLabels);
        g2.labelToEdges.putAll(this.labelToEdges);
        g2.heads.addAll(this.heads);
        g2.tails.addAll(this.tails);
        return g2;
    }

    @Override
    public List<N> getHeads() {
        return HashMutableEdgeLabelledDirectedGraph.getCopy(this.heads);
    }

    @Override
    public List<N> getTails() {
        return HashMutableEdgeLabelledDirectedGraph.getCopy(this.tails);
    }

    @Override
    public List<N> getPredsOf(N s2) {
        List<N> preds = this.nodeToPreds.get(s2);
        if (preds != null) {
            return Collections.unmodifiableList(preds);
        }
        throw new RuntimeException(s2 + "not in graph!");
    }

    @Override
    public List<N> getSuccsOf(N s2) {
        List<N> succs = this.nodeToSuccs.get(s2);
        if (succs != null) {
            return Collections.unmodifiableList(succs);
        }
        throw new RuntimeException(s2 + "not in graph!");
    }

    @Override
    public int size() {
        return this.nodeToPreds.keySet().size();
    }

    @Override
    public Iterator<N> iterator() {
        return this.nodeToPreds.keySet().iterator();
    }

    @Override
    public void addEdge(N from, N to, L label) {
        DGEdge<N> edge;
        if (from == null || to == null) {
            throw new RuntimeException("edge from or to null");
        }
        if (label == null) {
            throw new RuntimeException("edge with null label");
        }
        if (this.containsEdge(from, to, label)) {
            return;
        }
        List<N> succsList = this.nodeToSuccs.get(from);
        if (succsList == null) {
            throw new RuntimeException(from + " not in graph!");
        }
        List<N> predsList = this.nodeToPreds.get(to);
        if (predsList == null) {
            throw new RuntimeException(to + " not in graph!");
        }
        this.heads.remove(to);
        this.tails.remove(from);
        if (!succsList.contains(to)) {
            succsList.add(to);
        }
        if (!predsList.contains(from)) {
            predsList.add(from);
        }
        if (!this.edgeToLabels.containsKey(edge = new DGEdge<N>(from, to))) {
            this.edgeToLabels.put(edge, new ArrayList());
        }
        List<L> labels = this.edgeToLabels.get(edge);
        if (!this.labelToEdges.containsKey(label)) {
            this.labelToEdges.put(label, new ArrayList());
        }
        List<DGEdge<N>> edges = this.labelToEdges.get(label);
        labels.add(label);
        edges.add(edge);
    }

    @Override
    public List<L> getLabelsForEdges(N from, N to) {
        DGEdge<N> edge = new DGEdge<N>(from, to);
        return this.edgeToLabels.get(edge);
    }

    @Override
    public MutableDirectedGraph<N> getEdgesForLabel(L label) {
        List<DGEdge<N>> edges = this.labelToEdges.get(label);
        HashMutableDirectedGraph<N> ret = new HashMutableDirectedGraph<N>();
        if (edges == null) {
            return ret;
        }
        for (DGEdge<N> edge : edges) {
            if (!ret.containsNode(edge.from())) {
                ret.addNode(edge.from());
            }
            if (!ret.containsNode(edge.to())) {
                ret.addNode(edge.to());
            }
            ret.addEdge(edge.from(), edge.to());
        }
        return ret;
    }

    @Override
    public void removeEdge(N from, N to, L label) {
        if (!this.containsEdge(from, to, label)) {
            return;
        }
        DGEdge<N> edge = new DGEdge<N>(from, to);
        List<L> labels = this.edgeToLabels.get(edge);
        if (labels == null) {
            throw new RuntimeException("edge " + edge + " not in graph!");
        }
        List<DGEdge<N>> edges = this.labelToEdges.get(label);
        if (edges == null) {
            throw new RuntimeException("label " + label + " not in graph!");
        }
        labels.remove(label);
        edges.remove(edge);
        if (labels.isEmpty()) {
            this.edgeToLabels.remove(edge);
            List<N> succsList = this.nodeToSuccs.get(from);
            if (succsList == null) {
                throw new RuntimeException(from + " not in graph!");
            }
            List<N> predsList = this.nodeToPreds.get(to);
            if (predsList == null) {
                throw new RuntimeException(to + " not in graph!");
            }
            succsList.remove(to);
            predsList.remove(from);
            if (succsList.isEmpty()) {
                this.tails.add(from);
            }
            if (predsList.isEmpty()) {
                this.heads.add(to);
            }
        }
        if (edges.isEmpty()) {
            this.labelToEdges.remove(label);
        }
    }

    @Override
    public void removeAllEdges(N from, N to) {
        if (!this.containsAnyEdge(from, to)) {
            return;
        }
        DGEdge<N> edge = new DGEdge<N>(from, to);
        List<L> labels = this.edgeToLabels.get(edge);
        if (labels == null) {
            throw new RuntimeException("edge " + edge + " not in graph!");
        }
        for (L label : HashMutableEdgeLabelledDirectedGraph.getCopy(labels)) {
            this.removeEdge(from, to, label);
        }
    }

    @Override
    public void removeAllEdges(L label) {
        if (!this.containsAnyEdge(label)) {
            return;
        }
        List<DGEdge<N>> edges = this.labelToEdges.get(label);
        if (edges == null) {
            throw new RuntimeException("label " + label + " not in graph!");
        }
        for (DGEdge<N> edge : HashMutableEdgeLabelledDirectedGraph.getCopy(edges)) {
            this.removeEdge(edge.from(), edge.to(), label);
        }
    }

    @Override
    public boolean containsEdge(N from, N to, L label) {
        List<L> labels = this.edgeToLabels.get(new DGEdge<N>(from, to));
        return labels != null && labels.contains(label);
    }

    @Override
    public boolean containsAnyEdge(N from, N to) {
        List<L> labels = this.edgeToLabels.get(new DGEdge<N>(from, to));
        return labels != null && !labels.isEmpty();
    }

    @Override
    public boolean containsAnyEdge(L label) {
        List<DGEdge<N>> edges = this.labelToEdges.get(label);
        return edges != null && !edges.isEmpty();
    }

    @Override
    public boolean containsNode(N node) {
        return this.nodeToPreds.keySet().contains(node);
    }

    @Override
    public void addNode(N node) {
        if (this.containsNode(node)) {
            throw new RuntimeException("Node already in graph");
        }
        this.nodeToSuccs.put(node, new ArrayList());
        this.nodeToPreds.put(node, new ArrayList());
        this.heads.add(node);
        this.tails.add(node);
    }

    @Override
    public void removeNode(N node) {
        for (Object n : new ArrayList(this.nodeToSuccs.get(node))) {
            this.removeAllEdges(node, n);
        }
        this.nodeToSuccs.remove(node);
        for (Object n : new ArrayList(this.nodeToPreds.get(node))) {
            this.removeAllEdges(n, node);
        }
        this.nodeToPreds.remove(node);
        this.heads.remove(node);
        this.tails.remove(node);
    }

    public void printGraph() {
        for (N node : this) {
            List<L> labels;
            DGEdge<N> edge;
            logger.debug("Node = " + node);
            logger.debug("Preds:");
            for (N pred : this.getPredsOf(node)) {
                edge = new DGEdge<N>(pred, node);
                labels = this.edgeToLabels.get(edge);
                logger.debug("     " + pred + " [" + labels + "]");
            }
            logger.debug("Succs:");
            for (N succ : this.getSuccsOf(node)) {
                edge = new DGEdge<N>(node, succ);
                labels = this.edgeToLabels.get(edge);
                logger.debug("     " + succ + " [" + labels + "]");
            }
        }
    }

    private static class DGEdge<N> {
        N from;
        N to;

        public DGEdge(N from, N to) {
            this.from = from;
            this.to = to;
        }

        public N from() {
            return this.from;
        }

        public N to() {
            return this.to;
        }

        public boolean equals(Object o) {
            if (o instanceof DGEdge) {
                DGEdge other = (DGEdge)o;
                return this.from.equals(other.from) && this.to.equals(other.to);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.from, this.to});
        }
    }
}

