/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.RefType;
import soot.Scene;
import soot.Timers;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.baf.Inst;
import soot.baf.NewInst;
import soot.baf.ReturnInst;
import soot.baf.ReturnVoidInst;
import soot.baf.StaticGetInst;
import soot.baf.StaticPutInst;
import soot.baf.ThrowInst;
import soot.jimple.InvokeExpr;
import soot.jimple.NewExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.options.Options;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.exceptions.ThrowableSet;
import soot.toolkits.graph.ExceptionalGraph;
import soot.toolkits.graph.UnitGraph;
import soot.util.ArraySet;
import soot.util.PhaseDumper;

public class ExceptionalUnitGraph
extends UnitGraph
implements ExceptionalGraph<Unit> {
    protected Map<Unit, List<Unit>> unitToUnexceptionalSuccs;
    protected Map<Unit, List<Unit>> unitToUnexceptionalPreds;
    protected Map<Unit, List<Unit>> unitToExceptionalSuccs;
    protected Map<Unit, List<Unit>> unitToExceptionalPreds;
    protected Map<Unit, Collection<ExceptionDest>> unitToExceptionDests;
    protected ThrowAnalysis throwAnalysis;

    public ExceptionalUnitGraph(Body body, ThrowAnalysis throwAnalysis, boolean omitExceptingUnitEdges) {
        super(body);
        this.initialize(throwAnalysis, omitExceptingUnitEdges);
    }

    public ExceptionalUnitGraph(Body body, ThrowAnalysis throwAnalysis) {
        this(body, throwAnalysis, Options.v().omit_excepting_unit_edges());
    }

    public ExceptionalUnitGraph(Body body) {
        this(body, Scene.v().getDefaultThrowAnalysis(), Options.v().omit_excepting_unit_edges());
    }

    protected ExceptionalUnitGraph(Body body, boolean ignoredBogusParameter) {
        super(body);
    }

    protected void initialize(ThrowAnalysis throwAnalysis, boolean omitExceptingUnitEdges) {
        int size = this.unitChain.size();
        Set<Unit> trapUnitsThatAreHeads = Collections.emptySet();
        if (Options.v().time()) {
            Timers.v().graphTimer.start();
        }
        this.unitToUnexceptionalSuccs = new LinkedHashMap<Unit, List<Unit>>(size * 2 + 1, 0.7f);
        this.unitToUnexceptionalPreds = new LinkedHashMap<Unit, List<Unit>>(size * 2 + 1, 0.7f);
        this.buildUnexceptionalEdges(this.unitToUnexceptionalSuccs, this.unitToUnexceptionalPreds);
        this.throwAnalysis = throwAnalysis;
        if (this.body.getTraps().size() == 0) {
            this.unitToExceptionDests = Collections.emptyMap();
            this.unitToExceptionalSuccs = Collections.emptyMap();
            this.unitToExceptionalPreds = Collections.emptyMap();
            this.unitToSuccs = this.unitToUnexceptionalSuccs;
            this.unitToPreds = this.unitToUnexceptionalPreds;
        } else {
            this.unitToExceptionDests = this.buildExceptionDests(throwAnalysis);
            this.unitToExceptionalSuccs = new LinkedHashMap<Unit, List<Unit>>(this.unitToExceptionDests.size() * 2 + 1, 0.7f);
            this.unitToExceptionalPreds = new LinkedHashMap<Unit, List<Unit>>(this.body.getTraps().size() * 2 + 1, 0.7f);
            trapUnitsThatAreHeads = this.buildExceptionalEdges(throwAnalysis, this.unitToExceptionDests, this.unitToExceptionalSuccs, this.unitToExceptionalPreds, omitExceptingUnitEdges);
            this.unitToSuccs = this.combineMapValues(this.unitToUnexceptionalSuccs, this.unitToExceptionalSuccs);
            this.unitToPreds = this.combineMapValues(this.unitToUnexceptionalPreds, this.unitToExceptionalPreds);
        }
        this.buildHeadsAndTails(trapUnitsThatAreHeads);
        if (Options.v().time()) {
            Timers.v().graphTimer.end();
        }
        PhaseDumper.v().dumpGraph(this);
    }

    protected Map<Unit, Collection<ExceptionDest>> buildExceptionDests(ThrowAnalysis throwAnalysis) {
        UnitPatchingChain units = this.body.getUnits();
        LinkedHashMap<Unit, ThrowableSet> unitToUncaughtThrowables = new LinkedHashMap<Unit, ThrowableSet>(units.size());
        Map<Unit, Collection<ExceptionDest>> result = null;
        for (Trap trap : this.body.getTraps()) {
            RefType catcher = trap.getException().getType();
            Iterator<Unit> unitIt = units.iterator(trap.getBeginUnit(), units.getPredOf(trap.getEndUnit()));
            while (unitIt.hasNext()) {
                ThrowableSet.Pair catchableAs;
                Unit unit = unitIt.next();
                ThrowableSet thrownSet = (ThrowableSet)unitToUncaughtThrowables.get(unit);
                if (thrownSet == null) {
                    thrownSet = throwAnalysis.mightThrow(unit);
                }
                if (!(catchableAs = thrownSet.whichCatchableAs(catcher)).getCaught().equals(ThrowableSet.Manager.v().EMPTY)) {
                    result = this.addDestToMap(result, unit, trap, catchableAs.getCaught());
                    unitToUncaughtThrowables.put(unit, catchableAs.getUncaught());
                    continue;
                }
                assert (thrownSet.equals(catchableAs.getUncaught())) : "ExceptionalUnitGraph.buildExceptionDests(): catchableAs.caught == EMPTY, but catchableAs.uncaught != thrownSet" + System.getProperty("line.separator") + this.body.getMethod().getSubSignature() + " Unit: " + unit.toString() + System.getProperty("line.separator") + " catchableAs.getUncaught() == " + catchableAs.getUncaught().toString() + System.getProperty("line.separator") + " thrownSet == " + thrownSet.toString();
            }
        }
        for (Map.Entry entry : unitToUncaughtThrowables.entrySet()) {
            Unit unit = (Unit)entry.getKey();
            ThrowableSet escaping = (ThrowableSet)entry.getValue();
            if (escaping == ThrowableSet.Manager.v().EMPTY) continue;
            result = this.addDestToMap(result, unit, null, escaping);
        }
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    private Map<Unit, Collection<ExceptionDest>> addDestToMap(Map<Unit, Collection<ExceptionDest>> map, Unit u, Trap t2, ThrowableSet caught) {
        Collection<ExceptionDest> dests;
        Collection<ExceptionDest> collection = dests = map == null ? null : map.get(u);
        if (dests == null) {
            if (t2 == null) {
                return map;
            }
            if (map == null) {
                map = new LinkedHashMap<Unit, Collection<ExceptionDest>>(this.unitChain.size() * 2 + 1);
            }
            dests = new ArrayList<ExceptionDest>(3);
            map.put(u, dests);
        }
        dests.add(new ExceptionDest(t2, caught));
        return map;
    }

    protected Set<Unit> buildExceptionalEdges(ThrowAnalysis throwAnalysis, Map<Unit, Collection<ExceptionDest>> unitToExceptionDests, Map<Unit, List<Unit>> unitToSuccs, Map<Unit, List<Unit>> unitToPreds, boolean omitExceptingUnitEdges) {
        ArraySet<Unit> trapsThatAreHeads = new ArraySet<Unit>();
        Unit entryPoint = (Unit)this.unitChain.getFirst();
        for (Map.Entry<Unit, Collection<ExceptionDest>> entry : unitToExceptionDests.entrySet()) {
            Unit thrower = entry.getKey();
            List<Unit> throwersPreds = this.getUnexceptionalPredsOf(thrower);
            Collection<ExceptionDest> dests = entry.getValue();
            boolean alwaysAddSelfEdges = !omitExceptingUnitEdges || ExceptionalUnitGraph.mightHaveSideEffects(thrower);
            ThrowableSet predThrowables = null;
            ThrowableSet selfThrowables = null;
            if (thrower instanceof ThrowInst) {
                ThrowInst throwInst = (ThrowInst)thrower;
                predThrowables = throwAnalysis.mightThrowImplicitly(throwInst);
                selfThrowables = throwAnalysis.mightThrowExplicitly(throwInst);
            } else if (thrower instanceof ThrowStmt) {
                ThrowStmt throwStmt = (ThrowStmt)thrower;
                predThrowables = throwAnalysis.mightThrowImplicitly(throwStmt);
                selfThrowables = throwAnalysis.mightThrowExplicitly(throwStmt);
            }
            for (ExceptionDest dest : dests) {
                if (dest.getTrap() == null) continue;
                Unit catcher = dest.getTrap().getHandlerUnit();
                RefType trapsType = dest.getTrap().getException().getType();
                if (predThrowables == null || predThrowables.catchableAs(trapsType)) {
                    if (thrower == entryPoint) {
                        trapsThatAreHeads.add(catcher);
                    }
                    for (Unit pred : throwersPreds) {
                        this.addEdge(unitToSuccs, unitToPreds, pred, catcher);
                    }
                }
                if (!alwaysAddSelfEdges && (selfThrowables == null || !selfThrowables.catchableAs(trapsType))) continue;
                this.addEdge(unitToSuccs, unitToPreds, thrower, catcher);
            }
        }
        class CFGEdge {
            Unit head;
            Unit tail;

            CFGEdge(Unit head, Unit tail) {
                if (tail == null) {
                    throw new RuntimeException("invalid CFGEdge(" + (head == null ? "null" : head.toString()) + ',' + "null" + ')');
                }
                this.head = head;
                this.tail = tail;
            }

            public boolean equals(Object rhs) {
                if (rhs == this) {
                    return true;
                }
                if (!(rhs instanceof CFGEdge)) {
                    return false;
                }
                CFGEdge rhsEdge = (CFGEdge)rhs;
                return this.head == rhsEdge.head && this.tail == rhsEdge.tail;
            }

            public int hashCode() {
                int result = 17;
                result = 37 * result + this.head.hashCode();
                result = 37 * result + this.tail.hashCode();
                return result;
            }
        }
        LinkedList<CFGEdge> workList = new LinkedList<CFGEdge>();
        for (Trap trap : this.body.getTraps()) {
            Unit handlerStart = trap.getHandlerUnit();
            if (!this.mightThrowToIntraproceduralCatcher(handlerStart)) continue;
            List<Unit> handlerPreds = this.getUnexceptionalPredsOf(handlerStart);
            for (Unit pred : handlerPreds) {
                workList.addLast(new CFGEdge(pred, handlerStart));
            }
            handlerPreds = this.getExceptionalPredsOf(handlerStart);
            for (Unit pred : handlerPreds) {
                workList.addLast(new CFGEdge(pred, handlerStart));
            }
            if (!trapsThatAreHeads.contains(handlerStart)) continue;
            workList.addLast(new CFGEdge(null, handlerStart));
        }
        while (workList.size() > 0) {
            CFGEdge cFGEdge = (CFGEdge)workList.removeFirst();
            Unit pred = cFGEdge.head;
            Unit thrower = cFGEdge.tail;
            Collection<ExceptionDest> throwerDests = this.getExceptionDests(thrower);
            for (ExceptionDest dest : throwerDests) {
                if (dest.getTrap() == null) continue;
                Unit handlerStart = dest.getTrap().getHandlerUnit();
                boolean edgeAdded = false;
                if (pred == null) {
                    if (!trapsThatAreHeads.contains(handlerStart)) {
                        trapsThatAreHeads.add(handlerStart);
                        edgeAdded = true;
                    }
                } else if (!this.getExceptionalSuccsOf(pred).contains(handlerStart)) {
                    this.addEdge(unitToSuccs, unitToPreds, pred, handlerStart);
                    edgeAdded = true;
                }
                if (!edgeAdded || !this.mightThrowToIntraproceduralCatcher(handlerStart)) continue;
                workList.addLast(new CFGEdge(pred, handlerStart));
            }
        }
        return trapsThatAreHeads;
    }

    static boolean mightHaveSideEffects(Unit u) {
        if (u instanceof Inst) {
            Inst i = (Inst)u;
            return i.containsInvokeExpr() || i instanceof StaticPutInst || i instanceof StaticGetInst || i instanceof NewInst;
        }
        if (u instanceof Stmt) {
            for (ValueBox vb : u.getUseBoxes()) {
                Value v = vb.getValue();
                if (!(v instanceof StaticFieldRef) && !(v instanceof InvokeExpr) && !(v instanceof NewExpr)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean mightThrowToIntraproceduralCatcher(Unit u) {
        Collection<ExceptionDest> dests = this.getExceptionDests(u);
        for (ExceptionDest dest : dests) {
            if (dest.getTrap() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void buildHeadsAndTails() throws IllegalStateException {
        throw new IllegalStateException("ExceptionalUnitGraph uses buildHeadsAndTails(List) instead of buildHeadsAndTails()");
    }

    private void buildHeadsAndTails(Set<Unit> additionalHeads) {
        this.heads = new ArrayList(additionalHeads.size() + 1);
        this.heads.addAll(additionalHeads);
        if (this.unitChain.isEmpty()) {
            throw new IllegalStateException("No body for method " + this.body.getMethod().getSignature());
        }
        Unit entryPoint = (Unit)this.unitChain.getFirst();
        if (!this.heads.contains(entryPoint)) {
            this.heads.add(entryPoint);
        }
        this.tails = new ArrayList();
        for (Unit u : this.unitChain) {
            if (u instanceof ReturnStmt || u instanceof ReturnVoidStmt || u instanceof ReturnInst || u instanceof ReturnVoidInst) {
                this.tails.add(u);
                continue;
            }
            if (!(u instanceof ThrowStmt) && !(u instanceof ThrowInst)) continue;
            Collection<ExceptionDest> dests = this.getExceptionDests(u);
            int escapeMethodCount = 0;
            for (ExceptionDest dest : dests) {
                if (dest.getTrap() != null) continue;
                ++escapeMethodCount;
            }
            if (escapeMethodCount <= 0) continue;
            this.tails.add(u);
        }
    }

    @Override
    public Collection<ExceptionDest> getExceptionDests(final Unit u) {
        Collection<ExceptionDest> result = this.unitToExceptionDests.get(u);
        if (result == null) {
            ExceptionDest e = new ExceptionDest(null, null){
                private ThrowableSet throwables;

                @Override
                public ThrowableSet getThrowables() {
                    if (null == this.throwables) {
                        this.throwables = ExceptionalUnitGraph.this.throwAnalysis.mightThrow(u);
                    }
                    return this.throwables;
                }
            };
            return Collections.singletonList(e);
        }
        return result;
    }

    @Override
    public List<Unit> getUnexceptionalPredsOf(Unit u) {
        List<Unit> preds = this.unitToUnexceptionalPreds.get(u);
        return preds == null ? Collections.emptyList() : preds;
    }

    @Override
    public List<Unit> getUnexceptionalSuccsOf(Unit u) {
        List<Unit> succs = this.unitToUnexceptionalSuccs.get(u);
        return succs == null ? Collections.emptyList() : succs;
    }

    @Override
    public List<Unit> getExceptionalPredsOf(Unit u) {
        List<Unit> preds = this.unitToExceptionalPreds.get(u);
        return preds == null ? Collections.emptyList() : preds;
    }

    @Override
    public List<Unit> getExceptionalSuccsOf(Unit u) {
        List<Unit> succs = this.unitToExceptionalSuccs.get(u);
        return succs == null ? Collections.emptyList() : succs;
    }

    ThrowAnalysis getThrowAnalysis() {
        return this.throwAnalysis;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (Unit u : this.unitChain) {
            buf.append("  preds: " + this.getPredsOf(u) + "\n");
            buf.append("  unexceptional preds: " + this.getUnexceptionalPredsOf(u) + "\n");
            buf.append("  exceptional preds: " + this.getExceptionalPredsOf(u) + "\n");
            buf.append(u.toString() + '\n');
            buf.append("  exception destinations: " + this.getExceptionDests(u) + "\n");
            buf.append("  unexceptional succs: " + this.getUnexceptionalSuccsOf(u) + "\n");
            buf.append("  exceptional succs: " + this.getExceptionalSuccsOf(u) + "\n");
            buf.append("  succs " + this.getSuccsOf(u) + "\n\n");
        }
        return buf.toString();
    }

    public static class ExceptionDest
    implements ExceptionalGraph.ExceptionDest<Unit> {
        private Trap trap;
        private ThrowableSet throwables;

        protected ExceptionDest(Trap trap, ThrowableSet throwables) {
            this.trap = trap;
            this.throwables = throwables;
        }

        @Override
        public Trap getTrap() {
            return this.trap;
        }

        @Override
        public ThrowableSet getThrowables() {
            return this.throwables;
        }

        @Override
        public Unit getHandlerNode() {
            if (this.trap == null) {
                return null;
            }
            return this.trap.getHandlerUnit();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getThrowables());
            buf.append(" -> ");
            if (this.trap == null) {
                buf.append("(escapes)");
            } else {
                buf.append(this.trap.toString());
            }
            return buf.toString();
        }
    }
}

