/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.astmetrics.DataHandlingApplication;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import soot.CompilationDeathException;

public class ProcessData {
    private static final int CLASSNAMESIZE = 15;
    private static final int CLASS = 0;
    private static final int BENCHMARK = 1;
    private static String metricListFileName = null;
    private static final ArrayList<String> xmlFileList = new ArrayList();
    private static int aggregationMechanism = -1;
    private static OutputStream streamOut;
    private static PrintWriter bench;
    private static final boolean CSV = true;
    private static final boolean decompiler = false;

    public static void main(String[] args) {
        int argLength = args.length;
        if (argLength == 0) {
            ProcessData.printIntro();
            ProcessData.useHelp();
            System.exit(1);
        }
        if (args[0].equals("--help")) {
            ProcessData.printHelp();
            System.exit(1);
        } else if (args[0].equals("-metricList")) {
            ProcessData.metricListFileName(args);
            System.out.println("A list of metrics will be stored in: " + metricListFileName);
            ProcessData.readXMLFileNames(2, args);
            try {
                FileOutputStream streamOut = new FileOutputStream(metricListFileName);
                PrintWriter writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
                ProcessData.writeMetricLists(writerOut);
                writerOut.flush();
                ((OutputStream)streamOut).close();
            }
            catch (IOException e) {
                throw new CompilationDeathException("Cannot output file " + metricListFileName);
            }
        } else if (args[0].equals("-tables")) {
            ProcessData.metricListFileName(args);
            System.out.println("Will read column table headings from: " + metricListFileName);
            ProcessData.aggregationOption(args);
            if (aggregationMechanism == 1) {
                System.out.println("Aggregating over benchmarks...each row is one of the xml files");
                System.out.println("Only one tex file with the name" + metricListFileName + ".tex will be created");
            } else if (aggregationMechanism == 0) {
                System.out.println("Aggregating over class...each row is one class...");
                System.out.println("Each benchmark (xml file) will have its own tex file");
            }
            ProcessData.readXMLFileNames(3, args);
            ProcessData.generateMetricsTables();
        } else {
            System.out.println("Incorrect argument number 1: expecting -metricList or -tables");
            System.exit(1);
        }
    }

    private static void aggregationOption(String[] args) {
        if (args.length < 3) {
            System.out.println("Expecting -class or -benchmark at argument number 3");
            System.exit(1);
        }
        if (args[2].equals("-class")) {
            aggregationMechanism = 0;
        } else if (args[2].equals("-benchmark")) {
            aggregationMechanism = 1;
        } else {
            System.out.println("Expecting -class or -benchmark at argument number 3");
            System.exit(1);
        }
    }

    private static void readXMLFileNames(int startIndex, String[] args) {
        if (args.length < startIndex + 1) {
            System.out.println("Expecting an xml file OR * symbol as argument number" + (startIndex + 1));
            System.exit(1);
        }
        if (args[startIndex].equals("*")) {
            System.out.println("Will read all xml files from directory");
            ProcessData.readStar();
        } else {
            for (int i = startIndex; i < args.length; ++i) {
                String temp = args[i];
                if (!temp.endsWith(".xml")) continue;
                xmlFileList.add(temp);
            }
        }
        Iterator<String> it = xmlFileList.iterator();
        while (it.hasNext()) {
            System.out.println("Will be reading: " + it.next());
        }
    }

    private static void metricListFileName(String[] args) {
        if (args.length < 2) {
            System.out.println("Expecting name of metricList as argumnet number 2");
            System.exit(1);
        }
        metricListFileName = args[1];
    }

    public static void printHelp() {
        ProcessData.printIntro();
        System.out.println("There are two main modes of execution");
        System.out.println("To execute the program the first argument should be one of these modes");
        System.out.println("-metricList and -tables");
        System.out.println("\n\n The -metricList mode");
        System.out.println("The argument at location 1 should be name of a file where the list of metrics will be stored");
        System.out.println("All arguments following argument 1 have to be xml files to be processed");
        System.out.println("If argument at location 2 is * then the current directory is searched and all xml files will be processed");
        System.out.println("\n\n The -tables mode");
        System.out.println("The argument at location 1 should be name of a file where the list of metrics are stored");
        System.out.println("These metrics will become the COLUMNS in the tables created");
        System.out.println("Argument at location 2 is the choice of aggregation");
        System.out.println("\t -class for class level metrics");
        System.out.println("\t -benchmark for benchmark level metrics");
        System.out.println("Each xml file is considered to be a benchmark with a bunch of classes in it");
        System.out.println("All arguments following argument 2 have to be xml files to be processed");
        System.out.println("If argument at location 3 is * then the current directory is searched and all xml files will be processed");
    }

    public static void printIntro() {
        System.out.println("Welcome to the processData application");
        System.out.println("The application is an xml document parser.");
        System.out.println("Its primary aim is to create pretty tex tables");
    }

    public static void useHelp() {
        System.out.println("Use the --help flag for more details");
    }

    private static void readStar() {
        FilenameFilter filter;
        String curDir = System.getProperty("user.dir");
        System.out.println("Current system directory is" + curDir);
        File dir = new File(curDir);
        String[] children = dir.list();
        if (children != null && (children = dir.list(filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        })) != null) {
            for (String element : children) {
                xmlFileList.add(element);
            }
        }
    }

    private static void writeMetricLists(PrintWriter out) {
        ArrayList<String> metricList = new ArrayList<String>();
        for (String fileName : xmlFileList) {
            try {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(new File(fileName));
                System.out.println("Retrieving Metric List from xml file: " + fileName);
                doc.getDocumentElement().normalize();
                NodeList metrics = doc.getElementsByTagName("Metric");
                for (int s2 = 0; s2 < metrics.getLength(); ++s2) {
                    Element metricElement;
                    NodeList metricName;
                    Element name;
                    NodeList textFNList;
                    Node metricNode = metrics.item(s2);
                    if (metricNode.getNodeType() != 1 || metricList.contains((textFNList = (name = (Element)(metricName = (metricElement = (Element)metricNode).getElementsByTagName("MetricName")).item(0)).getChildNodes()).item(0).getNodeValue().trim())) continue;
                    metricList.add(textFNList.item(0).getNodeValue().trim());
                }
            }
            catch (SAXParseException err) {
                System.out.println("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
                System.out.println(" " + err.getMessage());
            }
            catch (SAXException e) {
                Exception x = e.getException();
                (x == null ? e : x).printStackTrace();
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
        Iterator<String> it = metricList.iterator();
        while (it.hasNext()) {
            out.println(it.next());
        }
        System.out.println(metricListFileName + " created.");
    }

    private static void generateMetricsTables() {
        Vector<String> columns = new Vector<String>();
        try {
            String text;
            FileReader file = new FileReader(metricListFileName);
            BufferedReader fileInput = new BufferedReader(file);
            while ((text = fileInput.readLine()) != null) {
                columns.add(text);
            }
            fileInput.close();
        }
        catch (Exception e) {
            System.out.println("Exception while reading from metricList" + metricListFileName);
            System.exit(1);
        }
        Vector<String> allMetrics = new Vector<String>();
        try {
            String text;
            FileReader file = new FileReader("myList");
            BufferedReader fileInput = new BufferedReader(file);
            while ((text = fileInput.readLine()) != null) {
                allMetrics.add(text);
            }
            fileInput.close();
        }
        catch (Exception e) {
            System.out.println("Exception while reading from metricList" + metricListFileName);
            System.exit(1);
        }
        String newClassName = "";
        if (aggregationMechanism == 1) {
            newClassName = metricListFileName;
            newClassName = newClassName + ".csv";
            System.out.println("Creating csv file" + newClassName + " from metrics info");
            bench = ProcessData.openWriteFile(newClassName);
            HashMap<String, ArrayList<String>> benchMarkToFiles = new HashMap<String, ArrayList<String>>();
            for (String fileName : xmlFileList) {
                if (fileName.indexOf(45) < 0) {
                    System.out.println("XML files should have following syntax:\n <BENCHMARKNAME>-<PROPERTY>.xml\n PROPERTY should be enabled disabled etc");
                    return;
                }
                String benchmark = fileName.substring(0, fileName.indexOf(45));
                ArrayList<String> temp = (ArrayList<String>)benchMarkToFiles.get(benchmark);
                ArrayList<String> tempList = null;
                tempList = temp == null ? new ArrayList<String>() : temp;
                tempList.add(fileName);
                benchMarkToFiles.put(benchmark, tempList);
                if (fileName.indexOf(45) < 0 || fileName.lastIndexOf(".xml") < 0) {
                    System.out.println("XML files should have following syntax:\n <BENCHMARKNAME>-<PROPERTY>.xml\n PROPERTY should be enabled disabled etc");
                    return;
                }
                String xmlfileColumnType = fileName.substring(fileName.lastIndexOf(45) + 1, fileName.lastIndexOf(".xml"));
                System.out.println("XML FILE COLUMN TYPE" + xmlfileColumnType);
                if (xmlfileColumnType.equals("Jad") || xmlfileColumnType.equals("original") || xmlfileColumnType.equals("SourceAgain") || xmlfileColumnType.equals("disabled") || xmlfileColumnType.equals("enabled")) continue;
                throw new RuntimeException("XML FILE <property> not recognized");
            }
            ProcessData.printCSVHeader(bench);
            for (String key : benchMarkToFiles.keySet()) {
                ArrayList<String> tempValue = (ArrayList<String>)benchMarkToFiles.get(key);
                if (tempValue == null) continue;
                ArrayList<String> files = tempValue;
                if (files.size() != 5) {
                    throw new RuntimeException("not all xml files available for this benchmark!!");
                }
                System.out.println("old order" + ((Object)files).toString());
                String[] newFileOrder = new String[files.size()];
                for (String fileSort : files) {
                    if (fileSort.indexOf("original") > -1) {
                        newFileOrder[0] = fileSort;
                        continue;
                    }
                    if (fileSort.indexOf("jbco-enabled") > -1) {
                        newFileOrder[1] = fileSort;
                        continue;
                    }
                    if (fileSort.indexOf("jbco-disabled") > -1) {
                        newFileOrder[2] = fileSort;
                        continue;
                    }
                    if (fileSort.indexOf("klassmaster-enabled") > -1) {
                        newFileOrder[3] = fileSort;
                        continue;
                    }
                    if (fileSort.indexOf("klassmaster-disabled") > -1) {
                        newFileOrder[4] = fileSort;
                        continue;
                    }
                    throw new RuntimeException("property xml not correct");
                }
                files = new ArrayList<String>();
                files.add(newFileOrder[0]);
                files.add(newFileOrder[1]);
                files.add(newFileOrder[2]);
                files.add(newFileOrder[3]);
                files.add(newFileOrder[4]);
                System.out.println("new order" + ((Object)files).toString());
                Iterator fileIt = files.iterator();
                int count = -1;
                while (fileIt.hasNext()) {
                    String fileName = (String)fileIt.next();
                    ++count;
                    try {
                        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                        Document doc = docBuilder.parse(new File(fileName));
                        System.out.println("Gethering metric info from from xml file: " + fileName);
                        HashMap<String, Number> aggregatedValues = new HashMap<String, Number>();
                        Iterator<Object> tempIt = allMetrics.iterator();
                        while (tempIt.hasNext()) {
                            aggregatedValues.put((String)tempIt.next(), new Integer(0));
                        }
                        int numClasses = ProcessData.aggregateXMLFileMetrics(doc, aggregatedValues);
                        Number myTemp = aggregatedValues.get("Total-Conditionals");
                        if (myTemp == null) {
                            System.out.println("Total-Conditionals not found in aggregatedValues");
                            System.exit(1);
                        }
                        double total_if_ifelse = ((Integer)myTemp).doubleValue();
                        myTemp = aggregatedValues.get("Total Loops");
                        if (myTemp == null) {
                            System.out.println("Total Loops not found in aggregatedValues");
                            System.exit(1);
                        }
                        double totalLoops = ((Integer)myTemp).doubleValue();
                        double totalConditional = total_if_ifelse + totalLoops;
                        myTemp = aggregatedValues.get("AST-Node-Count");
                        if (myTemp == null) {
                            System.out.println("AST-Node-Count not found in aggregatedValues");
                            System.exit(1);
                        }
                        double astCount = ((Integer)myTemp).doubleValue();
                        myTemp = aggregatedValues.get("NameCount");
                        if (myTemp == null) {
                            System.out.println("NameCount not found in aggregatedValues");
                            System.exit(1);
                        }
                        double nameCount = (Double)myTemp;
                        myTemp = aggregatedValues.get("Expr-Count");
                        if (myTemp == null) {
                            System.out.println("ExprCount not found in aggregatedValues");
                            System.exit(1);
                        }
                        double exprCount = (Double)myTemp;
                        tempIt = columns.iterator();
                        while (tempIt.hasNext()) {
                            String nexttempit = (String)tempIt.next();
                            Number temp = aggregatedValues.get(nexttempit);
                            if (temp instanceof Integer) {
                                int val = (Integer)temp;
                                switch (count) {
                                    case 0: {
                                        bench.print(fileName.substring(0, fileName.indexOf(45)));
                                    }
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        if (nexttempit.equals("Total-Abrupt")) {
                                            bench.print("," + val);
                                            break;
                                        }
                                        if (nexttempit.equals("Total-Cond-Complexity")) {
                                            if (totalConditional != 0.0) {
                                                System.out.println("conditional complexit is" + val);
                                                System.out.println("totalConditionals are" + totalConditional);
                                                bench.print("," + (double)val / totalConditional);
                                                break;
                                            }
                                            if (val == 0) {
                                                bench.print("," + val);
                                                break;
                                            }
                                            System.out.println("Val not 0 but totalConditionals are zero!!!");
                                            System.exit(1);
                                            break;
                                        }
                                        if (nexttempit.equals("D-W-Complexity")) {
                                            if (astCount != 0.0) {
                                                bench.print("," + (double)val / astCount);
                                                break;
                                            }
                                            if (val == 0) {
                                                bench.print("," + val);
                                                break;
                                            }
                                            System.out.println("Val not 0 but astcount is zero!!!");
                                            System.exit(1);
                                            break;
                                        }
                                        if (nexttempit.equals("Expr-Complexity")) {
                                            if (exprCount != 0.0) {
                                                bench.print("," + (double)val / exprCount);
                                                break;
                                            }
                                            if (val == 0) {
                                                bench.print("," + val);
                                                break;
                                            }
                                            System.out.println("Val not 0 but exprcount is zero!!!");
                                            System.exit(1);
                                            break;
                                        }
                                        if (nexttempit.equals("Name-Complexity")) {
                                            if (nameCount != 0.0) {
                                                bench.print("," + (double)val / nameCount);
                                                break;
                                            }
                                            if (val == 0) {
                                                bench.print("," + val);
                                                break;
                                            }
                                            System.out.println("Val not 0 but name-count is zero!!!");
                                            System.exit(1);
                                            break;
                                        }
                                        bench.print("," + val);
                                        break;
                                    }
                                    default: {
                                        System.out.println("unhandled count value");
                                        System.exit(1);
                                        break;
                                    }
                                }
                            } else if (temp instanceof Double) {
                                double val = (Double)temp;
                                switch (count) {
                                    case 0: {
                                        bench.print(fileName.substring(0, fileName.indexOf(45)));
                                    }
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        if (nexttempit.equals("Total-Abrupt")) {
                                            bench.print("," + val);
                                            break;
                                        }
                                        if (nexttempit.equals("Total-Cond-Complexity")) {
                                            if (totalConditional != 0.0) {
                                                System.out.println("conditional complexit is" + val);
                                                System.out.println("totalConditionals are" + totalConditional);
                                                bench.print("," + val / totalConditional);
                                                break;
                                            }
                                            if (val == 0.0) {
                                                bench.print("," + val);
                                                break;
                                            }
                                            System.out.println("Val not 0 but totalConditionals are zero!!!");
                                            System.exit(1);
                                            break;
                                        }
                                        if (nexttempit.equals("D-W-Complexity")) {
                                            if (astCount != 0.0) {
                                                bench.print("," + val / astCount);
                                                break;
                                            }
                                            if (val == 0.0) {
                                                bench.print("," + val);
                                                break;
                                            }
                                            System.out.println("Val not 0 but astcount is zero!!!");
                                            System.exit(1);
                                            break;
                                        }
                                        if (nexttempit.equals("Expr-Complexity")) {
                                            if (exprCount != 0.0) {
                                                bench.print("," + val / exprCount);
                                                break;
                                            }
                                            if (val == 0.0) {
                                                bench.print("," + val);
                                                break;
                                            }
                                            System.out.println("Val not 0 but exprcount is zero!!!");
                                            System.exit(1);
                                            break;
                                        }
                                        if (nexttempit.equals("Name-Complexity")) {
                                            if (nameCount != 0.0) {
                                                bench.print("," + val / nameCount);
                                                break;
                                            }
                                            if (val == 0.0) {
                                                bench.print("," + val);
                                                break;
                                            }
                                            System.out.println("Val not 0 but name-count is zero!!!");
                                            System.exit(1);
                                            break;
                                        }
                                        bench.print("," + val);
                                        break;
                                    }
                                    default: {
                                        System.out.println("unhandled count value");
                                        System.exit(1);
                                        break;
                                    }
                                }
                            } else {
                                throw new RuntimeException("Unknown type of object stored!!!");
                            }
                            if (!tempIt.hasNext()) continue;
                            System.out.println("Only allowed one metric for CSV");
                            System.exit(1);
                        }
                    }
                    catch (SAXParseException err) {
                        System.out.println("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
                        System.out.println(" " + err.getMessage());
                    }
                    catch (SAXException e) {
                        Exception x = e.getException();
                        (x == null ? e : x).printStackTrace();
                    }
                    catch (Throwable t2) {
                        t2.printStackTrace();
                    }
                }
                bench.println("");
            }
            ProcessData.closeWriteFile(bench, newClassName);
        } else {
            for (String fileName : xmlFileList) {
                try {
                    DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                    Document doc = docBuilder.parse(new File(fileName));
                    System.out.println("Gethering metric info from from xml file: " + fileName);
                    doc.getDocumentElement().normalize();
                    if (aggregationMechanism == 0) {
                        ProcessData.getClassMetrics(fileName, doc, columns);
                        continue;
                    }
                    System.out.println("Unknown aggregation Mechanism");
                    System.exit(1);
                }
                catch (SAXParseException err) {
                    System.out.println("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
                    System.out.println(" " + err.getMessage());
                }
                catch (SAXException e) {
                    Exception x = e.getException();
                    (x == null ? e : x).printStackTrace();
                }
                catch (Throwable t3) {
                    t3.printStackTrace();
                }
            }
        }
    }

    private static PrintWriter openWriteFile(String fileName) {
        PrintWriter writerOut;
        try {
            streamOut = new FileOutputStream(fileName);
            writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
        }
        catch (IOException e) {
            throw new CompilationDeathException("Cannot output file " + fileName);
        }
        return writerOut;
    }

    private static void closeWriteFile(PrintWriter writerOut, String fileName) {
        try {
            writerOut.flush();
            streamOut.close();
        }
        catch (IOException e) {
            throw new CompilationDeathException("Cannot output file " + fileName);
        }
    }

    private static int aggregateXMLFileMetrics(Document doc, HashMap<String, Number> aggregated) {
        NodeList classes = doc.getElementsByTagName("Class");
        int numClasses = classes.getLength();
        System.out.println("NumClasses for this document are" + numClasses);
        NodeList metrics = doc.getElementsByTagName("Metric");
        for (int s2 = 0; s2 < metrics.getLength(); ++s2) {
            boolean notInt;
            String valToPrint;
            String tempName;
            Number tempObj;
            block9: {
                Element metricElement;
                NodeList metricName;
                Element name;
                NodeList textFNList;
                Node metricNode = metrics.item(s2);
                if (metricNode.getNodeType() != 1 || (tempObj = aggregated.get(tempName = (textFNList = (name = (Element)(metricName = (metricElement = (Element)metricNode).getElementsByTagName("MetricName")).item(0)).getChildNodes()).item(0).getNodeValue().trim())) == null) continue;
                NodeList value = metricElement.getElementsByTagName("Value");
                Element name1 = (Element)value.item(0);
                NodeList textFNList1 = name1.getChildNodes();
                valToPrint = textFNList1.item(0).getNodeValue().trim();
                notInt = false;
                try {
                    Number valSoFar;
                    int temp = Integer.parseInt(valToPrint);
                    if (tempObj instanceof Integer) {
                        valSoFar = (Integer)tempObj;
                        aggregated.put(tempName, new Integer((Integer)valSoFar + temp));
                        break block9;
                    }
                    if (tempObj instanceof Double) {
                        valSoFar = (Double)tempObj;
                        aggregated.put(tempName, new Double((Double)valSoFar + (double)temp));
                        break block9;
                    }
                    throw new RuntimeException("\n\nobject type not found");
                }
                catch (Exception e) {
                    notInt = true;
                }
            }
            if (!notInt) continue;
            try {
                Number valSoFar;
                double temp = Double.parseDouble(valToPrint);
                if (tempObj instanceof Integer) {
                    valSoFar = (Integer)tempObj;
                    aggregated.put(tempName, new Double((double)((Integer)valSoFar).intValue() + temp));
                    continue;
                }
                if (tempObj instanceof Double) {
                    valSoFar = (Double)tempObj;
                    aggregated.put(tempName, new Double((Double)valSoFar + temp));
                    continue;
                }
                throw new RuntimeException("\n\nobject type not found");
            }
            catch (Exception e) {
                throw new RuntimeException("\n\n not an integer not a double unhandled!!!!");
            }
        }
        return numClasses;
    }

    private static void getClassMetrics(String fileName, Document doc, Vector<String> columns) {
        String newClassName = fileName;
        if (newClassName.endsWith(".xml")) {
            newClassName = newClassName.substring(0, newClassName.length() - 4);
        }
        newClassName = newClassName + ".tex";
        System.out.println("Creating tex file" + newClassName + " from metrics info in file" + fileName);
        PrintWriter writerOut = ProcessData.openWriteFile(newClassName);
        ProcessData.printTexTableHeader(writerOut, "Classes", columns);
        ArrayList<String> classNames = new ArrayList<String>();
        HashMap<String, String> classData = new HashMap<String, String>();
        NodeList classes = doc.getElementsByTagName("Class");
        for (int cl = 0; cl < classes.getLength(); ++cl) {
            Node classNode = classes.item(cl);
            if (classNode.getNodeType() != 1) continue;
            Element classElement = (Element)classNode;
            NodeList classNameNodeList = classElement.getElementsByTagName("ClassName");
            Element classNameElement = (Element)classNameNodeList.item(0);
            NodeList classNameTextFNList = classNameElement.getChildNodes();
            String className = classNameTextFNList.item(0).getNodeValue().trim();
            if ((className = className.replace('_', '-')).length() > 15) {
                className = className.substring(0, 15);
                classNames.add(className);
            } else {
                classNames.add(className);
            }
            System.out.print("\nclassName " + className);
            String data = "   ";
            NodeList metrics = classElement.getElementsByTagName("Metric");
            int columnIndex = 0;
            for (int s2 = 0; s2 < metrics.getLength() && columnIndex < columns.size(); ++s2) {
                Element metricElement;
                NodeList metricName;
                Element name;
                NodeList textFNList;
                String tempName;
                Node metricNode = metrics.item(s2);
                if (metricNode.getNodeType() != 1 || !(tempName = (textFNList = (name = (Element)(metricName = (metricElement = (Element)metricNode).getElementsByTagName("MetricName")).item(0)).getChildNodes()).item(0).getNodeValue().trim()).equals(columns.elementAt(columnIndex))) continue;
                NodeList value = metricElement.getElementsByTagName("Value");
                Element name1 = (Element)value.item(0);
                NodeList textFNList1 = name1.getChildNodes();
                String valToPrint = textFNList1.item(0).getNodeValue().trim();
                System.out.print(" " + valToPrint);
                data = data + "&" + valToPrint;
                data = columns.size() > ++columnIndex ? data + "   " : data + "\\\\";
            }
            classData.put(className, data);
        }
        Collections.sort(classNames);
        for (String className : classNames) {
            String data = (String)classData.get(className);
            writerOut.print(className);
            writerOut.println(data);
        }
        ProcessData.printTexTableFooter(writerOut, fileName);
        ProcessData.closeWriteFile(writerOut, metricListFileName);
    }

    private static void printTexTableFooter(PrintWriter out, String tableCaption) {
        out.println("");
        out.println("\\hline");
        out.println("\\end{tabular}");
        out.println("\\caption{ ..." + tableCaption + "..... }");
        out.println("\\end{table}");
    }

    private static void printCSVHeader(PrintWriter out) {
        out.println(",Original,JBCO-enabled,JBCO-disabled,klassmaster-enabled,klassmaster-disabled");
    }

    private static void printTexTableHeader(PrintWriter out, String rowHeading, Vector<String> columns) {
        out.println("\\begin{table}[hbtp]");
        out.print("\\begin{tabular}{");
        for (int i = 0; i <= columns.size(); ++i) {
            out.print("|l");
        }
        out.println("|}");
        out.println("\\hline");
        out.print(rowHeading + "   ");
        Iterator<String> it = columns.iterator();
        while (it.hasNext()) {
            out.print("&" + it.next());
            if (!it.hasNext()) continue;
            out.print("   ");
        }
        out.println("\\\\");
        out.println("\\hline");
    }
}

