/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.astmetrics;

import polyglot.ast.Binary;
import polyglot.ast.Expr;
import polyglot.ast.If;
import polyglot.ast.Loop;
import polyglot.ast.Node;
import polyglot.ast.Unary;
import polyglot.visit.NodeVisitor;
import soot.toolkits.astmetrics.ASTMetric;
import soot.toolkits.astmetrics.ClassData;
import soot.toolkits.astmetrics.MetricData;

public class ConditionComplexityMetric
extends ASTMetric {
    int loopComplexity;
    int ifComplexity;

    public ConditionComplexityMetric(Node node) {
        super(node);
    }

    @Override
    public void reset() {
        this.ifComplexity = 0;
        this.loopComplexity = 0;
    }

    @Override
    public void addMetrics(ClassData data) {
        data.addMetric(new MetricData("Loop-Cond-Complexity", new Integer(this.loopComplexity)));
        data.addMetric(new MetricData("If-Cond-Complexity", new Integer(this.ifComplexity)));
        data.addMetric(new MetricData("Total-Cond-Complexity", new Integer(this.loopComplexity + this.ifComplexity)));
    }

    @Override
    public NodeVisitor enter(Node parent, Node n) {
        if (n instanceof Loop) {
            Expr expr = ((Loop)n).cond();
            this.loopComplexity = (int)((double)this.loopComplexity + this.condComplexity(expr));
        } else if (n instanceof If) {
            Expr expr = ((If)n).cond();
            this.ifComplexity = (int)((double)this.ifComplexity + this.condComplexity(expr));
        }
        return this.enter(n);
    }

    private double condComplexity(Expr expr) {
        if (expr instanceof Binary) {
            Binary b = (Binary)expr;
            if (b.operator() == Binary.COND_AND || b.operator() == Binary.COND_OR) {
                return 1.0 + this.condComplexity(b.left()) + this.condComplexity(b.right());
            }
            return 0.5 + this.condComplexity(b.left()) + this.condComplexity(b.right());
        }
        if (expr instanceof Unary) {
            if (((Unary)expr).operator() == Unary.NOT) {
                return 0.5 + this.condComplexity(((Unary)expr).expr());
            }
            return this.condComplexity(((Unary)expr).expr());
        }
        return 1.0;
    }
}

