/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Singletons;
import soot.Trap;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.NullConstant;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;

public class TrapSplitter
extends BodyTransformer {
    public TrapSplitter(Singletons.Global g2) {
    }

    public static TrapSplitter v() {
        return G.v().soot_toDex_TrapSplitter();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        TrapOverlap to;
        if (b.getTraps().size() < 2) {
            return;
        }
        HashSet<Unit> potentiallyUselessTrapHandlers = null;
        while ((to = this.getNextOverlap(b)) != null) {
            if (to.t1.getBeginUnit() == to.t1.getEndUnit()) {
                b.getTraps().remove(to.t1);
                if (potentiallyUselessTrapHandlers == null) {
                    potentiallyUselessTrapHandlers = new HashSet<Unit>();
                }
                potentiallyUselessTrapHandlers.add(to.t1.getHandlerUnit());
                continue;
            }
            if (to.t2.getBeginUnit() == to.t2.getEndUnit()) {
                b.getTraps().remove(to.t2);
                if (potentiallyUselessTrapHandlers == null) {
                    potentiallyUselessTrapHandlers = new HashSet();
                }
                potentiallyUselessTrapHandlers.add(to.t2.getHandlerUnit());
                continue;
            }
            if (to.t1.getBeginUnit() != to.t2Start) {
                Trap newTrap = Jimple.v().newTrap(to.t1.getException(), to.t1.getBeginUnit(), to.t2Start, to.t1.getHandlerUnit());
                this.safeAddTrap(b, newTrap, to.t1);
                to.t1.setBeginUnit(to.t2Start);
                continue;
            }
            if (to.t1.getBeginUnit() != to.t2.getBeginUnit()) continue;
            Unit firstEndUnit = to.t1.getBeginUnit();
            while (firstEndUnit != to.t1.getEndUnit() && firstEndUnit != to.t2.getEndUnit()) {
                firstEndUnit = b.getUnits().getSuccOf(firstEndUnit);
            }
            if (firstEndUnit == to.t1.getEndUnit()) {
                Trap newTrap;
                if (to.t1.getException() != to.t2.getException()) {
                    newTrap = Jimple.v().newTrap(to.t2.getException(), to.t1.getBeginUnit(), firstEndUnit, to.t2.getHandlerUnit());
                    this.safeAddTrap(b, newTrap, to.t2);
                } else if (to.t1.getHandlerUnit() != to.t2.getHandlerUnit()) {
                    newTrap = Jimple.v().newTrap(to.t1.getException(), to.t1.getBeginUnit(), firstEndUnit, to.t1.getHandlerUnit());
                    this.safeAddTrap(b, newTrap, to.t1);
                }
                to.t2.setBeginUnit(firstEndUnit);
                continue;
            }
            if (firstEndUnit != to.t2.getEndUnit()) continue;
            if (to.t1.getException() != to.t2.getException()) {
                Trap newTrap2 = Jimple.v().newTrap(to.t1.getException(), to.t1.getBeginUnit(), firstEndUnit, to.t1.getHandlerUnit());
                this.safeAddTrap(b, newTrap2, to.t1);
                to.t1.setBeginUnit(firstEndUnit);
                continue;
            }
            if (to.t1.getHandlerUnit() != to.t2.getHandlerUnit()) {
                b.getTraps().remove(to.t2);
                if (potentiallyUselessTrapHandlers == null) {
                    potentiallyUselessTrapHandlers = new HashSet();
                }
                potentiallyUselessTrapHandlers.add(to.t2.getHandlerUnit());
                continue;
            }
            to.t1.setBeginUnit(firstEndUnit);
        }
        TrapSplitter.removePotentiallyUselassTraps(b, potentiallyUselessTrapHandlers);
    }

    public static void removePotentiallyUselassTraps(Body b, Set<Unit> potentiallyUselessTrapHandlers) {
        if (potentiallyUselessTrapHandlers == null) {
            return;
        }
        for (Trap t2 : b.getTraps()) {
            potentiallyUselessTrapHandlers.remove(t2.getHandlerUnit());
        }
        boolean removedUselessTrap = false;
        for (Unit uselessTrapHandler : potentiallyUselessTrapHandlers) {
            IdentityStmt assign;
            if (!(uselessTrapHandler instanceof IdentityStmt) || !((assign = (IdentityStmt)uselessTrapHandler).getRightOp() instanceof CaughtExceptionRef)) continue;
            AssignStmt newStmt = Jimple.v().newAssignStmt(assign.getLeftOp(), NullConstant.v());
            b.getUnits().swapWith(assign, newStmt);
            removedUselessTrap = true;
        }
        if (removedUselessTrap) {
            UnreachableCodeEliminator.v().transform(b);
        }
    }

    private void safeAddTrap(Body b, Trap newTrap, Trap position) {
        if (newTrap.getBeginUnit() != newTrap.getEndUnit()) {
            if (position != null) {
                b.getTraps().insertAfter(newTrap, position);
            } else {
                b.getTraps().add(newTrap);
            }
        }
    }

    private TrapOverlap getNextOverlap(Body b) {
        HashMap trapsContainingThisUnit = new HashMap();
        for (Trap t1 : b.getTraps()) {
            Unit splitUnit = t1.getBeginUnit();
            while (splitUnit != t1.getEndUnit()) {
                LinkedHashSet otherTrapsContainingUnit = (LinkedHashSet)trapsContainingThisUnit.get(splitUnit);
                if (otherTrapsContainingUnit != null) {
                    for (Trap t2 : otherTrapsContainingUnit) {
                        if (t2.getEndUnit() == t1.getEndUnit() && t2.getException() != t1.getException()) continue;
                        if (splitUnit == t1.getBeginUnit()) {
                            return new TrapOverlap(t2, t1, splitUnit);
                        }
                        return new TrapOverlap(t1, t2, splitUnit);
                    }
                    otherTrapsContainingUnit.add(t1);
                } else {
                    LinkedHashSet<Trap> newSet = new LinkedHashSet<Trap>();
                    newSet.add(t1);
                    trapsContainingThisUnit.put(splitUnit, newSet);
                }
                splitUnit = b.getUnits().getSuccOf(splitUnit);
            }
        }
        return null;
    }

    private class TrapOverlap {
        private Trap t1;
        private Trap t2;
        private Unit t2Start;

        public TrapOverlap(Trap t1, Trap t2, Unit t2Start) {
            this.t1 = t1;
            this.t2 = t2;
            this.t2Start = t2Start;
        }
    }
}

