/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import soot.tagkit.AnnotationElem;
import soot.tagkit.IAnnotationElemTypeSwitch;
import soot.util.Switch;

public class AnnotationFloatElem
extends AnnotationElem {
    float value;

    public AnnotationFloatElem(float v, char kind, String name) {
        super(kind, name);
        this.value = v;
    }

    @Override
    public String toString() {
        return super.toString() + " value: " + this.value;
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public void apply(Switch sw) {
        ((IAnnotationElemTypeSwitch)sw).caseAnnotationFloatElem(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Float.floatToIntBits(this.value);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationFloatElem other = (AnnotationFloatElem)obj;
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(other.value);
    }
}

