/*
 * Decompiled with CFR 0.152.
 */
package soot.sootify;

import soot.AnySubType;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.ErroneousType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.NullType;
import soot.RefType;
import soot.ShortType;
import soot.StmtAddressType;
import soot.Type;
import soot.TypeSwitch;
import soot.UnknownType;
import soot.VoidType;
import soot.sootify.TemplatePrinter;

public class TypeTemplatePrinter
extends TypeSwitch {
    private String varName;
    private final TemplatePrinter p;

    public void printAssign(String v, Type t2) {
        String oldName = this.varName;
        this.varName = v;
        t2.apply(this);
        this.varName = oldName;
    }

    public TypeTemplatePrinter(TemplatePrinter p) {
        this.p = p;
    }

    public void setVariableName(String name) {
        this.varName = name;
    }

    private void emit(String rhs) {
        this.p.println("Type " + this.varName + " = " + rhs + ";");
    }

    private void emitSpecial(String type, String rhs) {
        this.p.println(type + " " + this.varName + " = " + rhs + ";");
    }

    @Override
    public void caseAnySubType(AnySubType t2) {
        throw new IllegalArgumentException("cannot print this type");
    }

    @Override
    public void caseArrayType(ArrayType t2) {
        this.printAssign("baseType", t2.getElementType());
        this.p.println("int numDimensions=" + t2.numDimensions + ";");
        this.emit("ArrayType.v(baseType, numDimensions)");
    }

    @Override
    public void caseBooleanType(BooleanType t2) {
        this.emit("BooleanType.v()");
    }

    @Override
    public void caseByteType(ByteType t2) {
        this.emit("ByteType.v()");
    }

    @Override
    public void caseCharType(CharType t2) {
        this.emit("CharType.v()");
    }

    @Override
    public void defaultCase(Type t2) {
        throw new IllegalArgumentException("cannot print this type");
    }

    @Override
    public void caseDoubleType(DoubleType t2) {
        this.emit("DoubleType.v()");
    }

    @Override
    public void caseErroneousType(ErroneousType t2) {
        throw new IllegalArgumentException("cannot print this type");
    }

    @Override
    public void caseFloatType(FloatType t2) {
        this.emit("FloatType.v()");
    }

    @Override
    public void caseIntType(IntType t2) {
        this.emit("IntType.v()");
    }

    @Override
    public void caseLongType(LongType t2) {
        this.emit("LongType.v()");
    }

    @Override
    public void caseNullType(NullType t2) {
        this.emit("NullType.v()");
    }

    @Override
    public void caseRefType(RefType t2) {
        this.emitSpecial("RefType", "RefType.v(\"" + t2.getClassName() + "\")");
    }

    @Override
    public void caseShortType(ShortType t2) {
        this.emit("ShortType.v()");
    }

    @Override
    public void caseStmtAddressType(StmtAddressType t2) {
        throw new IllegalArgumentException("cannot print this type");
    }

    @Override
    public void caseUnknownType(UnknownType t2) {
        throw new IllegalArgumentException("cannot print this type");
    }

    @Override
    public void caseVoidType(VoidType t2) {
        this.emit("VoidType.v()");
    }
}

