/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.G;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.options.Options;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.shimple.ShimpleMethodSource;

public class ShimpleTransformer
extends SceneTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ShimpleTransformer.class);

    public ShimpleTransformer(Singletons.Global g2) {
    }

    public static ShimpleTransformer v() {
        return G.v().soot_shimple_ShimpleTransformer();
    }

    protected void internalTransform(String phaseName, Map options) {
        if (Options.v().verbose()) {
            logger.debug("Transforming all classes in the Scene to Shimple...");
        }
        for (SootClass sClass : Scene.v().getClasses()) {
            if (sClass.isPhantom()) continue;
            for (SootMethod method : sClass.getMethods()) {
                if (!method.isConcrete()) continue;
                if (method.hasActiveBody()) {
                    Body body = method.getActiveBody();
                    ShimpleBody sBody = null;
                    if (body instanceof ShimpleBody) {
                        sBody = (ShimpleBody)body;
                        if (!sBody.isSSA()) {
                            sBody.rebuild();
                        }
                    } else {
                        sBody = Shimple.v().newBody(body);
                    }
                    method.setActiveBody(sBody);
                    continue;
                }
                ShimpleMethodSource ms = new ShimpleMethodSource(method.getSource());
                method.setSource(ms);
            }
        }
    }
}

