/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.integer;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.toolkits.typing.integer.TypeException;
import soot.jimple.toolkits.typing.integer.TypeNode;
import soot.jimple.toolkits.typing.integer.TypeResolver;

class TypeVariable
implements Comparable<Object> {
    private static final Logger logger = LoggerFactory.getLogger(TypeVariable.class);
    private static final boolean DEBUG = false;
    private final int id;
    private TypeVariable rep = this;
    private int rank = 0;
    private TypeNode approx;
    private TypeNode inv_approx;
    private TypeNode type;
    private List<TypeVariable> parents = Collections.emptyList();
    private List<TypeVariable> children = Collections.emptyList();

    public TypeVariable(int id, TypeResolver resolver) {
        this.id = id;
    }

    public TypeVariable(int id, TypeResolver resolver, TypeNode type) {
        this.id = id;
        this.type = type;
        this.approx = type;
        this.inv_approx = type;
    }

    public int hashCode() {
        if (this.rep != this) {
            return this.ecr().hashCode();
        }
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this.rep != this) {
            return this.ecr().equals(obj);
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        TypeVariable ecr = ((TypeVariable)obj).ecr();
        return ecr == this;
    }

    @Override
    public int compareTo(Object o) {
        if (this.rep != this) {
            return this.ecr().compareTo(o);
        }
        return this.id - ((TypeVariable)o).ecr().id;
    }

    private TypeVariable ecr() {
        if (this.rep != this) {
            this.rep = this.rep.ecr();
        }
        return this.rep;
    }

    public TypeVariable union(TypeVariable var) throws TypeException {
        if (this.rep != this) {
            return this.ecr().union(var);
        }
        TypeVariable y = var.ecr();
        if (this == y) {
            return this;
        }
        if (this.rank > y.rank) {
            y.rep = this;
            this.merge(y);
            y.clear();
            return this;
        }
        this.rep = y;
        if (this.rank == y.rank) {
            ++y.rank;
        }
        y.merge(this);
        this.clear();
        return y;
    }

    private void clear() {
        this.inv_approx = null;
        this.approx = null;
        this.type = null;
        this.parents = null;
        this.children = null;
    }

    private void merge(TypeVariable var) throws TypeException {
        if (this.type == null) {
            this.type = var.type;
        } else if (var.type != null) {
            TypeVariable.error("Type Error(22): Attempt to merge two types.");
        }
        TreeSet<TypeVariable> set = new TreeSet<TypeVariable>(this.parents);
        set.addAll(var.parents);
        set.remove(this);
        this.parents = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
        set = new TreeSet<TypeVariable>(this.children);
        set.addAll(var.children);
        set.remove(this);
        this.children = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
    }

    public int id() {
        if (this.rep != this) {
            return this.ecr().id();
        }
        return this.id;
    }

    public void addParent(TypeVariable variable) {
        if (this.rep != this) {
            this.ecr().addParent(variable);
            return;
        }
        TypeVariable var = variable.ecr();
        if (var == this) {
            return;
        }
        TreeSet<TypeVariable> set = new TreeSet<TypeVariable>(this.parents);
        set.add(var);
        this.parents = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
        set = new TreeSet<TypeVariable>(var.children);
        set.add(this);
        var.children = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
    }

    public void removeParent(TypeVariable variable) {
        if (this.rep != this) {
            this.ecr().removeParent(variable);
            return;
        }
        TypeVariable var = variable.ecr();
        TreeSet<TypeVariable> set = new TreeSet<TypeVariable>(this.parents);
        set.remove(var);
        this.parents = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
        set = new TreeSet<TypeVariable>(var.children);
        set.remove(this);
        var.children = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
    }

    public void addChild(TypeVariable variable) {
        if (this.rep != this) {
            this.ecr().addChild(variable);
            return;
        }
        TypeVariable var = variable.ecr();
        if (var == this) {
            return;
        }
        TreeSet<TypeVariable> set = new TreeSet<TypeVariable>(this.children);
        set.add(var);
        this.children = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
        set = new TreeSet<TypeVariable>(var.parents);
        set.add(this);
        var.parents = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
    }

    public void removeChild(TypeVariable variable) {
        if (this.rep != this) {
            this.ecr().removeChild(variable);
            return;
        }
        TypeVariable var = variable.ecr();
        TreeSet<TypeVariable> set = new TreeSet<TypeVariable>(this.children);
        set.remove(var);
        this.children = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
        set = new TreeSet<TypeVariable>(var.parents);
        set.remove(this);
        var.parents = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
    }

    public List<TypeVariable> parents() {
        if (this.rep != this) {
            return this.ecr().parents();
        }
        return this.parents;
    }

    public List<TypeVariable> children() {
        if (this.rep != this) {
            return this.ecr().children();
        }
        return this.children;
    }

    public TypeNode approx() {
        if (this.rep != this) {
            return this.ecr().approx();
        }
        return this.approx;
    }

    public TypeNode inv_approx() {
        if (this.rep != this) {
            return this.ecr().inv_approx();
        }
        return this.inv_approx;
    }

    public TypeNode type() {
        if (this.rep != this) {
            return this.ecr().type();
        }
        return this.type;
    }

    static void error(String message) throws TypeException {
        throw new TypeException(message);
    }

    public static void computeApprox(TreeSet<TypeVariable> workList) throws TypeException {
        while (workList.size() > 0) {
            TypeVariable var = workList.first();
            workList.remove(var);
            var.fixApprox(workList);
        }
    }

    public static void computeInvApprox(TreeSet<TypeVariable> workList) throws TypeException {
        while (workList.size() > 0) {
            TypeVariable var = workList.first();
            workList.remove(var);
            var.fixInvApprox(workList);
        }
    }

    private void fixApprox(TreeSet<TypeVariable> workList) throws TypeException {
        if (this.rep != this) {
            this.ecr().fixApprox(workList);
            return;
        }
        for (TypeVariable typeVariable : this.parents) {
            TypeVariable parent = typeVariable.ecr();
            if (parent.approx == null) {
                parent.approx = this.approx;
                workList.add(parent);
                continue;
            }
            TypeNode type = parent.approx.lca_2(this.approx);
            if (type == parent.approx) continue;
            parent.approx = type;
            workList.add(parent);
        }
        if (this.type != null) {
            this.approx = this.type;
        }
    }

    private void fixInvApprox(TreeSet<TypeVariable> workList) throws TypeException {
        if (this.rep != this) {
            this.ecr().fixInvApprox(workList);
            return;
        }
        for (TypeVariable typeVariable : this.children) {
            TypeVariable child = typeVariable.ecr();
            if (child.inv_approx == null) {
                child.inv_approx = this.inv_approx;
                workList.add(child);
                continue;
            }
            TypeNode type = child.inv_approx.gcd_2(this.inv_approx);
            if (type == child.inv_approx) continue;
            child.inv_approx = type;
            workList.add(child);
        }
        if (this.type != null) {
            this.inv_approx = this.type;
        }
    }

    public String toString() {
        if (this.rep != this) {
            return this.ecr().toString();
        }
        StringBuffer s2 = new StringBuffer();
        s2.append(",[parents:");
        boolean comma = false;
        for (TypeVariable typeVariable : this.parents) {
            if (comma) {
                s2.append(",");
            } else {
                comma = true;
            }
            s2.append(typeVariable.id());
        }
        s2.append("],[children:");
        comma = false;
        for (TypeVariable typeVariable : this.children) {
            if (comma) {
                s2.append(",");
            } else {
                comma = true;
            }
            s2.append(typeVariable.id());
        }
        s2.append("]");
        return "[id:" + this.id + (this.type != null ? ",type:" + this.type : "") + ",approx:" + this.approx + ",inv_approx:" + this.inv_approx + s2 + "]";
    }

    public void fixParents() {
        if (this.rep != this) {
            this.ecr().fixParents();
            return;
        }
        TreeSet<TypeVariable> set = new TreeSet<TypeVariable>(this.parents);
        this.parents = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
    }

    public void fixChildren() {
        if (this.rep != this) {
            this.ecr().fixChildren();
            return;
        }
        TreeSet<TypeVariable> set = new TreeSet<TypeVariable>(this.children);
        this.children = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
    }
}

