/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.fast;

import java.util.Iterator;
import soot.ArrayType;
import soot.BooleanType;
import soot.IntType;
import soot.IntegerType;
import soot.Local;
import soot.NullType;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.Constant;
import soot.jimple.DivExpr;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FieldRef;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GtExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.JimpleBody;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.RemExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.Stmt;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.UshrExpr;
import soot.jimple.XorExpr;
import soot.jimple.toolkits.typing.fast.AugEvalFunction;
import soot.jimple.toolkits.typing.fast.IUseVisitor;
import soot.jimple.toolkits.typing.fast.Integer1Type;
import soot.jimple.toolkits.typing.fast.Typing;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public class UseChecker
extends AbstractStmtSwitch {
    private JimpleBody jb;
    private Typing tg;
    private IUseVisitor uv;
    private LocalDefs defs = null;
    private LocalUses uses = null;

    public UseChecker(JimpleBody jb) {
        this.jb = jb;
    }

    public void check(Typing tg, IUseVisitor uv) {
        this.tg = tg;
        this.uv = uv;
        if (this.tg == null) {
            throw new RuntimeException("null typing passed to useChecker");
        }
        Iterator i = this.jb.getUnits().snapshotIterator();
        while (i.hasNext()) {
            if (uv.finish()) {
                return;
            }
            ((Unit)i.next()).apply(this);
        }
    }

    private void handleInvokeExpr(InvokeExpr ie, Stmt stmt) {
        SootMethodRef m4 = ie.getMethodRef();
        if (ie instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
            iie.setBase(this.uv.visit(iie.getBase(), m4.getDeclaringClass().getType(), stmt));
        }
        for (int i = 0; i < ie.getArgCount(); ++i) {
            ie.setArg(i, this.uv.visit(ie.getArg(i), m4.getParameterType(i), stmt));
        }
    }

    private void handleBinopExpr(BinopExpr be, Stmt stmt, Type tlhs) {
        Value opl = be.getOp1();
        Value opr = be.getOp2();
        Type tl = AugEvalFunction.eval_(this.tg, opl, stmt, this.jb);
        Type tr = AugEvalFunction.eval_(this.tg, opr, stmt, this.jb);
        if (be instanceof AddExpr || be instanceof SubExpr || be instanceof MulExpr || be instanceof DivExpr || be instanceof RemExpr || be instanceof GeExpr || be instanceof GtExpr || be instanceof LeExpr || be instanceof LtExpr || be instanceof ShlExpr || be instanceof ShrExpr || be instanceof UshrExpr) {
            if (tlhs instanceof IntegerType) {
                be.setOp1(this.uv.visit(opl, IntType.v(), stmt));
                be.setOp2(this.uv.visit(opr, IntType.v(), stmt));
            }
        } else if (!(be instanceof CmpExpr || be instanceof CmpgExpr || be instanceof CmplExpr)) {
            if (be instanceof AndExpr || be instanceof OrExpr || be instanceof XorExpr) {
                be.setOp1(this.uv.visit(opl, tlhs, stmt));
                be.setOp2(this.uv.visit(opr, tlhs, stmt));
            } else if (!(!(be instanceof EqExpr) && !(be instanceof NeExpr) || tl instanceof BooleanType && tr instanceof BooleanType || tl instanceof Integer1Type || tr instanceof Integer1Type || !(tl instanceof IntegerType))) {
                be.setOp1(this.uv.visit(opl, IntType.v(), stmt));
                be.setOp2(this.uv.visit(opr, IntType.v(), stmt));
            }
        }
    }

    private void handleArrayRef(ArrayRef ar, Stmt stmt) {
        ar.setIndex(this.uv.visit(ar.getIndex(), IntType.v(), stmt));
    }

    private void handleInstanceFieldRef(InstanceFieldRef ifr, Stmt stmt) {
        ifr.setBase(this.uv.visit(ifr.getBase(), ifr.getFieldRef().declaringClass().getType(), stmt));
    }

    @Override
    public void caseBreakpointStmt(BreakpointStmt stmt) {
    }

    @Override
    public void caseInvokeStmt(InvokeStmt stmt) {
        this.handleInvokeExpr(stmt.getInvokeExpr(), stmt);
    }

    @Override
    public void caseAssignStmt(AssignStmt stmt) {
        ArrayType at;
        Local base;
        ArrayRef aref;
        Value lhs = stmt.getLeftOp();
        Value rhs = stmt.getRightOp();
        Type tlhs = null;
        if (lhs instanceof Local) {
            tlhs = this.tg.get((Local)lhs);
        } else if (lhs instanceof ArrayRef) {
            aref = (ArrayRef)lhs;
            base = (Local)aref.getBase();
            at = null;
            Type tgType = this.tg.get(base);
            if (tgType instanceof ArrayType) {
                at = (ArrayType)tgType;
            } else {
                Type rhsType;
                if (tgType == Scene.v().getObjectType() && rhs instanceof Local && (rhsType = this.tg.get((Local)rhs)) instanceof PrimType) {
                    if (this.defs == null) {
                        this.defs = LocalDefs.Factory.newLocalDefs(this.jb);
                        this.uses = LocalUses.Factory.newLocalUses(this.jb, this.defs);
                    }
                    for (Unit defU : this.defs.getDefsOfAt(base, stmt)) {
                        AssignStmt defUas;
                        if (!(defU instanceof AssignStmt) || !((defUas = (AssignStmt)defU).getRightOp() instanceof NewArrayExpr)) continue;
                        at = (ArrayType)defUas.getRightOp().getType();
                        break;
                    }
                }
                if (at == null) {
                    at = tgType.makeArrayType();
                }
            }
            tlhs = at.getElementType();
            this.handleArrayRef(aref, stmt);
            aref.setBase((Local)this.uv.visit(aref.getBase(), at, stmt));
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
            stmt.setLeftOp(this.uv.visit(lhs, tlhs, stmt));
        } else if (lhs instanceof FieldRef) {
            tlhs = ((FieldRef)lhs).getFieldRef().type();
            if (lhs instanceof InstanceFieldRef) {
                this.handleInstanceFieldRef((InstanceFieldRef)lhs, stmt);
            }
        }
        lhs = stmt.getLeftOp();
        rhs = stmt.getRightOp();
        if (rhs instanceof Local) {
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof ArrayRef) {
            aref = (ArrayRef)rhs;
            base = (Local)aref.getBase();
            at = null;
            Type et = null;
            if (this.tg.get(base) instanceof ArrayType) {
                at = (ArrayType)this.tg.get(base);
            } else {
                Type bt;
                et = bt = this.tg.get(base);
                if (bt instanceof RefType || bt instanceof NullType) {
                    RefType rt;
                    RefType refType = rt = bt instanceof NullType ? null : (RefType)bt;
                    if (rt == null || rt.getSootClass().getName().equals("java.lang.Object") || rt.getSootClass().getName().equals("java.io.Serializable") || rt.getSootClass().getName().equals("java.lang.Cloneable")) {
                        if (this.defs == null) {
                            this.defs = LocalDefs.Factory.newLocalDefs(this.jb);
                            this.uses = LocalUses.Factory.newLocalUses(this.jb, this.defs);
                        }
                        block1: for (UnitValueBoxPair usePair : this.uses.getUsesOf(stmt)) {
                            Stmt useStmt = (Stmt)usePair.getUnit();
                            if (useStmt.containsInvokeExpr()) {
                                for (int i = 0; i < useStmt.getInvokeExpr().getArgCount(); ++i) {
                                    if (useStmt.getInvokeExpr().getArg(i) != usePair.getValueBox().getValue()) continue;
                                    et = useStmt.getInvokeExpr().getMethod().getParameterType(i);
                                    at = et.makeArrayType();
                                    break block1;
                                }
                                continue;
                            }
                            if (useStmt instanceof IfStmt) {
                                EqExpr expr;
                                Value other;
                                Type newEt;
                                IfStmt ifStmt = (IfStmt)useStmt;
                                if (!(ifStmt.getCondition() instanceof EqExpr) || (newEt = this.getTargetType(other = (expr = (EqExpr)ifStmt.getCondition()).getOp1() == usePair.getValueBox().getValue() ? expr.getOp2() : expr.getOp1())) == null) continue;
                                et = newEt;
                                continue;
                            }
                            if (useStmt instanceof AssignStmt) {
                                AssignStmt useAssignStmt = (AssignStmt)useStmt;
                                Value rop = useAssignStmt.getRightOp();
                                if (rop instanceof BinopExpr) {
                                    BinopExpr binOp = (BinopExpr)useAssignStmt.getRightOp();
                                    Value other = binOp.getOp1() == usePair.getValueBox().getValue() ? binOp.getOp2() : binOp.getOp1();
                                    Type newEt = this.getTargetType(other);
                                    if (newEt == null) continue;
                                    et = newEt;
                                    continue;
                                }
                                if (!(rop instanceof CastExpr)) continue;
                                et = ((CastExpr)rop).getCastType();
                                continue;
                            }
                            if (!(useStmt instanceof ReturnStmt)) continue;
                            et = this.jb.getMethod().getReturnType();
                        }
                    }
                }
                if (at == null) {
                    at = et.makeArrayType();
                }
            }
            Type trhs = at.getElementType();
            this.handleArrayRef(aref, stmt);
            aref.setBase((Local)this.uv.visit(aref.getBase(), at, stmt));
            stmt.setRightOp(this.uv.visit(rhs, trhs, stmt));
        } else if (rhs instanceof InstanceFieldRef) {
            this.handleInstanceFieldRef((InstanceFieldRef)rhs, stmt);
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof BinopExpr) {
            this.handleBinopExpr((BinopExpr)rhs, stmt, tlhs);
        } else if (rhs instanceof InvokeExpr) {
            this.handleInvokeExpr((InvokeExpr)rhs, stmt);
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof CastExpr) {
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof InstanceOfExpr) {
            InstanceOfExpr ioe = (InstanceOfExpr)rhs;
            ioe.setOp(this.uv.visit(ioe.getOp(), RefType.v("java.lang.Object"), stmt));
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof NewArrayExpr) {
            NewArrayExpr nae = (NewArrayExpr)rhs;
            nae.setSize(this.uv.visit(nae.getSize(), IntType.v(), stmt));
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof NewMultiArrayExpr) {
            NewMultiArrayExpr nmae = (NewMultiArrayExpr)rhs;
            for (int i = 0; i < nmae.getSizeCount(); ++i) {
                nmae.setSize(i, this.uv.visit(nmae.getSize(i), IntType.v(), stmt));
            }
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof LengthExpr) {
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        } else if (rhs instanceof NegExpr) {
            ((NegExpr)rhs).setOp(this.uv.visit(((NegExpr)rhs).getOp(), tlhs, stmt));
        } else if (rhs instanceof Constant && !(rhs instanceof NullConstant)) {
            stmt.setRightOp(this.uv.visit(rhs, tlhs, stmt));
        }
    }

    private Type getTargetType(Value other) {
        Type tgTp;
        if (other instanceof Constant) {
            if (other.getType() != NullType.v()) {
                return other.getType();
            }
        } else if (other instanceof Local && (tgTp = this.tg.get((Local)other)) instanceof PrimType) {
            return tgTp;
        }
        return null;
    }

    @Override
    public void caseIdentityStmt(IdentityStmt stmt) {
    }

    @Override
    public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
        stmt.setOp(this.uv.visit(stmt.getOp(), RefType.v("java.lang.Object"), stmt));
    }

    @Override
    public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
        stmt.setOp(this.uv.visit(stmt.getOp(), RefType.v("java.lang.Object"), stmt));
    }

    @Override
    public void caseGotoStmt(GotoStmt stmt) {
    }

    @Override
    public void caseIfStmt(IfStmt stmt) {
        this.handleBinopExpr((BinopExpr)stmt.getCondition(), stmt, BooleanType.v());
    }

    @Override
    public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
        stmt.setKey(this.uv.visit(stmt.getKey(), IntType.v(), stmt));
    }

    @Override
    public void caseNopStmt(NopStmt stmt) {
    }

    @Override
    public void caseReturnStmt(ReturnStmt stmt) {
        stmt.setOp(this.uv.visit(stmt.getOp(), this.jb.getMethod().getReturnType(), stmt));
    }

    @Override
    public void caseReturnVoidStmt(ReturnVoidStmt stmt) {
    }

    @Override
    public void caseTableSwitchStmt(TableSwitchStmt stmt) {
        stmt.setKey(this.uv.visit(stmt.getKey(), IntType.v(), stmt));
    }

    @Override
    public void caseThrowStmt(ThrowStmt stmt) {
        stmt.setOp(this.uv.visit(stmt.getOp(), RefType.v("java.lang.Throwable"), stmt));
    }

    public void defaultCase(Stmt stmt) {
        throw new RuntimeException("Unhandled stgtement type: " + stmt.getClass());
    }
}

