/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.fast;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.IntegerType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.TrapManager;
import soot.Type;
import soot.Value;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.EqExpr;
import soot.jimple.FieldRef;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GtExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.JimpleBody;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LtExpr;
import soot.jimple.MethodHandle;
import soot.jimple.MethodType;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.ParameterRef;
import soot.jimple.RemExpr;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.ThisRef;
import soot.jimple.UshrExpr;
import soot.jimple.XorExpr;
import soot.jimple.toolkits.typing.fast.AugHierarchy;
import soot.jimple.toolkits.typing.fast.BottomType;
import soot.jimple.toolkits.typing.fast.BytecodeHierarchy;
import soot.jimple.toolkits.typing.fast.IEvalFunction;
import soot.jimple.toolkits.typing.fast.Integer127Type;
import soot.jimple.toolkits.typing.fast.Integer1Type;
import soot.jimple.toolkits.typing.fast.Integer32767Type;
import soot.jimple.toolkits.typing.fast.Typing;

public class AugEvalFunction
implements IEvalFunction {
    private JimpleBody jb;

    public AugEvalFunction(JimpleBody jb) {
        this.jb = jb;
    }

    public static Type eval_(Typing tg, Value expr, Stmt stmt, JimpleBody jb) {
        if (expr instanceof ThisRef) {
            return ((ThisRef)expr).getType();
        }
        if (expr instanceof ParameterRef) {
            return ((ParameterRef)expr).getType();
        }
        if (expr instanceof Local) {
            Local ex = (Local)expr;
            if (tg == null) {
                return null;
            }
            return tg.get(ex);
        }
        if (expr instanceof BinopExpr) {
            BinopExpr be = (BinopExpr)expr;
            Value opl = be.getOp1();
            Value opr = be.getOp2();
            Type tl = AugEvalFunction.eval_(tg, opl, stmt, jb);
            Type tr = AugEvalFunction.eval_(tg, opr, stmt, jb);
            if (expr instanceof CmpExpr || expr instanceof CmpgExpr || expr instanceof CmplExpr) {
                return ByteType.v();
            }
            if (expr instanceof GeExpr || expr instanceof GtExpr || expr instanceof LeExpr || expr instanceof LtExpr || expr instanceof EqExpr || expr instanceof NeExpr) {
                return BooleanType.v();
            }
            if (expr instanceof ShlExpr || expr instanceof ShrExpr || expr instanceof UshrExpr) {
                if (tl instanceof IntegerType) {
                    return IntType.v();
                }
                return tl;
            }
            if (expr instanceof AddExpr || expr instanceof SubExpr || expr instanceof MulExpr || expr instanceof DivExpr || expr instanceof RemExpr) {
                if (tl instanceof IntegerType) {
                    return IntType.v();
                }
                return tl;
            }
            if (expr instanceof AndExpr || expr instanceof OrExpr || expr instanceof XorExpr) {
                if (tl instanceof IntegerType && tr instanceof IntegerType) {
                    if (tl instanceof BooleanType) {
                        if (tr instanceof BooleanType) {
                            return BooleanType.v();
                        }
                        return tr;
                    }
                    if (tr instanceof BooleanType) {
                        return tl;
                    }
                    Collection<Type> rs = AugHierarchy.lcas_(tl, tr);
                    Iterator<Type> iterator = rs.iterator();
                    if (iterator.hasNext()) {
                        Type r = iterator.next();
                        if (r instanceof BooleanType) {
                            return r;
                        }
                        if (r instanceof IntegerType) {
                            return IntType.v();
                        }
                        return r;
                    }
                    throw new RuntimeException();
                }
                if (tl instanceof RefLikeType) {
                    return tr;
                }
                return tl;
            }
            throw new RuntimeException("Unhandled binary expression: " + expr);
        }
        if (expr instanceof NegExpr) {
            Type t2 = AugEvalFunction.eval_(tg, ((NegExpr)expr).getOp(), stmt, jb);
            if (t2 instanceof IntegerType) {
                if (t2 instanceof Integer1Type || t2 instanceof BooleanType || t2 instanceof Integer127Type || t2 instanceof ByteType) {
                    return ByteType.v();
                }
                if (t2 instanceof ShortType || t2 instanceof Integer32767Type) {
                    return ShortType.v();
                }
                return IntType.v();
            }
            return t2;
        }
        if (expr instanceof CaughtExceptionRef) {
            RefType r = null;
            RefType throwableType = Scene.v().getRefType("java.lang.Throwable");
            for (RefType t3 : TrapManager.getExceptionTypesOf(stmt, jb)) {
                if (r == null) {
                    if (t3.getSootClass().isPhantom()) {
                        r = throwableType;
                        continue;
                    }
                    r = t3;
                    continue;
                }
                if (t3.getSootClass().isPhantom()) {
                    r = throwableType;
                    continue;
                }
                r = BytecodeHierarchy.lcsc(r, t3, throwableType);
            }
            if (r == null) {
                throw new RuntimeException("Exception reference used other than as the first statement of an exception handler.");
            }
            return r;
        }
        if (expr instanceof ArrayRef) {
            Local av = (Local)((ArrayRef)expr).getBase();
            Type at = tg.get(av);
            if (at instanceof ArrayType) {
                return ((ArrayType)at).getElementType();
            }
            if (at instanceof RefType) {
                RefType ref = (RefType)at;
                if (ref.getSootClass().getName().equals("java.lang.Object") || ref.getSootClass().getName().equals("java.io.Serializable") || ref.getSootClass().getName().equals("java.lang.Cloneable")) {
                    return ref;
                }
                return BottomType.v();
            }
            return BottomType.v();
        }
        if (expr instanceof NewArrayExpr) {
            return ((NewArrayExpr)expr).getBaseType().makeArrayType();
        }
        if (expr instanceof NewMultiArrayExpr) {
            return ((NewMultiArrayExpr)expr).getBaseType();
        }
        if (expr instanceof CastExpr) {
            return ((CastExpr)expr).getCastType();
        }
        if (expr instanceof InstanceOfExpr) {
            return BooleanType.v();
        }
        if (expr instanceof LengthExpr) {
            return IntType.v();
        }
        if (expr instanceof InvokeExpr) {
            return ((InvokeExpr)expr).getMethodRef().returnType();
        }
        if (expr instanceof NewExpr) {
            return ((NewExpr)expr).getBaseType();
        }
        if (expr instanceof FieldRef) {
            return ((FieldRef)expr).getType();
        }
        if (expr instanceof DoubleConstant) {
            return DoubleType.v();
        }
        if (expr instanceof FloatConstant) {
            return FloatType.v();
        }
        if (expr instanceof IntConstant) {
            int value = ((IntConstant)expr).value;
            if (value >= 0 && value < 2) {
                return Integer1Type.v();
            }
            if (value >= 2 && value < 128) {
                return Integer127Type.v();
            }
            if (value >= -128 && value < 0) {
                return ByteType.v();
            }
            if (value >= 128 && value < 32768) {
                return Integer32767Type.v();
            }
            if (value >= Short.MIN_VALUE && value < -128) {
                return ShortType.v();
            }
            if (value >= 32768 && value < 65536) {
                return CharType.v();
            }
            return IntType.v();
        }
        if (expr instanceof LongConstant) {
            return LongType.v();
        }
        if (expr instanceof NullConstant) {
            return NullType.v();
        }
        if (expr instanceof StringConstant) {
            return RefType.v("java.lang.String");
        }
        if (expr instanceof ClassConstant) {
            return RefType.v("java.lang.Class");
        }
        if (expr instanceof MethodHandle) {
            return RefType.v("java.lang.invoke.MethodHandle");
        }
        if (expr instanceof MethodType) {
            return RefType.v("java.lang.invoke.MethodType");
        }
        throw new RuntimeException("Unhandled expression: " + expr);
    }

    @Override
    public Collection<Type> eval(Typing tg, Value expr, Stmt stmt) {
        return Collections.singletonList(AugEvalFunction.eval_(tg, expr, stmt, this.jb));
    }
}

