/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.RefType;
import soot.jimple.toolkits.typing.InternalTypingException;
import soot.jimple.toolkits.typing.TypeException;
import soot.jimple.toolkits.typing.TypeNode;
import soot.jimple.toolkits.typing.TypeResolver;
import soot.options.Options;
import soot.util.BitVector;

class TypeVariable
implements Comparable<Object> {
    private static final Logger logger = LoggerFactory.getLogger(TypeVariable.class);
    private static final boolean DEBUG = false;
    private final int id;
    private final TypeResolver resolver;
    private TypeVariable rep = this;
    private int rank = 0;
    private TypeNode approx;
    private TypeNode type;
    private TypeVariable array;
    private TypeVariable element;
    private int depth;
    private List<TypeVariable> parents = Collections.emptyList();
    private List<TypeVariable> children = Collections.emptyList();
    private BitVector ancestors;
    private BitVector indirectAncestors;

    public TypeVariable(int id, TypeResolver resolver) {
        this.id = id;
        this.resolver = resolver;
    }

    public TypeVariable(int id, TypeResolver resolver, TypeNode type) {
        this.id = id;
        this.resolver = resolver;
        this.type = type;
        this.approx = type;
        for (TypeNode parent : type.parents()) {
            this.addParent(resolver.typeVariable(parent));
        }
        if (type.hasElement()) {
            this.element = resolver.typeVariable(type.element());
            this.element.array = this;
        }
    }

    public int hashCode() {
        if (this.rep != this) {
            return this.ecr().hashCode();
        }
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this.rep != this) {
            return this.ecr().equals(obj);
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        TypeVariable ecr = ((TypeVariable)obj).ecr();
        return ecr == this;
    }

    @Override
    public int compareTo(Object o) {
        if (this.rep != this) {
            return this.ecr().compareTo(o);
        }
        return this.id - ((TypeVariable)o).ecr().id;
    }

    private TypeVariable ecr() {
        if (this.rep != this) {
            this.rep = this.rep.ecr();
        }
        return this.rep;
    }

    public TypeVariable union(TypeVariable var) throws TypeException {
        if (this.rep != this) {
            return this.ecr().union(var);
        }
        TypeVariable y = var.ecr();
        if (this == y) {
            return this;
        }
        if (this.rank > y.rank) {
            y.rep = this;
            this.merge(y);
            y.clear();
            return this;
        }
        this.rep = y;
        if (this.rank == y.rank) {
            ++y.rank;
        }
        y.merge(this);
        this.clear();
        return y;
    }

    private void clear() {
        this.approx = null;
        this.type = null;
        this.element = null;
        this.array = null;
        this.parents = null;
        this.children = null;
        this.ancestors = null;
        this.indirectAncestors = null;
    }

    private void merge(TypeVariable var) throws TypeException {
        if (this.depth != 0 || var.depth != 0) {
            throw new InternalTypingException();
        }
        if (this.type == null) {
            this.type = var.type;
        } else if (var.type != null) {
            TypeVariable.error("Type Error(1): Attempt to merge two types.");
        }
        TreeSet<TypeVariable> set = new TreeSet<TypeVariable>(this.parents);
        set.addAll(var.parents);
        set.remove(this);
        this.parents = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
        set = new TreeSet<TypeVariable>(this.children);
        set.addAll(var.children);
        set.remove(this);
        this.children = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
    }

    void validate() throws TypeException {
        if (this.rep != this) {
            this.ecr().validate();
            return;
        }
        if (this.type != null) {
            for (TypeVariable typeVariable : this.parents) {
                TypeVariable parent = typeVariable.ecr();
                if (parent.type == null || this.type.hasAncestor(parent.type)) continue;
                TypeVariable.error("Type Error(2): Parent type is not a valid ancestor.");
            }
            for (TypeVariable typeVariable : this.children) {
                TypeVariable child = typeVariable.ecr();
                if (child.type == null || this.type.hasDescendant(child.type)) continue;
                TypeVariable.error("Type Error(3): Child type is not a valid descendant.");
            }
        }
    }

    public void removeIndirectRelations() {
        if (this.rep != this) {
            this.ecr().removeIndirectRelations();
            return;
        }
        if (this.indirectAncestors == null) {
            this.fixAncestors();
        }
        LinkedList<TypeVariable> parentsToRemove = new LinkedList<TypeVariable>();
        for (TypeVariable parent : this.parents) {
            if (!this.indirectAncestors.get(parent.id())) continue;
            parentsToRemove.add(parent);
        }
        for (TypeVariable parent : parentsToRemove) {
            this.removeParent(parent);
        }
    }

    private void fixAncestors() {
        BitVector ancestors = new BitVector(0);
        BitVector indirectAncestors = new BitVector(0);
        for (TypeVariable typeVariable : this.parents) {
            TypeVariable parent = typeVariable.ecr();
            if (parent.ancestors == null) {
                parent.fixAncestors();
            }
            ancestors.set(parent.id);
            ancestors.or(parent.ancestors);
            indirectAncestors.or(parent.ancestors);
        }
        this.ancestors = ancestors;
        this.indirectAncestors = indirectAncestors;
    }

    public int id() {
        if (this.rep != this) {
            return this.ecr().id();
        }
        return this.id;
    }

    public void addParent(TypeVariable variable) {
        if (this.rep != this) {
            this.ecr().addParent(variable);
            return;
        }
        TypeVariable var = variable.ecr();
        if (var == this) {
            return;
        }
        TreeSet<TypeVariable> set = new TreeSet<TypeVariable>(this.parents);
        set.add(var);
        this.parents = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
        set = new TreeSet<TypeVariable>(var.children);
        set.add(this);
        var.children = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
    }

    public void removeParent(TypeVariable variable) {
        if (this.rep != this) {
            this.ecr().removeParent(variable);
            return;
        }
        TypeVariable var = variable.ecr();
        TreeSet<TypeVariable> set = new TreeSet<TypeVariable>(this.parents);
        set.remove(var);
        this.parents = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
        set = new TreeSet<TypeVariable>(var.children);
        set.remove(this);
        var.children = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
    }

    public void addChild(TypeVariable variable) {
        if (this.rep != this) {
            this.ecr().addChild(variable);
            return;
        }
        TypeVariable var = variable.ecr();
        if (var == this) {
            return;
        }
        TreeSet<TypeVariable> set = new TreeSet<TypeVariable>(this.children);
        set.add(var);
        this.children = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
        set = new TreeSet<TypeVariable>(var.parents);
        set.add(this);
        var.parents = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
    }

    public void removeChild(TypeVariable variable) {
        if (this.rep != this) {
            this.ecr().removeChild(variable);
            return;
        }
        TypeVariable var = variable.ecr();
        TreeSet<TypeVariable> set = new TreeSet<TypeVariable>(this.children);
        set.remove(var);
        this.children = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
        set = new TreeSet<TypeVariable>(var.parents);
        set.remove(this);
        var.parents = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
    }

    public int depth() {
        if (this.rep != this) {
            return this.ecr().depth();
        }
        return this.depth;
    }

    public void makeElement() {
        if (this.rep != this) {
            this.ecr().makeElement();
            return;
        }
        if (this.element == null) {
            this.element = this.resolver.typeVariable();
            this.element.array = this;
        }
    }

    public TypeVariable element() {
        if (this.rep != this) {
            return this.ecr().element();
        }
        return this.element == null ? null : this.element.ecr();
    }

    public TypeVariable array() {
        if (this.rep != this) {
            return this.ecr().array();
        }
        return this.array == null ? null : this.array.ecr();
    }

    public List<TypeVariable> parents() {
        if (this.rep != this) {
            return this.ecr().parents();
        }
        return this.parents;
    }

    public List<TypeVariable> children() {
        if (this.rep != this) {
            return this.ecr().children();
        }
        return this.children;
    }

    public TypeNode approx() {
        if (this.rep != this) {
            return this.ecr().approx();
        }
        return this.approx;
    }

    public TypeNode type() {
        if (this.rep != this) {
            return this.ecr().type();
        }
        return this.type;
    }

    static void error(String message) throws TypeException {
        throw new TypeException(message);
    }

    public static void computeApprox(TreeSet<TypeVariable> workList) throws TypeException {
        while (workList.size() > 0) {
            TypeVariable var = workList.first();
            workList.remove(var);
            var.fixApprox(workList);
        }
    }

    private void fixApprox(TreeSet<TypeVariable> workList) throws TypeException {
        TypeNode type;
        if (this.rep != this) {
            this.ecr().fixApprox(workList);
            return;
        }
        if (this.type == null && this.approx != this.resolver.hierarchy().NULL) {
            TypeVariable array;
            TypeVariable element = this.element();
            if (element != null) {
                if (!this.approx.hasElement()) {
                    logger.debug("*** " + this + " ***");
                    TypeVariable.error("Type Error(4)");
                }
                TypeNode temp = this.approx.element();
                if (element.approx == null) {
                    element.approx = temp;
                    workList.add(element);
                } else {
                    TypeNode type2 = element.approx.lca(temp);
                    if (type2 != element.approx) {
                        element.approx = type2;
                        workList.add(element);
                    } else if (element.approx != this.resolver.hierarchy().INT && (type2 = this.approx.lca(element.approx.array())) != this.approx) {
                        this.approx = type2;
                        workList.add(this);
                    }
                }
            }
            if ((array = this.array()) != null && this.approx != this.resolver.hierarchy().NULL && this.approx != this.resolver.hierarchy().INT) {
                TypeNode temp = this.approx.array();
                if (array.approx == null) {
                    array.approx = temp;
                    workList.add(array);
                } else {
                    type = array.approx.lca(temp);
                    if (type != array.approx) {
                        array.approx = type;
                        workList.add(array);
                    } else {
                        type = this.approx.lca(array.approx.element());
                        if (type != this.approx) {
                            this.approx = type;
                            workList.add(this);
                        }
                    }
                }
            }
        }
        for (TypeVariable typeVariable : this.parents) {
            TypeVariable parent = typeVariable.ecr();
            if (parent.approx == null) {
                parent.approx = this.approx;
                workList.add(parent);
                continue;
            }
            type = parent.approx.lca(this.approx);
            if (type == parent.approx) continue;
            parent.approx = type;
            workList.add(parent);
        }
        if (this.type != null) {
            this.approx = this.type;
        }
    }

    public void fixDepth() throws TypeException {
        ArrayType at;
        if (this.rep != this) {
            this.ecr().fixDepth();
            return;
        }
        if (this.type != null) {
            if (this.type.type() instanceof ArrayType) {
                at = (ArrayType)this.type.type();
                this.depth = at.numDimensions;
            } else {
                this.depth = 0;
            }
        } else if (this.approx.type() instanceof ArrayType) {
            at = (ArrayType)this.approx.type();
            this.depth = at.numDimensions;
        } else {
            this.depth = 0;
        }
        if (this.depth == 0 && this.element() != null) {
            TypeVariable.error("Type Error(11)");
        } else if (this.depth > 0 && this.element() == null) {
            this.makeElement();
            TypeVariable element = this.element();
            element.depth = this.depth - 1;
            while (element.depth != 0) {
                element.makeElement();
                element.element().depth = element.depth - 1;
                element = element.element();
            }
        }
    }

    public void propagate() {
        if (this.rep != this) {
            this.ecr().propagate();
        }
        if (this.depth == 0) {
            return;
        }
        for (TypeVariable typeVariable : this.parents) {
            TypeVariable var = typeVariable.ecr();
            if (var.depth() == this.depth) {
                this.element().addParent(var.element());
                continue;
            }
            if (var.depth() == 0) {
                if (var.type() != null || Options.v().j2me()) continue;
                var.addChild(this.resolver.typeVariable(this.resolver.hierarchy().CLONEABLE));
                var.addChild(this.resolver.typeVariable(this.resolver.hierarchy().SERIALIZABLE));
                continue;
            }
            if (var.type() != null || Options.v().j2me()) continue;
            var.addChild(this.resolver.typeVariable(ArrayType.v(RefType.v("java.lang.Cloneable"), var.depth())));
            var.addChild(this.resolver.typeVariable(ArrayType.v(RefType.v("java.io.Serializable"), var.depth())));
        }
        for (TypeVariable var : this.parents) {
            this.removeParent(var);
        }
    }

    public String toString() {
        if (this.rep != this) {
            return this.ecr().toString();
        }
        StringBuffer s2 = new StringBuffer();
        s2.append(",[parents:");
        boolean comma = false;
        for (TypeVariable typeVariable : this.parents) {
            if (comma) {
                s2.append(",");
            } else {
                comma = true;
            }
            s2.append(typeVariable.id());
        }
        s2.append("],[children:");
        comma = false;
        for (TypeVariable typeVariable : this.children) {
            if (comma) {
                s2.append(",");
            } else {
                comma = true;
            }
            s2.append(typeVariable.id());
        }
        s2.append("]");
        return "[id:" + this.id + ",depth:" + this.depth + (this.type != null ? ",type:" + this.type : "") + ",approx:" + this.approx + s2 + (this.element == null ? "" : ",arrayof:" + this.element.id()) + "]";
    }

    public void fixParents() {
        if (this.rep != this) {
            this.ecr().fixParents();
            return;
        }
        TreeSet<TypeVariable> set = new TreeSet<TypeVariable>(this.parents);
        this.parents = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
    }

    public void fixChildren() {
        if (this.rep != this) {
            this.ecr().fixChildren();
            return;
        }
        TreeSet<TypeVariable> set = new TreeSet<TypeVariable>(this.children);
        this.children = Collections.unmodifiableList(new LinkedList<TypeVariable>(set));
    }
}

