/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.synchronization;

import java.util.ArrayList;
import java.util.List;
import soot.Hierarchy;
import soot.Local;
import soot.PointsToAnalysis;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.pointer.CodeBlockRWSet;
import soot.jimple.toolkits.thread.mhp.MhpTester;
import soot.jimple.toolkits.thread.synchronization.CriticalSection;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionDataDependency;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionGroup;

public class CriticalSectionInterferenceGraph {
    int nextGroup;
    List<CriticalSectionGroup> groups;
    List<CriticalSection> criticalSections;
    MhpTester mhp;
    PointsToAnalysis pta;
    boolean optionOneGlobalLock = false;
    boolean optionLeaveOriginalLocks = false;
    boolean optionIncludeEmptyPossibleEdges = false;

    public CriticalSectionInterferenceGraph(List<CriticalSection> criticalSections, MhpTester mhp, boolean optionOneGlobalLock, boolean optionLeaveOriginalLocks, boolean optionIncludeEmptyPossibleEdges) {
        this.criticalSections = criticalSections;
        this.mhp = mhp;
        this.pta = Scene.v().getPointsToAnalysis();
        this.optionOneGlobalLock = optionOneGlobalLock;
        this.optionLeaveOriginalLocks = optionLeaveOriginalLocks;
        this.optionIncludeEmptyPossibleEdges = optionIncludeEmptyPossibleEdges;
        this.calculateGroups();
    }

    public int groupCount() {
        return this.nextGroup;
    }

    public List<CriticalSectionGroup> groups() {
        return this.groups;
    }

    public void calculateGroups() {
        this.nextGroup = 1;
        this.groups = new ArrayList<CriticalSectionGroup>();
        this.groups.add(new CriticalSectionGroup(0));
        if (this.optionOneGlobalLock) {
            CriticalSectionGroup onlyGroup = new CriticalSectionGroup(this.nextGroup);
            for (CriticalSection tn1 : this.criticalSections) {
                onlyGroup.add(tn1);
            }
            ++this.nextGroup;
            this.groups.add(onlyGroup);
        } else {
            for (CriticalSection tn1 : this.criticalSections) {
                if (tn1.setNumber == -1) continue;
                if (tn1.read.size() == 0 && tn1.write.size() == 0 && !this.optionLeaveOriginalLocks) {
                    tn1.setNumber = -1;
                    continue;
                }
                for (CriticalSection tn2 : this.criticalSections) {
                    int size;
                    if (tn2.setNumber == -1 || !this.mayHappenInParallel(tn1, tn2)) continue;
                    SootClass classOne = null;
                    SootClass classTwo = null;
                    boolean typeCompatible = false;
                    boolean emptyEdge = false;
                    if (tn1.origLock != null && tn2.origLock != null) {
                        emptyEdge = tn1.origLock == null || tn2.origLock == null ? true : (!(tn1.origLock instanceof Local) || !(tn2.origLock instanceof Local) ? !tn1.origLock.equals(tn2.origLock) : !this.pta.reachingObjects((Local)tn1.origLock).hasNonEmptyIntersection(this.pta.reachingObjects((Local)tn2.origLock)));
                        RefLikeType typeOne = (RefLikeType)tn1.origLock.getType();
                        RefLikeType typeTwo = (RefLikeType)tn2.origLock.getType();
                        classOne = typeOne instanceof RefType ? ((RefType)typeOne).getSootClass() : null;
                        SootClass sootClass = classTwo = typeTwo instanceof RefType ? ((RefType)typeTwo).getSootClass() : null;
                        if (classOne != null && classTwo != null) {
                            Hierarchy h2 = Scene.v().getActiveHierarchy();
                            if (classOne.isInterface()) {
                                typeCompatible = classTwo.isInterface() ? h2.getSubinterfacesOfIncluding(classOne).contains(classTwo) || h2.getSubinterfacesOfIncluding(classTwo).contains(classOne) : h2.getImplementersOf(classOne).contains(classTwo);
                            } else if (classTwo.isInterface()) {
                                typeCompatible = h2.getImplementersOf(classTwo).contains(classOne);
                            } else {
                                boolean bl = typeCompatible = classOne != null && Scene.v().getActiveHierarchy().getSubclassesOfIncluding(classOne).contains(classTwo) || classTwo != null && Scene.v().getActiveHierarchy().getSubclassesOfIncluding(classTwo).contains(classOne);
                            }
                        }
                    }
                    if ((this.optionLeaveOriginalLocks || !tn1.write.hasNonEmptyIntersection(tn2.write) && !tn1.write.hasNonEmptyIntersection(tn2.read) && !tn1.read.hasNonEmptyIntersection(tn2.write)) && (!this.optionLeaveOriginalLocks || !typeCompatible || !this.optionIncludeEmptyPossibleEdges && emptyEdge)) continue;
                    CodeBlockRWSet rw = null;
                    if (this.optionLeaveOriginalLocks) {
                        rw = new CodeBlockRWSet();
                        size = emptyEdge ? 0 : 1;
                    } else {
                        rw = tn1.write.intersection(tn2.write);
                        rw.union(tn1.write.intersection(tn2.read));
                        rw.union(tn1.read.intersection(tn2.write));
                        size = rw.size();
                    }
                    tn1.edges.add(new CriticalSectionDataDependency(tn2, size, rw));
                    if (size <= 0) continue;
                    if (tn1.setNumber > 0) {
                        if (tn2.setNumber == 0) {
                            tn1.group.add(tn2);
                            continue;
                        }
                        if (tn2.setNumber <= 0 || tn1.setNumber == tn2.setNumber) continue;
                        tn1.group.mergeGroups(tn2.group);
                        continue;
                    }
                    if (tn1.setNumber != 0) continue;
                    if (tn2.setNumber == 0) {
                        CriticalSectionGroup newGroup = new CriticalSectionGroup(this.nextGroup);
                        newGroup.add(tn1);
                        newGroup.add(tn2);
                        this.groups.add(newGroup);
                        ++this.nextGroup;
                        continue;
                    }
                    if (tn2.setNumber <= 0) continue;
                    tn2.group.add(tn1);
                }
                if (tn1.setNumber != 0) continue;
                tn1.setNumber = -1;
            }
        }
    }

    public boolean mayHappenInParallel(CriticalSection tn1, CriticalSection tn2) {
        if (this.mhp == null) {
            if (this.optionLeaveOriginalLocks) {
                return true;
            }
            ReachableMethods rm = Scene.v().getReachableMethods();
            return rm.contains(tn1.method) && rm.contains(tn2.method);
        }
        return this.mhp.mayHappenInParallel(tn1.method, tn2.method);
    }
}

