/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Hierarchy;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.PAG;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.thread.mhp.Counter;
import soot.jimple.toolkits.thread.mhp.PegChain;
import soot.jimple.toolkits.thread.mhp.stmt.JPegStmt;
import soot.jimple.toolkits.thread.mhp.stmt.StartStmt;
import soot.tagkit.StringTag;
import soot.tagkit.Tag;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.util.Chain;

public class PegGraph
implements DirectedGraph {
    private List heads;
    private List tails;
    protected HashMap<Object, List> unitToSuccs;
    protected HashMap<Object, List> unitToPreds;
    private HashMap unitToPegMap;
    public HashMap<JPegStmt, List> startToThread;
    public HashMap startToAllocNodes;
    private HashMap<String, FlowSet> waitingNodes;
    private Map startToBeginNodes;
    private HashMap<String, Set<JPegStmt>> notifyAll;
    private Set methodsNeedingInlining;
    private boolean needInlining;
    private Set<List> synch;
    private Set<JPegStmt> specialJoin;
    private Body body;
    private Chain unitChain;
    private Chain mainPegChain;
    private FlowSet allNodes;
    private Map<String, FlowSet> monitor;
    private Set canNotBeCompacted;
    private Set threadAllocSites;
    private File logFile;
    private FileWriter fileWriter;
    private Set<Object> monitorObjs;
    private Set<Unit> exceHandlers;
    protected Map threadNo;
    protected Map threadNameToStart;
    protected Map<AllocNode, String> allocNodeToObj;
    protected Map<AllocNode, PegChain> allocNodeToThread;
    protected Map<JPegStmt, Chain> joinStmtToThread;
    Set allocNodes;
    List<List> inlineSites;
    Map<SootMethod, String> synchObj;
    Set multiRunAllocNodes;

    public PegGraph(CallGraph callGraph, Hierarchy hierarchy, PAG pag, Set<Object> methodsNeedingInlining, Set<AllocNode> allocNodes, List inlineSites, Map synchObj, Set<AllocNode> multiRunAllocNodes, Map allocNodeToObj, Body unitBody, SootMethod sm, boolean addExceptionEdges, boolean dontAddEdgeFromStmtBeforeAreaOfProtectionToCatchBlock) {
        this(callGraph, hierarchy, pag, methodsNeedingInlining, allocNodes, inlineSites, synchObj, multiRunAllocNodes, allocNodeToObj, unitBody, "main", sm, addExceptionEdges, dontAddEdgeFromStmtBeforeAreaOfProtectionToCatchBlock);
    }

    public PegGraph(CallGraph callGraph, Hierarchy hierarchy, PAG pag, Set methodsNeedingInlining, Set allocNodes, List<List> inlineSites, Map<SootMethod, String> synchObj, Set multiRunAllocNodes, Map<AllocNode, String> allocNodeToObj, Body unitBody, String threadName, SootMethod sm, boolean addExceEdge, boolean dontAddEdgeFromStmtBeforeAreaOfProtectionToCatchBlock) {
        this.allocNodeToObj = allocNodeToObj;
        this.multiRunAllocNodes = multiRunAllocNodes;
        this.synchObj = synchObj;
        this.inlineSites = inlineSites;
        this.allocNodes = allocNodes;
        this.methodsNeedingInlining = methodsNeedingInlining;
        this.logFile = new File("log.txt");
        try {
            this.fileWriter = new FileWriter(this.logFile);
        }
        catch (IOException io) {
            System.err.println("Errors occur during create FileWriter !");
        }
        this.body = unitBody;
        this.synch = new HashSet<List>();
        this.exceHandlers = new HashSet<Unit>();
        this.needInlining = true;
        this.monitorObjs = new HashSet<Object>();
        this.startToBeginNodes = new HashMap();
        this.unitChain = this.body.getUnits();
        int size = this.unitChain.size();
        this.unitToSuccs = new HashMap(size * 2 + 1, 0.7f);
        this.unitToPreds = new HashMap(size * 2 + 1, 0.7f);
        this.unitToPegMap = new HashMap(size * 2 + 1, 0.7f);
        this.startToThread = new HashMap(size * 2 + 1, 0.7f);
        this.startToAllocNodes = new HashMap(size * 2 + 1, 0.7f);
        this.waitingNodes = new HashMap(size * 2 + 1, 0.7f);
        this.joinStmtToThread = new HashMap<JPegStmt, Chain>();
        this.threadNo = new HashMap();
        this.threadNameToStart = new HashMap();
        this.allocNodeToObj = new HashMap<AllocNode, String>(size * 2 + 1, 0.7f);
        this.allocNodeToThread = new HashMap<AllocNode, PegChain>(size * 2 + 1, 0.7f);
        this.notifyAll = new HashMap(size * 2 + 1, 0.7f);
        methodsNeedingInlining = new HashSet();
        this.allNodes = new ArraySparseSet();
        this.canNotBeCompacted = new HashSet();
        this.threadAllocSites = new HashSet();
        this.specialJoin = new HashSet<JPegStmt>();
        CompleteUnitGraph mainUnitGraph = new CompleteUnitGraph(this.body);
        this.mainPegChain = new PegChain(callGraph, hierarchy, pag, this.threadAllocSites, methodsNeedingInlining, allocNodes, inlineSites, synchObj, multiRunAllocNodes, allocNodeToObj, this.body, sm, threadName, true, this);
        this.buildSuccessor(this.mainPegChain);
        this.buildPredecessor(this.mainPegChain);
        this.addMonitorStmt();
        this.addTag();
        this.buildHeadsAndTails();
        try {
            this.fileWriter.flush();
            this.fileWriter.close();
        }
        catch (IOException io) {
            System.err.println("Errors occur during close file  " + this.logFile.getName());
        }
    }

    protected Map getStartToBeginNodes() {
        return this.startToBeginNodes;
    }

    protected Map<JPegStmt, Chain> getJoinStmtToThread() {
        return this.joinStmtToThread;
    }

    protected Map getUnitToPegMap() {
        return this.unitToPegMap;
    }

    protected void addMonitorStmt() {
        if (this.synch.size() > 0) {
            for (List list : this.synch) {
                JPegStmt node = (JPegStmt)list.get(0);
                JPegStmt enter = (JPegStmt)list.get(1);
                JPegStmt exit = (JPegStmt)list.get(2);
                if (!this.mainPegChain.contains(node)) {
                    boolean find = false;
                    Set<Map.Entry<JPegStmt, List>> maps = this.startToThread.entrySet();
                    block1: for (Map.Entry<JPegStmt, List> entry : maps) {
                        JPegStmt startNode = entry.getKey();
                        for (Chain chain : entry.getValue()) {
                            if (!chain.contains(node)) continue;
                            find = true;
                            chain.add(enter);
                            chain.add(exit);
                            continue block1;
                        }
                    }
                    if (!find) {
                        throw new RuntimeException("fail to find stmt: " + node + " in chains!");
                    }
                } else {
                    this.mainPegChain.add(enter);
                    this.mainPegChain.add(exit);
                }
                this.allNodes.add(enter);
                this.allNodes.add(exit);
                this.insertBefore(node, enter);
                this.insertAfter(node, exit);
            }
        }
    }

    private void insertBefore(JPegStmt node, JPegStmt enter) {
        ArrayList predOfBefore = new ArrayList();
        predOfBefore.addAll(this.getPredsOf(node));
        this.unitToPreds.put(enter, predOfBefore);
        for (Object pred : this.getPredsOf(node)) {
            List succ = this.getSuccsOf(pred);
            succ.remove(node);
            succ.add(enter);
        }
        ArrayList<JPegStmt> succOfBefore = new ArrayList<JPegStmt>();
        succOfBefore.add(node);
        this.unitToSuccs.put(enter, succOfBefore);
        ArrayList<JPegStmt> predOfNode = new ArrayList<JPegStmt>();
        predOfNode.add(enter);
        this.unitToPreds.put(node, predOfNode);
    }

    private void insertAfter(JPegStmt node, JPegStmt after) {
        ArrayList succOfAfter = new ArrayList();
        succOfAfter.addAll(this.getSuccsOf(node));
        this.unitToSuccs.put(after, succOfAfter);
        for (Object succ : this.getSuccsOf(node)) {
            List pred = this.getPredsOf(succ);
            pred.remove(node);
            pred.add(after);
        }
        ArrayList<JPegStmt> succOfNode = new ArrayList<JPegStmt>();
        succOfNode.add(after);
        this.unitToSuccs.put(node, succOfNode);
        ArrayList<JPegStmt> predOfAfter = new ArrayList<JPegStmt>();
        predOfAfter.add(node);
        this.unitToPreds.put(after, predOfAfter);
    }

    private void buildSuccessor(Chain pegChain) {
        JPegStmt currentNode;
        HashMap unitToPeg = (HashMap)this.unitToPegMap.get(pegChain);
        Iterator pegIt = pegChain.iterator();
        JPegStmt jPegStmt = currentNode = pegIt.hasNext() ? (JPegStmt)pegIt.next() : null;
        if (currentNode != null) {
            ArrayList<JPegStmt> successors;
            JPegStmt nextNode;
            JPegStmt jPegStmt2 = nextNode = pegIt.hasNext() ? (JPegStmt)pegIt.next() : null;
            if (currentNode.getName().equals("begin")) {
                successors = new ArrayList<JPegStmt>();
                successors.add(nextNode);
                this.unitToSuccs.put(currentNode, successors);
                currentNode = nextNode;
            }
            while (currentNode != null) {
                if (this.unitToSuccs.containsKey(currentNode) && !currentNode.getName().equals("wait")) {
                    currentNode = pegIt.hasNext() ? (JPegStmt)pegIt.next() : null;
                    continue;
                }
                successors = new ArrayList();
                Unit unit = currentNode.getUnit();
                UnitGraph unitGraph = currentNode.getUnitGraph();
                List<Unit> unitSucc = unitGraph.getSuccsOf(unit);
                for (Unit un : unitSucc) {
                    JPegStmt pp;
                    if (unit instanceof ExitMonitorStmt && this.exceHandlers.contains(un) || !unitToPeg.containsKey(un) || (pp = (JPegStmt)unitToPeg.get(un)) == null || successors.contains(pp)) continue;
                    successors.add(pp);
                }
                if (currentNode.getName().equals("wait")) {
                    while (!currentNode.getName().equals("notified-entry")) {
                        currentNode = pegIt.hasNext() ? (JPegStmt)pegIt.next() : null;
                    }
                    this.unitToSuccs.put(currentNode, successors);
                } else {
                    this.unitToSuccs.put(currentNode, successors);
                }
                if (currentNode.getName().equals("start") && this.startToThread.containsKey(currentNode)) {
                    List runMethodChainList = this.startToThread.get(currentNode);
                    for (Chain subChain : runMethodChainList) {
                        if (subChain != null) {
                            this.buildSuccessor(subChain);
                            continue;
                        }
                        System.out.println("*********subgraph is null!!!");
                    }
                }
                currentNode = pegIt.hasNext() ? (JPegStmt)pegIt.next() : null;
            }
        }
    }

    private void buildPredecessor(Chain pegChain) {
        JPegStmt s22 = null;
        for (JPegStmt s22 : pegChain) {
            this.unitToPreds.put(s22, new ArrayList());
        }
        for (Object s3 : pegChain) {
            if (this.unitToSuccs.containsKey(s3)) {
                List succList = this.unitToSuccs.get(s3);
                for (JPegStmt successor : succList) {
                    List predList = this.unitToPreds.get(successor);
                    if (predList != null && !predList.contains(s3)) {
                        try {
                            predList.add(s3);
                        }
                        catch (NullPointerException e) {
                            System.out.println(s3 + "successor: " + successor);
                            throw e;
                        }
                        if (!(successor instanceof StartStmt)) continue;
                        List runMethodChainList = this.startToThread.get(successor);
                        if (runMethodChainList == null) {
                            throw new RuntimeException("null runmehtodchain: \n" + successor.getUnit());
                        }
                        for (Chain subChain : runMethodChainList) {
                            this.buildPredecessor(subChain);
                        }
                        continue;
                    }
                    System.err.println("predlist of " + s3 + " is null");
                }
                continue;
            }
            throw new RuntimeException("unitToSuccs does not contains key" + s3);
        }
    }

    private void buildHeadsAndTails() {
        ArrayList<JPegStmt> tailList = new ArrayList<JPegStmt>();
        ArrayList<JPegStmt> headList = new ArrayList<JPegStmt>();
        for (JPegStmt s2 : this.mainPegChain) {
            List succs = this.unitToSuccs.get(s2);
            if (succs.size() == 0) {
                tailList.add(s2);
            }
            if (!this.unitToPreds.containsKey(s2)) {
                throw new RuntimeException("unitToPreds does not contain key: " + s2);
            }
            List preds = this.unitToPreds.get(s2);
            if (preds.size() != 0) continue;
            headList.add(s2);
        }
        this.tails = tailList;
        this.heads = headList;
        for (Object e : this.heads) {
        }
        this.buildPredecessor(this.mainPegChain);
    }

    public boolean addPeg(PegGraph pg, Chain chain) {
        if (!pg.removeBeginNode()) {
            return false;
        }
        Iterator mainIt = pg.mainIterator();
        while (mainIt.hasNext()) {
            JPegStmt s2 = (JPegStmt)mainIt.next();
            this.mainPegChain.addLast(s2);
        }
        for (JPegStmt s3 : pg) {
            if (this.allNodes.contains(s3)) {
                throw new RuntimeException("error! allNodes contains: " + s3);
            }
            this.allNodes.add(s3);
        }
        this.unitToSuccs.putAll(pg.getUnitToSuccs());
        this.unitToPreds.putAll(pg.getUnitToPreds());
        return true;
    }

    private boolean removeBeginNode() {
        List heads = this.getHeads();
        if (heads.size() != 1) {
            return false;
        }
        JPegStmt head = (JPegStmt)heads.get(0);
        if (!head.getName().equals("begin")) {
            throw new RuntimeException("Error: the head is not begin node!");
        }
        heads.remove(0);
        for (JPegStmt succOfHead : this.getSuccsOf(head)) {
            this.unitToPreds.put(succOfHead, new ArrayList());
            heads.add(succOfHead);
        }
        if (!this.mainPegChain.remove(head)) {
            throw new RuntimeException("fail to remove begin node in from mainPegChain!");
        }
        if (!this.allNodes.contains(head)) {
            throw new RuntimeException("fail to find begin node in FlowSet allNodes!");
        }
        this.allNodes.remove(head);
        if (this.unitToSuccs.containsKey(head)) {
            this.unitToSuccs.remove(head);
        }
        return true;
    }

    protected void buildSuccsForInlining(JPegStmt stmt, Chain chain, PegGraph inlinee) {
        Tag tag = stmt.getTags().get(0);
        Iterator predIt = this.getPredsOf(stmt).iterator();
        Iterator headsIt = inlinee.getHeads().iterator();
        while (predIt.hasNext()) {
            JPegStmt pred = (JPegStmt)predIt.next();
            List succList = this.getSuccsOf(pred);
            int pos = succList.indexOf(stmt);
            succList.remove(pos);
            while (headsIt.hasNext()) {
                succList.add(headsIt.next());
            }
            this.unitToSuccs.put(pred, succList);
        }
        while (headsIt.hasNext()) {
            Object head = headsIt.next();
            ArrayList predsOfHeads = new ArrayList();
            predsOfHeads.addAll(this.getPredsOf(head));
            this.unitToPreds.put(head, predsOfHeads);
        }
        Iterator tailsIt = inlinee.getTails().iterator();
        while (tailsIt.hasNext()) {
            Iterator succIt = this.getSuccsOf(stmt).iterator();
            JPegStmt tail = (JPegStmt)tailsIt.next();
            ArrayList<JPegStmt> succList = null;
            succList = this.unitToSuccs.containsKey(tail) ? this.getSuccsOf(tail) : new ArrayList<JPegStmt>();
            while (succIt.hasNext()) {
                int pos;
                JPegStmt succ = (JPegStmt)succIt.next();
                succList.add(succ);
                List predListOfSucc = this.getPredsOf(succ);
                if (predListOfSucc == null) {
                    throw new RuntimeException("Error: predListOfSucc is null!");
                }
                if (predListOfSucc.size() != 0 && ((pos = predListOfSucc.indexOf(stmt)) > 0 || pos == 0)) {
                    predListOfSucc.remove(pos);
                }
                this.unitToPreds.put(succ, predListOfSucc);
            }
            this.unitToSuccs.put(tail, succList);
        }
        for (JPegStmt s2 : inlinee.getTails()) {
            if (!this.unitToSuccs.containsKey(s2)) continue;
            for (JPegStmt successor : this.unitToSuccs.get(s2)) {
                List predList = this.unitToPreds.get(successor);
                if (predList == null || predList.contains(s2)) continue;
                try {
                    predList.add(s2);
                }
                catch (NullPointerException e) {
                    System.out.println(s2 + "successor: " + successor);
                    throw e;
                }
            }
        }
        if (!this.allNodes.contains(stmt)) {
            throw new RuntimeException("fail to find begin node in  allNodes!");
        }
        this.allNodes.remove(stmt);
        if (!chain.contains(stmt)) {
            throw new RuntimeException("Error! Chain does not contains stmt (extending point)!");
        }
        if (!chain.remove(stmt)) {
            throw new RuntimeException("fail to remove invoke stmt in from Chain!");
        }
        if (this.unitToSuccs.containsKey(stmt)) {
            this.unitToSuccs.remove(stmt);
        }
        if (this.unitToPreds.containsKey(stmt)) {
            this.unitToPreds.remove(stmt);
        }
    }

    protected void buildMaps(PegGraph pg) {
        this.exceHandlers.addAll(pg.getExceHandlers());
        this.startToThread.putAll(pg.getStartToThread());
        this.startToAllocNodes.putAll(pg.getStartToAllocNodes());
        this.startToBeginNodes.putAll(pg.getStartToBeginNodes());
        this.waitingNodes.putAll(pg.getWaitingNodes());
        this.notifyAll.putAll(pg.getNotifyAll());
        this.canNotBeCompacted.addAll(pg.getCanNotBeCompacted());
        this.synch.addAll(pg.getSynch());
        this.threadNameToStart.putAll(pg.getThreadNameToStart());
        this.specialJoin.addAll(pg.getSpecialJoin());
        this.joinStmtToThread.putAll(pg.getJoinStmtToThread());
        this.threadAllocSites.addAll(pg.getThreadAllocSites());
        this.allocNodeToThread.putAll(pg.getAllocNodeToThread());
    }

    protected void buildPreds() {
        this.buildPredecessor(this.mainPegChain);
        Set<Map.Entry<JPegStmt, List>> maps = this.getStartToThread().entrySet();
        for (Map.Entry<JPegStmt, List> entry : maps) {
            List runMethodChainList = entry.getValue();
            for (Chain chain : runMethodChainList) {
                this.buildPredecessor(chain);
            }
        }
    }

    public void computeMonitorObjs() {
        Set<Map.Entry<String, FlowSet>> maps = this.monitor.entrySet();
        for (Map.Entry<String, FlowSet> entry : maps) {
            FlowSet fs = entry.getValue();
            for (Object obj : fs) {
                if (this.monitorObjs.contains(obj)) continue;
                this.monitorObjs.add(obj);
            }
        }
    }

    protected boolean getNeedInlining() {
        return this.needInlining;
    }

    protected FlowSet getAllNodes() {
        return this.allNodes;
    }

    protected HashMap getUnitToSuccs() {
        return this.unitToSuccs;
    }

    protected HashMap getUnitToPreds() {
        return this.unitToPreds;
    }

    public Body getBody() {
        return this.body;
    }

    public List getHeads() {
        return this.heads;
    }

    public List getTails() {
        return this.tails;
    }

    public List getPredsOf(Object s2) {
        if (!this.unitToPreds.containsKey(s2)) {
            throw new RuntimeException("Invalid stmt" + s2);
        }
        return this.unitToPreds.get(s2);
    }

    public List getSuccsOf(Object s2) {
        if (!this.unitToSuccs.containsKey(s2)) {
            return new ArrayList();
        }
        return this.unitToSuccs.get(s2);
    }

    public Set getCanNotBeCompacted() {
        return this.canNotBeCompacted;
    }

    @Override
    public int size() {
        return this.allNodes.size();
    }

    public Iterator mainIterator() {
        return this.mainPegChain.iterator();
    }

    @Override
    public Iterator iterator() {
        return this.allNodes.iterator();
    }

    public String toString() {
        Iterator it = this.iterator();
        StringBuffer buf = new StringBuffer();
        while (it.hasNext()) {
            JPegStmt u = (JPegStmt)it.next();
            buf.append("u is: " + u + "\n");
            ArrayList l = new ArrayList();
            l.addAll(this.getPredsOf(u));
            buf.append("preds: " + l + "\n");
            l = new ArrayList();
            l.addAll(this.getSuccsOf(u));
            buf.append("succs: " + l + "\n");
        }
        return buf.toString();
    }

    protected Set<Unit> getExceHandlers() {
        return this.exceHandlers;
    }

    protected void setMonitor(Map<String, FlowSet> m4) {
        this.monitor = m4;
    }

    public Map<String, FlowSet> getMonitor() {
        return this.monitor;
    }

    public Set<Object> getMonitorObjs() {
        return this.monitorObjs;
    }

    protected Set getThreadAllocSites() {
        return this.threadAllocSites;
    }

    protected Set<JPegStmt> getSpecialJoin() {
        return this.specialJoin;
    }

    public HashSet<List> getSynch() {
        return (HashSet)this.synch;
    }

    public Map<JPegStmt, List> getStartToThread() {
        return this.startToThread;
    }

    public Map getStartToAllocNodes() {
        return this.startToAllocNodes;
    }

    protected Map<String, FlowSet> getWaitingNodes() {
        return this.waitingNodes;
    }

    public Map<String, Set<JPegStmt>> getNotifyAll() {
        return this.notifyAll;
    }

    protected Map<AllocNode, String> getAllocNodeToObj() {
        return this.allocNodeToObj;
    }

    public Map<AllocNode, PegChain> getAllocNodeToThread() {
        return this.allocNodeToThread;
    }

    protected Map getThreadNameToStart() {
        return this.threadNameToStart;
    }

    public PegChain getMainPegChain() {
        return (PegChain)this.mainPegChain;
    }

    public Set getMethodsNeedingInlining() {
        return this.methodsNeedingInlining;
    }

    protected void testIterator() {
        System.out.println("********begin test iterator*******");
        Iterator testIt = this.iterator();
        while (testIt.hasNext()) {
            System.out.println(testIt.next());
        }
        System.out.println("********end test iterator*******");
        System.out.println("=======size is: " + this.size());
    }

    public void testWaitingNodes() {
        System.out.println("------waiting---begin");
        Set<Map.Entry<String, FlowSet>> maps = this.waitingNodes.entrySet();
        for (Map.Entry<String, FlowSet> entry : maps) {
            System.out.println("---key=  " + entry.getKey());
            FlowSet fs = entry.getValue();
            if (fs.size() <= 0) continue;
            System.out.println("**waiting nodes set:");
            for (JPegStmt unit : fs) {
                System.out.println(unit.toString());
            }
        }
        System.out.println("------------waitingnodes---ends--------");
    }

    protected void testStartToThread() {
        System.out.println("=====test startToThread ");
        Set<Map.Entry<JPegStmt, List>> maps = this.startToThread.entrySet();
        for (Map.Entry<JPegStmt, List> entry : maps) {
            JPegStmt key = entry.getKey();
            Tag tag = key.getTags().get(0);
            System.out.println("---key=  " + tag + " " + key);
        }
        System.out.println("=========startToThread--ends--------");
    }

    protected void testUnitToPeg(HashMap unitToPeg) {
        System.out.println("=====test unitToPeg ");
        Set maps = unitToPeg.entrySet();
        for (Map.Entry entry : maps) {
            System.out.println("---key=  " + entry.getKey());
            JPegStmt s2 = (JPegStmt)entry.getValue();
            System.out.println("--value= " + s2);
        }
        System.out.println("=========unitToPeg--ends--------");
    }

    protected void testUnitToSucc() {
        System.out.println("=====test unitToSucc ");
        Set<Map.Entry<Object, List>> maps = this.unitToSuccs.entrySet();
        for (Map.Entry<Object, List> entry : maps) {
            JPegStmt key = (JPegStmt)entry.getKey();
            Tag tag = key.getTags().get(0);
            System.out.println("---key=  " + tag + " " + key);
            List list = entry.getValue();
            if (list.size() <= 0) continue;
            System.out.println("**succ set: size: " + list.size());
            for (JPegStmt stmt : list) {
                Tag tag1 = stmt.getTags().get(0);
                System.out.println(tag1 + " " + stmt);
            }
        }
        System.out.println("=========unitToSucc--ends--------");
    }

    protected void testUnitToPred() {
        System.out.println("=====test unitToPred ");
        Set<Map.Entry<Object, List>> maps = this.unitToPreds.entrySet();
        for (Map.Entry<Object, List> entry : maps) {
            JPegStmt key = (JPegStmt)entry.getKey();
            Tag tag = key.getTags().get(0);
            System.out.println("---key=  " + tag + " " + key);
            List list = entry.getValue();
            System.out.println("**pred set: size: " + list.size());
            for (JPegStmt stmt : list) {
                Tag tag1 = stmt.getTags().get(0);
                System.out.println(tag1 + " " + stmt);
            }
        }
        System.out.println("=========unitToPred--ends--------");
    }

    protected void addTag() {
        for (JPegStmt stmt : this) {
            int count = Counter.getTagNo();
            StringTag t2 = new StringTag(Integer.toString(count));
            stmt.addTag(t2);
        }
    }

    protected void testSynch() {
        Iterator<List> it = this.synch.iterator();
        System.out.println("========test synch======");
        while (it.hasNext()) {
            System.out.println(it.next());
        }
        System.out.println("========end test synch======");
    }

    protected void testThreadNameToStart() {
        System.out.println("=====test ThreadNameToStart");
        Set maps = this.threadNameToStart.entrySet();
        for (Map.Entry entry : maps) {
            Object key = entry.getKey();
            System.out.println("---key=  " + key);
            JPegStmt stmt = (JPegStmt)entry.getValue();
            Tag tag1 = stmt.getTags().get(0);
            System.out.println("value: " + tag1 + " " + stmt);
        }
        System.out.println("=========ThreadNameToStart--ends--------");
    }

    protected void testJoinStmtToThread() {
        System.out.println("=====test JoinStmtToThread");
        Set maps = this.threadNameToStart.entrySet();
        for (Map.Entry entry : maps) {
            Object key = entry.getKey();
            System.out.println("---key=  " + key);
            System.out.println("value: " + entry.getValue());
        }
        System.out.println("=========JoinStmtToThread--ends--------");
    }

    protected void testPegChain(Chain chain) {
        System.out.println("******** chain********");
        for (JPegStmt stmt : chain) {
            System.out.println(stmt.toString());
        }
    }

    protected void computeEdgeAndThreadNo() {
        Iterator it = this.iterator();
        int numberOfEdge = 0;
        while (it.hasNext()) {
            List succList = this.getSuccsOf(it.next());
            numberOfEdge += succList.size();
        }
        System.err.println("**number of edges: " + (numberOfEdge += this.startToThread.size()));
        System.err.println("**number of threads: " + (this.startToThread.size() + 1));
    }

    protected void testList(List list) {
        Iterator listIt = list.iterator();
        while (listIt.hasNext()) {
            System.out.println(listIt.next());
        }
    }

    protected void testSet(Set set, String name) {
        System.out.println("$test set " + name);
        for (Object s2 : set) {
            System.out.println(s2);
        }
    }

    public void testMonitor() {
        System.out.println("=====test monitor size: " + this.monitor.size());
        Set<Map.Entry<String, FlowSet>> maps = this.monitor.entrySet();
        for (Map.Entry<String, FlowSet> entry : maps) {
            String key = entry.getKey();
            System.out.println("---key=  " + key);
            FlowSet list = entry.getValue();
            if (list.size() <= 0) continue;
            System.out.println("**set:  " + list.size());
            for (Object obj : list) {
                if (obj instanceof JPegStmt) {
                    JPegStmt stmt = (JPegStmt)obj;
                    Tag tag1 = stmt.getTags().get(0);
                    System.out.println(tag1 + " " + stmt);
                    continue;
                }
                System.out.println("---list---");
                for (Object oo : (List)obj) {
                    if (oo instanceof JPegStmt) {
                        JPegStmt unit = (JPegStmt)oo;
                        Tag tag = unit.getTags().get(0);
                        System.out.println(tag + " " + unit);
                        continue;
                    }
                    System.out.println(oo);
                }
                System.out.println("---list--end-");
            }
        }
        System.out.println("=========monitor--ends--------");
    }
}

