/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Hierarchy;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.MonitorStmt;
import soot.jimple.NewExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.internal.JIdentityStmt;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.thread.mhp.Counter;
import soot.jimple.toolkits.thread.mhp.PegGraph;
import soot.jimple.toolkits.thread.mhp.TargetMethodsFinder;
import soot.jimple.toolkits.thread.mhp.stmt.BeginStmt;
import soot.jimple.toolkits.thread.mhp.stmt.JPegStmt;
import soot.jimple.toolkits.thread.mhp.stmt.JoinStmt;
import soot.jimple.toolkits.thread.mhp.stmt.MonitorEntryStmt;
import soot.jimple.toolkits.thread.mhp.stmt.MonitorExitStmt;
import soot.jimple.toolkits.thread.mhp.stmt.NotifiedEntryStmt;
import soot.jimple.toolkits.thread.mhp.stmt.NotifyAllStmt;
import soot.jimple.toolkits.thread.mhp.stmt.NotifyStmt;
import soot.jimple.toolkits.thread.mhp.stmt.OtherStmt;
import soot.jimple.toolkits.thread.mhp.stmt.StartStmt;
import soot.jimple.toolkits.thread.mhp.stmt.WaitStmt;
import soot.jimple.toolkits.thread.mhp.stmt.WaitingStmt;
import soot.tagkit.StringTag;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.util.Chain;
import soot.util.HashChain;

public class PegChain
extends HashChain {
    CallGraph callGraph;
    private final List heads = new ArrayList();
    private final List tails = new ArrayList();
    private final FlowSet pegNodes = new ArraySparseSet();
    private final Map<Unit, JPegStmt> unitToPeg = new HashMap<Unit, JPegStmt>();
    private final Map<String, FlowSet> waitingNodes;
    private final PegGraph pg;
    private final Set<List<Object>> joinNeedReconsidered = new HashSet<List<Object>>();
    public Body body;
    Hierarchy hierarchy;
    PAG pag;
    Set threadAllocSites;
    Set methodsNeedingInlining;
    Set allocNodes;
    List<List> inlineSites;
    Map<SootMethod, String> synchObj;
    Set multiRunAllocNodes;
    Map<AllocNode, String> allocNodeToObj;

    PegChain(CallGraph callGraph, Hierarchy hierarchy, PAG pag, Set threadAllocSites, Set methodsNeedingInlining, Set allocNodes, List<List> inlineSites, Map<SootMethod, String> synchObj, Set multiRunAllocNodes, Map<AllocNode, String> allocNodeToObj, Body unitBody, SootMethod sm, String threadName, boolean addBeginNode, PegGraph pegGraph) {
        this.allocNodeToObj = allocNodeToObj;
        this.multiRunAllocNodes = multiRunAllocNodes;
        this.synchObj = synchObj;
        this.inlineSites = inlineSites;
        this.allocNodes = allocNodes;
        this.methodsNeedingInlining = methodsNeedingInlining;
        this.threadAllocSites = threadAllocSites;
        this.hierarchy = hierarchy;
        this.pag = pag;
        this.callGraph = callGraph;
        this.body = unitBody;
        this.pg = pegGraph;
        this.waitingNodes = pegGraph.getWaitingNodes();
        Iterator<Trap> trapIt = unitBody.getTraps().iterator();
        Set<Unit> exceHandlers = this.pg.getExceHandlers();
        while (trapIt.hasNext()) {
            Trap trap = trapIt.next();
            Unit handlerUnit = trap.getHandlerUnit();
            exceHandlers.add(handlerUnit);
        }
        CompleteUnitGraph graph = new CompleteUnitGraph(unitBody);
        Iterator<Unit> unitIt = graph.iterator();
        if (addBeginNode) {
            BeginStmt beginStmt = new BeginStmt("*", threadName, graph, sm);
            this.pg.getCanNotBeCompacted().add(beginStmt);
            this.addNode(beginStmt);
            this.heads.add(beginStmt);
        }
        for (Unit head : graph.getHeads()) {
            HashSet<Unit> gray = new HashSet<Unit>();
            LinkedList<Unit> queue = new LinkedList<Unit>();
            queue.add(head);
            this.visit((Unit)queue.getFirst(), graph, sm, threadName, addBeginNode);
            while (queue.size() > 0) {
                Unit root = (Unit)queue.getFirst();
                for (Unit succ : graph.getSuccsOf(root)) {
                    if (gray.contains(succ)) continue;
                    gray.add(succ);
                    queue.addLast(succ);
                    this.visit(succ, graph, sm, threadName, addBeginNode);
                }
                queue.remove(root);
            }
        }
        this.postHandleJoinStmt();
        this.pg.getUnitToPegMap().put(this, this.unitToPeg);
    }

    private void visit(Unit unit, UnitGraph graph, SootMethod sm, String threadName, boolean addBeginNode) {
        Type type;
        Value value;
        if (unit instanceof MonitorStmt && (value = ((MonitorStmt)unit).getOp()) instanceof Local && (type = ((Local)value).getType()) instanceof RefType) {
            SootClass sc = ((RefType)type).getSootClass();
            if (unit instanceof EnterMonitorStmt) {
                String objName = this.makeObjName(value, type, unit);
                MonitorEntryStmt pegStmt = new MonitorEntryStmt(objName, threadName, unit, graph, sm);
                this.addAndPutNonCompacted(unit, pegStmt);
                return;
            }
            if (unit instanceof ExitMonitorStmt) {
                String objName = this.makeObjName(value, type, unit);
                MonitorExitStmt pegStmt = new MonitorExitStmt(objName, threadName, unit, graph, sm);
                this.addAndPutNonCompacted(unit, pegStmt);
                return;
            }
        }
        if (((Stmt)unit).containsInvokeExpr()) {
            JPegStmt pegStmt;
            JPegStmt pegStmt2;
            InvokeExpr invokeExpr = ((Stmt)unit).getInvokeExpr();
            SootMethod method = invokeExpr.getMethod();
            String name = method.getName();
            Value value2 = null;
            Type type2 = null;
            List<Type> paras = method.getParameterTypes();
            String objName = null;
            if (invokeExpr instanceof InstanceInvokeExpr) {
                value2 = ((InstanceInvokeExpr)invokeExpr).getBase();
                if (value2 instanceof Local && (type2 = ((Local)value2).getType()) instanceof RefType) {
                    SootClass sc = ((RefType)type2).getSootClass();
                    objName = sc.getName();
                }
            } else if (!(invokeExpr instanceof StaticInvokeExpr)) {
                throw new RuntimeException("Error: new type of invokeExpre: " + invokeExpr);
            }
            boolean find = false;
            if (method.getName().equals("start")) {
                List<SootClass> superClasses = this.hierarchy.getSuperclassesOfIncluding(method.getDeclaringClass());
                Iterator<SootClass> it = superClasses.iterator();
                while (it.hasNext()) {
                    String className = it.next().getName();
                    if (!className.equals("java.lang.Thread")) continue;
                    find = true;
                    break;
                }
            }
            if (method.getName().equals("run") && method.getDeclaringClass().getName().equals("java.lang.Runnable")) {
                find = true;
            }
            if (name.equals("wait") && (paras.size() == 0 || paras.size() == 1 && paras.get(0) instanceof LongType || paras.size() == 2 && paras.get(0) instanceof LongType && paras.get(1) instanceof IntType)) {
                objName = this.makeObjName(value2, type2, unit);
                this.transformWaitNode(objName, name, threadName, unit, graph, sm);
            } else if ((name.equals("start") || name.equals("run")) && find) {
                List<AllocNode> mayAlias = null;
                PointsToSetInternal pts = (PointsToSetInternal)this.pag.reachingObjects((Local)value2);
                mayAlias = this.findMayAlias(pts, unit);
                pegStmt2 = new StartStmt(value2.toString(), threadName, unit, graph, sm);
                if (this.pg.getStartToThread().containsKey(pegStmt2)) {
                    throw new RuntimeException("map startToThread contain duplicated start() method call");
                }
                this.pg.getCanNotBeCompacted().add(pegStmt2);
                this.addAndPut(unit, pegStmt2);
                ArrayList<PegChain> runMethodChainList = new ArrayList<PegChain>();
                ArrayList<AllocNode> threadAllocNodesList = new ArrayList<AllocNode>();
                if (mayAlias.size() < 1) {
                    throw new RuntimeException("The may alias set of " + unit + "is empty!");
                }
                for (AllocNode allocNode : mayAlias) {
                    RefType refType = ((NewExpr)allocNode.getNewExpr()).getBaseType();
                    SootClass maySootClass = refType.getSootClass();
                    SootMethod meth = this.hierarchy.resolveConcreteDispatch(maySootClass, method.getDeclaringClass().getMethodByName("run"));
                    Body mBody = meth.getActiveBody();
                    int threadNo = Counter.getThreadNo();
                    String callerName = "thread" + threadNo;
                    this.pg.getThreadNameToStart().put(callerName, pegStmt2);
                    PegChain newChain = new PegChain(this.callGraph, this.hierarchy, this.pag, this.threadAllocSites, this.methodsNeedingInlining, this.allocNodes, this.inlineSites, this.synchObj, this.multiRunAllocNodes, this.allocNodeToObj, mBody, sm, callerName, true, this.pg);
                    this.pg.getAllocNodeToThread().put(allocNode, newChain);
                    runMethodChainList.add(newChain);
                    threadAllocNodesList.add(allocNode);
                }
                this.pg.getStartToThread().put(pegStmt2, runMethodChainList);
                this.pg.getStartToAllocNodes().put(pegStmt2, threadAllocNodesList);
            } else if (name.equals("join") && method.getDeclaringClass().getName().equals("java.lang.Thread")) {
                PointsToSetInternal pts = (PointsToSetInternal)this.pag.reachingObjects((Local)value2);
                List<AllocNode> mayAlias = this.findMayAlias(pts, unit);
                if (mayAlias.size() != 1) {
                    if (mayAlias.size() < 1) {
                        throw new RuntimeException("==threadAllocaSits==\n" + this.threadAllocSites.toString());
                    }
                    pegStmt2 = new JoinStmt(value2.toString(), threadName, unit, graph, sm);
                    this.addAndPutNonCompacted(unit, pegStmt2);
                    this.pg.getSpecialJoin().add(pegStmt2);
                } else {
                    for (AllocNode allocNode : mayAlias) {
                        JoinStmt pegStmt3 = new JoinStmt(value2.toString(), threadName, unit, graph, sm);
                        if (!this.pg.getAllocNodeToThread().containsKey(allocNode)) {
                            ArrayList<Object> list = new ArrayList<Object>();
                            list.add(pegStmt3);
                            list.add(allocNode);
                            list.add(unit);
                            this.joinNeedReconsidered.add(list);
                            continue;
                        }
                        Chain thread = this.pg.getAllocNodeToThread().get(allocNode);
                        this.addAndPutNonCompacted(unit, pegStmt3);
                        this.pg.getJoinStmtToThread().put(pegStmt3, thread);
                    }
                }
            } else if (name.equals("notifyAll") && paras.size() == 0) {
                Set<Object> notifyAllSet;
                objName = this.makeObjName(value2, type2, unit);
                pegStmt = new NotifyAllStmt(objName, threadName, unit, graph, sm);
                this.addAndPutNonCompacted(unit, pegStmt);
                if (this.pg.getNotifyAll().containsKey(objName)) {
                    notifyAllSet = this.pg.getNotifyAll().get(objName);
                    notifyAllSet.add(pegStmt);
                    this.pg.getNotifyAll().put(objName, notifyAllSet);
                } else {
                    notifyAllSet = new HashSet<OtherStmt>();
                    notifyAllSet.add(pegStmt);
                    this.pg.getNotifyAll().put(objName, notifyAllSet);
                }
            } else if (name.equals("notify") && paras.size() == 0 && method.getDeclaringClass().getName().equals("java.lang.Thread")) {
                objName = this.makeObjName(value2, type2, unit);
                pegStmt = new NotifyStmt(objName, threadName, unit, graph, sm);
                this.addAndPutNonCompacted(unit, pegStmt);
            } else if (method.isConcrete() && !method.getDeclaringClass().isLibraryClass()) {
                List<Object> targetList = new LinkedList();
                SootMethod targetMethod = null;
                if (invokeExpr instanceof StaticInvokeExpr) {
                    targetMethod = method;
                } else {
                    TargetMethodsFinder tmd = new TargetMethodsFinder();
                    targetList = tmd.find(unit, this.callGraph, true, false);
                    if (targetList.size() > 1) {
                        System.out.println("target: " + targetList);
                        System.out.println("unit is: " + unit);
                        System.err.println("exit because target is bigger than 1.");
                        System.exit(1);
                    } else if (targetList.size() < 1) {
                        System.err.println("targetList size <1");
                    } else {
                        targetMethod = (SootMethod)targetList.get(0);
                    }
                }
                if (this.methodsNeedingInlining == null) {
                    System.err.println("methodsNeedingInlining is null at " + unit);
                } else if (targetMethod == null) {
                    System.err.println("targetMethod is null at " + unit);
                } else if (this.methodsNeedingInlining.contains(targetMethod)) {
                    this.inlineMethod(targetMethod, objName, name, threadName, unit, graph, sm);
                } else {
                    pegStmt2 = new OtherStmt(objName, name, threadName, unit, graph, sm);
                    this.addAndPut(unit, pegStmt2);
                }
            } else {
                pegStmt = new OtherStmt(objName, name, threadName, unit, graph, sm);
                this.addAndPut(unit, pegStmt);
            }
        } else {
            this.newAndAddElement(unit, graph, threadName, sm);
        }
    }

    private void transformWaitNode(String objName, String name, String threadName, Unit unit, UnitGraph graph, SootMethod sm) {
        FlowSet<WaitingStmt> waitingNodesSet;
        WaitStmt pegStmt = new WaitStmt(objName, threadName, unit, graph, sm);
        this.addAndPutNonCompacted(unit, pegStmt);
        WaitingStmt pegWaiting = new WaitingStmt(objName, threadName, sm);
        this.pg.getCanNotBeCompacted().add(pegWaiting);
        this.addNode(pegWaiting);
        if (this.waitingNodes.containsKey(objName)) {
            waitingNodesSet = this.waitingNodes.get(objName);
            if (!waitingNodesSet.contains(pegWaiting)) {
                waitingNodesSet.add(pegWaiting);
                this.waitingNodes.put(pegWaiting.getObject(), waitingNodesSet);
            }
        } else {
            waitingNodesSet = new ArraySparseSet<WaitingStmt>();
            waitingNodesSet.add(pegWaiting);
            this.waitingNodes.put(pegWaiting.getObject(), waitingNodesSet);
        }
        ArrayList<WaitingStmt> successors = new ArrayList<WaitingStmt>();
        successors.add(pegWaiting);
        this.pg.getUnitToSuccs().put(pegStmt, successors);
        NotifiedEntryStmt pegNotify = new NotifiedEntryStmt(objName, threadName, sm);
        this.pg.getCanNotBeCompacted().add(pegNotify);
        this.addNode(pegNotify);
        ArrayList<NotifiedEntryStmt> successors2 = new ArrayList<NotifiedEntryStmt>();
        successors2.add(pegNotify);
        this.pg.getUnitToSuccs().put(pegWaiting, successors2);
    }

    private List<AllocNode> findMayAlias(PointsToSetInternal pts, Unit unit) {
        ArrayList<AllocNode> list = new ArrayList<AllocNode>();
        Iterator<AllocNode> it = this.makePtsIterator(pts);
        while (it.hasNext()) {
            AllocNode obj = it.next();
            list.add(obj);
        }
        return list;
    }

    private void inlineMethod(SootMethod targetMethod, String objName, String name, String threadName, Unit unit, UnitGraph graph, SootMethod sm) {
        Body unitBody = targetMethod.getActiveBody();
        OtherStmt pegStmt = new OtherStmt(objName, name, threadName, unit, graph, sm);
        if (targetMethod.isSynchronized()) {
            String synchObj = this.findSynchObj(targetMethod);
            MonitorEntryStmt enter = new MonitorEntryStmt(synchObj, threadName, graph, sm);
            MonitorExitStmt exit = new MonitorExitStmt(synchObj, threadName, graph, sm);
            this.pg.getCanNotBeCompacted().add(enter);
            this.pg.getCanNotBeCompacted().add(exit);
            ArrayList<JPegStmt> list = new ArrayList<JPegStmt>();
            list.add(pegStmt);
            list.add(enter);
            list.add(exit);
            this.pg.getSynch().add(list);
        }
        this.addAndPut(unit, pegStmt);
        PegGraph pG = new PegGraph(this.callGraph, this.hierarchy, this.pag, this.methodsNeedingInlining, this.allocNodes, this.inlineSites, this.synchObj, this.multiRunAllocNodes, this.allocNodeToObj, unitBody, threadName, targetMethod, true, false);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(pegStmt);
        list.add(this);
        list.add(this.pg);
        list.add(pG);
        this.inlineSites.add(list);
    }

    private String findSynchObj(SootMethod targetMethod) {
        if (this.synchObj.containsKey(targetMethod)) {
            return this.synchObj.get(targetMethod);
        }
        String objName = null;
        if (targetMethod.isStatic()) {
            objName = targetMethod.getDeclaringClass().getName();
        } else {
            for (Object obj : targetMethod.getActiveBody().getUnits()) {
                Type type;
                Value thisRef;
                if (!(obj instanceof JIdentityStmt) || !((thisRef = ((JIdentityStmt)obj).getLeftOp()) instanceof Local) || !((type = ((Local)thisRef).getType()) instanceof RefType)) continue;
                objName = this.makeObjName(thisRef, type, (Unit)obj);
                this.synchObj.put(targetMethod, objName);
                break;
            }
        }
        return objName;
    }

    private void addNode(JPegStmt stmt) {
        this.addLast(stmt);
        this.pegNodes.add(stmt);
        this.pg.getAllNodes().add(stmt);
    }

    private void addAndPut(Unit unit, JPegStmt stmt) {
        this.unitToPeg.put(unit, stmt);
        this.addNode(stmt);
    }

    private void addAndPutNonCompacted(Unit unit, JPegStmt stmt) {
        this.pg.getCanNotBeCompacted().add(stmt);
        this.addAndPut(unit, stmt);
    }

    private void newAndAddElement(Unit unit, UnitGraph graph, String threadName, SootMethod sm) {
        OtherStmt pegStmt = new OtherStmt("*", unit.toString(), threadName, unit, graph, sm);
        this.addAndPut(unit, pegStmt);
    }

    public List getHeads() {
        return this.heads;
    }

    public List getTails() {
        return this.tails;
    }

    protected void addTag() {
        for (JPegStmt stmt : this) {
            int count = Counter.getTagNo();
            StringTag t2 = new StringTag(Integer.toString(count));
            stmt.addTag(t2);
        }
    }

    private Iterator<AllocNode> makePtsIterator(PointsToSetInternal pts) {
        final HashSet ret = new HashSet();
        pts.forall(new P2SetVisitor(){

            @Override
            public void visit(Node n) {
                ret.add((AllocNode)n);
            }
        });
        return ret.iterator();
    }

    private void postHandleJoinStmt() {
        for (List<Object> list : this.joinNeedReconsidered) {
            JPegStmt pegStmt = (JPegStmt)list.get(0);
            AllocNode allocNode = (AllocNode)list.get(1);
            Unit unit = (Unit)list.get(2);
            if (!this.pg.getAllocNodeToThread().containsKey(allocNode)) {
                throw new RuntimeException("allocNodeToThread does not contains key: " + allocNode);
            }
            Chain thread = this.pg.getAllocNodeToThread().get(allocNode);
            this.addAndPutNonCompacted(unit, pegStmt);
            this.pg.getJoinStmtToThread().put(pegStmt, thread);
        }
    }

    private String makeObjName(Value value, Type type, Unit unit) {
        PointsToSetInternal pts = (PointsToSetInternal)this.pag.reachingObjects((Local)value);
        List<AllocNode> mayAlias = this.findMayAlias(pts, unit);
        String objName = null;
        if (this.allocNodeToObj == null) {
            throw new RuntimeException("allocNodeToObj is null!");
        }
        if (mayAlias.size() == 1) {
            AllocNode an = mayAlias.get(0);
            if (this.allocNodeToObj.containsKey(an)) {
                objName = this.allocNodeToObj.get(an);
            } else {
                objName = "obj" + Counter.getObjNo();
                this.allocNodeToObj.put(an, objName);
            }
        } else {
            AllocNode an = mayAlias.get(0);
            if (this.allocNodeToObj.containsKey(an)) {
                objName = "MULTI" + this.allocNodeToObj.get(an);
            } else {
                objName = "MULTIobj" + Counter.getObjNo();
                this.allocNodeToObj.put(an, objName);
            }
        }
        if (objName == null) {
            throw new RuntimeException("Can not find target object for " + unit);
        }
        return objName;
    }

    protected Map<String, FlowSet> getWaitingNodes() {
        return this.waitingNodes;
    }

    protected void testChain() {
        System.out.println("******** chain********");
        for (JPegStmt stmt : this) {
            System.out.println(stmt.toString());
        }
    }
}

