/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import soot.toolkits.graph.DirectedGraph;

public class LoopBodyFinder {
    private final Stack<Object> stack = new Stack();
    private final Set<Set<Object>> loops = new HashSet<Set<Object>>();

    LoopBodyFinder(Map<Object, Object> backEdges, DirectedGraph g2) {
        this.findLoopBody(backEdges, g2);
    }

    private void findLoopBody(Map<Object, Object> backEdges, DirectedGraph g2) {
        Set<Map.Entry<Object, Object>> maps = backEdges.entrySet();
        for (Map.Entry<Object, Object> entry : maps) {
            Object tail = entry.getKey();
            Object head = entry.getValue();
            Set<Object> loopBody = this.finder(tail, head, g2);
            this.loops.add(loopBody);
        }
    }

    private Set<Object> finder(Object tail, Object head, DirectedGraph g2) {
        HashSet<Object> loop = new HashSet<Object>();
        this.stack.empty();
        loop.add(head);
        this.insert(tail, loop);
        while (!this.stack.empty()) {
            Object p = this.stack.pop();
            for (Object pred : g2.getPredsOf(p)) {
                this.insert(pred, loop);
            }
        }
        return loop;
    }

    private void insert(Object m4, Set<Object> loop) {
        if (!loop.contains(m4)) {
            loop.add(m4);
            this.stack.push(m4);
        }
    }

    public Set<Set<Object>> getLoopBody() {
        return this.loops;
    }
}

