/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar.pre;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.EquivalentValue;
import soot.G;
import soot.Local;
import soot.Scene;
import soot.SideEffectTester;
import soot.Singletons;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.NaiveSideEffectTester;
import soot.jimple.toolkits.graph.CriticalEdgeRemover;
import soot.jimple.toolkits.pointer.PASideEffectTester;
import soot.jimple.toolkits.scalar.LocalCreation;
import soot.jimple.toolkits.scalar.pre.DownSafetyAnalysis;
import soot.jimple.toolkits.scalar.pre.EarliestnessComputation;
import soot.jimple.toolkits.scalar.pre.SootFilter;
import soot.jimple.toolkits.scalar.pre.UpSafetyAnalysis;
import soot.options.BCMOptions;
import soot.options.Options;
import soot.toolkits.graph.BriefUnitGraph;
import soot.util.UnitMap;

public class BusyCodeMotion
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(BusyCodeMotion.class);
    private static final String PREFIX = "$bcm";

    public BusyCodeMotion(Singletons.Global g2) {
    }

    public static BusyCodeMotion v() {
        return G.v().soot_jimple_toolkits_scalar_pre_BusyCodeMotion();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> opts) {
        BCMOptions options = new BCMOptions(opts);
        HashMap<EquivalentValue, Local> expToHelper = new HashMap<EquivalentValue, Local>();
        UnitPatchingChain unitChain = b.getUnits();
        if (Options.v().verbose()) {
            logger.debug("[" + b.getMethod().getName() + "]     performing Busy Code Motion...");
        }
        CriticalEdgeRemover.v().transform(b, phaseName + ".cer");
        BriefUnitGraph graph = new BriefUnitGraph(b);
        UnitMap<EquivalentValue> unitToEquivRhs = new UnitMap<EquivalentValue>(b, graph.size() + 1, 0.7f){

            @Override
            protected EquivalentValue mapTo(Unit unit) {
                Value tmp = SootFilter.noInvokeRhs(unit);
                Value tmp2 = SootFilter.binop(tmp);
                if (tmp2 == null) {
                    tmp2 = SootFilter.concreteRef(tmp);
                }
                return SootFilter.equiVal(tmp2);
            }
        };
        UnitMap<EquivalentValue> unitToNoExceptionEquivRhs = new UnitMap<EquivalentValue>(b, graph.size() + 1, 0.7f){

            @Override
            protected EquivalentValue mapTo(Unit unit) {
                Value tmp = SootFilter.binopRhs(unit);
                tmp = SootFilter.noExceptionThrowing(tmp);
                return SootFilter.equiVal(tmp);
            }
        };
        SideEffectTester sideEffect = Scene.v().hasCallGraph() && !options.naive_side_effect() ? new PASideEffectTester() : new NaiveSideEffectTester();
        sideEffect.newMethod(b.getMethod());
        UpSafetyAnalysis upSafe = new UpSafetyAnalysis(graph, (Map<Unit, EquivalentValue>)unitToEquivRhs, sideEffect);
        DownSafetyAnalysis downSafe = new DownSafetyAnalysis(graph, (Map<Unit, EquivalentValue>)unitToNoExceptionEquivRhs, sideEffect);
        EarliestnessComputation earliest = new EarliestnessComputation(graph, upSafe, downSafe, sideEffect);
        LocalCreation localCreation = new LocalCreation(b.getLocals(), PREFIX);
        Iterator unitIt = unitChain.snapshotIterator();
        while (unitIt.hasNext()) {
            Unit currentUnit = (Unit)unitIt.next();
            for (EquivalentValue equiVal : earliest.getFlowBefore(currentUnit)) {
                Local helper = (Local)expToHelper.get(equiVal);
                if (currentUnit instanceof IdentityStmt) {
                    currentUnit = this.getFirstNonIdentityStmt(b);
                }
                if (helper == null) {
                    helper = localCreation.newLocal(equiVal.getType());
                    expToHelper.put(equiVal, helper);
                }
                Value insertValue = Jimple.cloneIfNecessary(equiVal.getValue());
                AssignStmt firstComp = Jimple.v().newAssignStmt(helper, insertValue);
                unitChain.insertBefore(firstComp, currentUnit);
            }
        }
        for (Unit currentUnit : unitChain) {
            Local helper;
            EquivalentValue rhs = (EquivalentValue)unitToEquivRhs.get(currentUnit);
            if (rhs == null || (helper = (Local)expToHelper.get(rhs)) == null) continue;
            ((AssignStmt)currentUnit).setRightOp(helper);
        }
        if (Options.v().verbose()) {
            logger.debug("[" + b.getMethod().getName() + "]     Busy Code Motion done!");
        }
    }

    private Unit getFirstNonIdentityStmt(Body b) {
        for (Unit u : b.getUnits()) {
            if (u instanceof IdentityStmt) continue;
            return u;
        }
        return null;
    }
}

