/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Singletons;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.jimple.NopStmt;
import soot.options.Options;

public class NopEliminator
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(NopEliminator.class);

    public NopEliminator(Singletons.Global g2) {
    }

    public static NopEliminator v() {
        return G.v().soot_jimple_toolkits_scalar_NopEliminator();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        if (Options.v().verbose()) {
            logger.debug("[" + b.getMethod().getName() + "] Removing nops...");
        }
        UnitPatchingChain units = b.getUnits();
        Iterator stmtIt = units.snapshotIterator();
        while (stmtIt.hasNext()) {
            Unit u = (Unit)stmtIt.next();
            if (!(u instanceof NopStmt)) continue;
            boolean keepNop = false;
            if (b.getUnits().getLast() == u) {
                for (Trap t2 : b.getTraps()) {
                    if (t2.getEndUnit() != u) continue;
                    keepNop = true;
                }
            }
            if (keepNop) continue;
            units.remove(u);
        }
    }
}

