/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.ErroneousType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.PhaseOptions;
import soot.ShortType;
import soot.Singletons;
import soot.StmtAddressType;
import soot.Type;
import soot.UnknownType;
import soot.Value;
import soot.ValueBox;
import soot.util.Chain;

public class LocalNameStandardizer
extends BodyTransformer {
    public LocalNameStandardizer(Singletons.Global g2) {
    }

    public static LocalNameStandardizer v() {
        return G.v().soot_jimple_toolkits_scalar_LocalNameStandardizer();
    }

    private static final int digits(int n) {
        int len = String.valueOf(n).length();
        if (n < 0) {
            return len - 1;
        }
        return len;
    }

    private static final String genName(String prefix, String type, int n, int digits) {
        return String.format("%s%s%0" + digits + "d", prefix, type, n);
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        Chain<Local> locals;
        boolean onlyStackName = PhaseOptions.getBoolean(options, "only-stack-locals");
        boolean sortLocals = PhaseOptions.getBoolean(options, "sort-locals");
        BooleanType booleanType = BooleanType.v();
        ByteType byteType = ByteType.v();
        ShortType shortType = ShortType.v();
        CharType charType = CharType.v();
        IntType intType = IntType.v();
        LongType longType = LongType.v();
        DoubleType doubleType = DoubleType.v();
        FloatType floatType = FloatType.v();
        ErroneousType erroneousType = ErroneousType.v();
        UnknownType unknownType = UnknownType.v();
        StmtAddressType stmtAddressType = StmtAddressType.v();
        NullType nullType = NullType.v();
        int objectCount = 0;
        int intCount = 0;
        int longCount = 0;
        int floatCount = 0;
        int doubleCount = 0;
        int addressCount = 0;
        int errorCount = 0;
        int nullCount = 0;
        if (sortLocals) {
            locals = body.getLocals();
            final List<ValueBox> defs = body.getDefBoxes();
            ArrayList<Local> sortedLocals = new ArrayList<Local>(locals);
            Collections.sort(sortedLocals, new Comparator<Local>(){
                private Map<Local, Integer> firstOccuranceCache = new HashMap<Local, Integer>();

                @Override
                public int compare(Local arg0, Local arg1) {
                    int ret = arg0.getType().toString().compareTo(arg1.getType().toString());
                    if (ret == 0) {
                        ret = Integer.compare(this.getFirstOccurance(arg0), this.getFirstOccurance(arg1));
                    }
                    return ret;
                }

                private int getFirstOccurance(Local l) {
                    Integer cur = this.firstOccuranceCache.get(l);
                    if (cur != null) {
                        return cur;
                    }
                    int count = 0;
                    int first = -1;
                    for (ValueBox vb : defs) {
                        Value v = vb.getValue();
                        if (v instanceof Local && v.equals(l)) {
                            first = count;
                            break;
                        }
                        ++count;
                    }
                    this.firstOccuranceCache.put(l, first);
                    return first;
                }
            });
            locals.clear();
            locals.addAll(sortedLocals);
        }
        if (!onlyStackName) {
            locals = body.getLocals();
            int maxDigits = sortLocals ? LocalNameStandardizer.digits(locals.size()) : 1;
            for (Local l : locals) {
                String prefix = l.getName().startsWith("$") ? "$" : "";
                Type type = l.getType();
                if (type.equals(booleanType)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "z", intCount++, maxDigits));
                    continue;
                }
                if (type.equals(byteType)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "b", longCount++, maxDigits));
                    continue;
                }
                if (type.equals(shortType)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "s", longCount++, maxDigits));
                    continue;
                }
                if (type.equals(charType)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "c", longCount++, maxDigits));
                    continue;
                }
                if (type.equals(intType)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "i", longCount++, maxDigits));
                    continue;
                }
                if (type.equals(longType)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "l", longCount++, maxDigits));
                    continue;
                }
                if (type.equals(doubleType)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "d", doubleCount++, maxDigits));
                    continue;
                }
                if (type.equals(floatType)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "f", floatCount++, maxDigits));
                    continue;
                }
                if (type.equals(stmtAddressType)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "a", addressCount++, maxDigits));
                    continue;
                }
                if (type.equals(erroneousType) || type.equals(unknownType)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "e", errorCount++, maxDigits));
                    continue;
                }
                if (type.equals(nullType)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "n", nullCount++, maxDigits));
                    continue;
                }
                l.setName(LocalNameStandardizer.genName(prefix, "r", objectCount++, maxDigits));
            }
        }
    }
}

