/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.EquivalentValue;
import soot.G;
import soot.Local;
import soot.PhaseOptions;
import soot.Scene;
import soot.SideEffectTester;
import soot.Singletons;
import soot.Type;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.jimple.NaiveSideEffectTester;
import soot.jimple.Stmt;
import soot.jimple.toolkits.pointer.PASideEffectTester;
import soot.jimple.toolkits.scalar.FastAvailableExpressions;
import soot.options.Options;
import soot.tagkit.StringTag;
import soot.toolkits.scalar.UnitValueBoxPair;
import soot.util.Chain;

public class CommonSubexpressionEliminator
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(CommonSubexpressionEliminator.class);

    public CommonSubexpressionEliminator(Singletons.Global g2) {
    }

    public static CommonSubexpressionEliminator v() {
        return G.v().soot_jimple_toolkits_scalar_CommonSubexpressionEliminator();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        int counter = 0;
        Iterator<Local> localsIt = b.getLocals().iterator();
        HashSet<String> localNames = new HashSet<String>(b.getLocals().size());
        while (localsIt.hasNext()) {
            localNames.add(localsIt.next().getName());
        }
        SideEffectTester sideEffect = Scene.v().hasCallGraph() && !PhaseOptions.getBoolean(options, "naive-side-effect") ? new PASideEffectTester() : new NaiveSideEffectTester();
        sideEffect.newMethod(b.getMethod());
        if (Options.v().verbose()) {
            logger.debug("[" + b.getMethod().getName() + "]     Eliminating common subexpressions " + (sideEffect instanceof NaiveSideEffectTester ? "(naively)" : "") + "...");
        }
        FastAvailableExpressions ae = new FastAvailableExpressions(b, sideEffect);
        UnitPatchingChain units = b.getUnits();
        Iterator unitsIt = units.snapshotIterator();
        while (unitsIt.hasNext()) {
            Value v;
            EquivalentValue ev;
            Chain availExprs;
            Stmt s2 = (Stmt)unitsIt.next();
            if (!(s2 instanceof AssignStmt) || !(availExprs = ae.getAvailableEquivsBefore(s2)).contains(ev = new EquivalentValue(v = ((AssignStmt)s2).getRightOp()))) continue;
            List availPairs = ae.getAvailablePairsBefore(s2);
            for (UnitValueBoxPair up : availPairs) {
                if (!up.getValueBox().getValue().equivTo(v)) continue;
                String newName = "$cseTmp" + counter;
                ++counter;
                while (localNames.contains(newName)) {
                    newName = "$cseTmp" + counter;
                    ++counter;
                }
                Local l = Jimple.v().newLocal(newName, Type.toMachineType(v.getType()));
                b.getLocals().add(l);
                AssignStmt origCalc = (AssignStmt)up.getUnit();
                Value origLHS = origCalc.getLeftOp();
                origCalc.setLeftOp(l);
                AssignStmt copier = Jimple.v().newAssignStmt(origLHS, l);
                units.insertAfter(copier, origCalc);
                ((AssignStmt)s2).setRightOp(l);
                copier.addTag(new StringTag("Common sub-expression"));
                s2.addTag(new StringTag("Common sub-expression"));
            }
        }
        if (Options.v().verbose()) {
            logger.debug("[" + b.getMethod().getName() + "]     Eliminating common subexpressions done!");
        }
    }
}

