/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.EquivalentValue;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.BackwardFlowAnalysis;
import soot.toolkits.scalar.FlowSet;

public class CommonPrecedingEqualValueAnalysis
extends BackwardFlowAnalysis {
    private static final Logger logger = LoggerFactory.getLogger(CommonPrecedingEqualValueAnalysis.class);
    Map unitToAliasSet = null;
    Stmt s = null;

    public CommonPrecedingEqualValueAnalysis(UnitGraph g2) {
        super(g2);
    }

    public List getCommonAncestorValuesOf(Map unitToAliasSet, Stmt s2) {
        this.unitToAliasSet = unitToAliasSet;
        this.s = s2;
        this.doAnalysis();
        FlowSet fs = (FlowSet)this.getFlowAfter(s2);
        ArrayList ancestorList = new ArrayList(fs.size());
        for (Object o : fs) {
            ancestorList.add(o);
        }
        return ancestorList;
    }

    @Override
    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.intersection(inSet2, outSet);
    }

    @Override
    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        block4: {
            ArrayList<EquivalentValue> newDefs;
            Stmt stmt;
            FlowSet out;
            block3: {
                FlowSet in = (FlowSet)inValue;
                out = (FlowSet)outValue;
                stmt = (Stmt)unit;
                in.copy(out);
                newDefs = new ArrayList<EquivalentValue>();
                Iterator<ValueBox> newDefBoxesIt = stmt.getDefBoxes().iterator();
                while (newDefBoxesIt.hasNext()) {
                    newDefs.add(new EquivalentValue(newDefBoxesIt.next().getValue()));
                }
                if (!this.unitToAliasSet.keySet().contains(stmt)) break block3;
                out.clear();
                List aliases = (List)this.unitToAliasSet.get(stmt);
                Iterator aliasIt = aliases.iterator();
                while (aliasIt.hasNext()) {
                    out.add(aliasIt.next());
                }
                break block4;
            }
            if (!(stmt instanceof DefinitionStmt)) break block4;
            Iterator newDefsIt = newDefs.iterator();
            while (newDefsIt.hasNext()) {
                out.remove(newDefsIt.next());
            }
        }
    }

    @Override
    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }

    @Override
    protected Object entryInitialFlow() {
        return new ArraySparseSet();
    }

    @Override
    protected Object newInitialFlow() {
        return new ArraySparseSet();
    }
}

