/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.Local;
import soot.RefLikeType;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Stmt;
import soot.jimple.toolkits.pointer.LocalMustAliasAnalysis;
import soot.toolkits.graph.StronglyConnectedComponentsFast;
import soot.toolkits.graph.UnitGraph;

public class StrongLocalMustAliasAnalysis
extends LocalMustAliasAnalysis {
    protected Set<Integer> invalidInstanceKeys = new HashSet<Integer>();

    public StrongLocalMustAliasAnalysis(UnitGraph g2) {
        super(g2);
        StronglyConnectedComponentsFast<Unit> sccAnalysis = new StronglyConnectedComponentsFast<Unit>(g2);
        for (List<Unit> scc : sccAnalysis.getTrueComponents()) {
            for (Unit unit : scc) {
                for (ValueBox vb : unit.getDefBoxes()) {
                    Integer intKey;
                    Local defLocal;
                    Value defValue = vb.getValue();
                    if (!(defValue instanceof Local) || !((defLocal = (Local)defValue).getType() instanceof RefLikeType)) continue;
                    Object instanceKey = ((HashMap)this.getFlowBefore(unit)).get(defLocal);
                    if (instanceKey instanceof Integer) {
                        intKey = (Integer)instanceKey;
                        this.invalidInstanceKeys.add(intKey);
                    }
                    if (!((instanceKey = ((HashMap)this.getFlowAfter(unit)).get(defLocal)) instanceof Integer)) continue;
                    intKey = (Integer)instanceKey;
                    this.invalidInstanceKeys.add(intKey);
                }
            }
        }
    }

    @Override
    public boolean mustAlias(Local l1, Stmt s1, Local l2, Stmt s2) {
        Object l1n = ((HashMap)this.getFlowBefore(s1)).get(l1);
        Object l2n = ((HashMap)this.getFlowBefore(s2)).get(l2);
        if (l1n == null || l2n == null || this.invalidInstanceKeys.contains(l1n) || this.invalidInstanceKeys.contains(l2n)) {
            return false;
        }
        return l1n == l2n;
    }

    @Override
    public String instanceKeyString(Local l, Stmt s2) {
        Object ln = ((HashMap)this.getFlowBefore(s2)).get(l);
        if (this.invalidInstanceKeys.contains(ln)) {
            return "UNKNOWN";
        }
        return super.instanceKeyString(l, s2);
    }
}

