/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import soot.PointsToSet;
import soot.Scene;
import soot.SootField;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.sets.HashPointsToSet;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.toolkits.pointer.FullObjectSet;
import soot.jimple.toolkits.pointer.MethodRWSet;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.pointer.SiteRWSet;
import soot.jimple.toolkits.pointer.StmtRWSet;

public class CodeBlockRWSet
extends MethodRWSet {
    @Override
    public int size() {
        if (this.globals == null) {
            if (this.fields == null) {
                return 0;
            }
            return this.fields.size();
        }
        if (this.fields == null) {
            return this.globals.size();
        }
        return this.globals.size() + this.fields.size();
    }

    @Override
    public String toString() {
        boolean empty = true;
        StringBuffer ret = new StringBuffer();
        if (this.fields != null) {
            Iterator iterator = this.fields.keySet().iterator();
            while (iterator.hasNext()) {
                Object element;
                Object field = element = iterator.next();
                ret.append("[Field: " + field + " ");
                Object baseObj = this.fields.get(field);
                if (baseObj instanceof PointsToSetInternal) {
                    int baseSize = ((PointsToSetInternal)baseObj).size();
                    ret.append(baseSize + (baseSize == 1 ? " Node]\n" : " Nodes]\n"));
                } else {
                    ret.append(baseObj + "]\n");
                }
                empty = false;
            }
        }
        if (this.globals != null) {
            for (Object global : this.globals) {
                ret.append("[Global: " + global + "]\n");
                empty = false;
            }
        }
        if (empty) {
            ret.append("[emptyset]\n");
        }
        return ret.toString();
    }

    @Override
    public boolean union(RWSet other) {
        if (other == null) {
            return false;
        }
        if (this.isFull) {
            return false;
        }
        boolean ret = false;
        if (other instanceof MethodRWSet) {
            MethodRWSet o = (MethodRWSet)other;
            if (o.getCallsNative()) {
                ret = !this.getCallsNative() | ret;
                this.setCallsNative();
            }
            if (o.isFull) {
                ret = !this.isFull | ret;
                this.isFull = true;
                throw new RuntimeException("attempt to add full set " + o + " into " + this);
            }
            if (o.globals != null) {
                if (this.globals == null) {
                    this.globals = new HashSet();
                }
                ret = this.globals.addAll(o.globals) | ret;
                if (this.globals.size() > Integer.MAX_VALUE) {
                    this.globals = null;
                    this.isFull = true;
                    throw new RuntimeException("attempt to add full set " + o + " into " + this);
                }
            }
            if (o.fields != null) {
                Iterator<Object> iterator = o.fields.keySet().iterator();
                while (iterator.hasNext()) {
                    Object element;
                    Object field = element = iterator.next();
                    PointsToSet os = o.getBaseForField(field);
                    ret = this.addFieldRef(os, field) | ret;
                }
            }
        } else if (other instanceof StmtRWSet) {
            StmtRWSet oth = (StmtRWSet)other;
            if (oth.base != null) {
                ret = this.addFieldRef(oth.base, oth.field) | ret;
            } else if (oth.field != null) {
                ret = this.addGlobal((SootField)oth.field) | ret;
            }
        } else if (other instanceof SiteRWSet) {
            SiteRWSet oth = (SiteRWSet)other;
            for (RWSet set : oth.sets) {
                this.union(set);
            }
        }
        if (!this.getCallsNative() && other.getCallsNative()) {
            this.setCallsNative();
            return true;
        }
        return ret;
    }

    public boolean containsField(Object field) {
        if (this.fields == null) {
            return false;
        }
        return this.fields.containsKey(field);
    }

    public CodeBlockRWSet intersection(MethodRWSet other) {
        CodeBlockRWSet ret = new CodeBlockRWSet();
        if (this.isFull) {
            return ret;
        }
        if (this.globals != null && other.globals != null && !this.globals.isEmpty() && !other.globals.isEmpty()) {
            for (SootField sg : other.globals) {
                if (!this.globals.contains(sg)) continue;
                ret.addGlobal(sg);
            }
        }
        if (this.fields != null && other.fields != null && !this.fields.isEmpty() && !other.fields.isEmpty()) {
            for (Object element : other.fields.keySet()) {
                Object field = element;
                if (!this.fields.containsKey(field)) continue;
                PointsToSet pts1 = this.getBaseForField(field);
                PointsToSet pts2 = other.getBaseForField(field);
                if (pts1 instanceof FullObjectSet) {
                    ret.addFieldRef(pts2, field);
                    continue;
                }
                if (pts2 instanceof FullObjectSet) {
                    ret.addFieldRef(pts1, field);
                    continue;
                }
                if (!pts1.hasNonEmptyIntersection(pts2) || !(pts1 instanceof PointsToSetInternal) || !(pts2 instanceof PointsToSetInternal)) continue;
                PointsToSetInternal pti1 = (PointsToSetInternal)pts1;
                final PointsToSetInternal pti2 = (PointsToSetInternal)pts2;
                final HashPointsToSet newpti = new HashPointsToSet(pti1.getType(), (PAG)Scene.v().getPointsToAnalysis());
                pti1.forall(new P2SetVisitor(){

                    @Override
                    public void visit(Node n) {
                        if (pti2.contains(n)) {
                            newpti.add(n);
                        }
                    }
                });
                ret.addFieldRef(newpti, field);
            }
        }
        return ret;
    }

    @Override
    public boolean addFieldRef(PointsToSet otherBase, Object field) {
        PointsToSet base;
        boolean ret = false;
        if (this.fields == null) {
            this.fields = new HashMap();
        }
        if ((base = this.getBaseForField(field)) instanceof FullObjectSet) {
            return false;
        }
        if (otherBase instanceof FullObjectSet) {
            this.fields.put(field, otherBase);
            return true;
        }
        if (otherBase.equals(base)) {
            return false;
        }
        if (base == null) {
            HashPointsToSet newpti = new HashPointsToSet(((PointsToSetInternal)otherBase).getType(), (PAG)Scene.v().getPointsToAnalysis());
            base = newpti;
            this.fields.put(field, base);
        }
        ret = ((PointsToSetInternal)base).addAll((PointsToSetInternal)otherBase, null) | ret;
        return ret;
    }
}

