/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.RefType;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.ConditionExpr;
import soot.jimple.EqExpr;
import soot.jimple.IfStmt;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.NeExpr;
import soot.jimple.NewExpr;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.toolkits.pointer.CastCheckTag;
import soot.jimple.toolkits.pointer.LocalTypeSet;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ForwardBranchedFlowAnalysis;
import soot.util.Chain;

public class CastCheckEliminator
extends ForwardBranchedFlowAnalysis<LocalTypeSet> {
    Map unitToKill = new HashMap();
    Map unitToGenFallThrough = new HashMap();
    Map unitToGenBranch = new HashMap();
    LocalTypeSet emptySet;

    public CastCheckEliminator(BriefUnitGraph cfg) {
        super(cfg);
        this.makeInitialSet();
        this.doAnalysis();
        this.tagCasts();
    }

    protected void tagCasts() {
        for (Stmt s2 : ((UnitGraph)this.graph).getBody().getUnits()) {
            CastExpr cast;
            Type t2;
            AssignStmt as;
            Value rhs;
            if (!(s2 instanceof AssignStmt) || !((rhs = (as = (AssignStmt)s2).getRightOp()) instanceof CastExpr) || !((t2 = (cast = (CastExpr)rhs).getCastType()) instanceof RefType)) continue;
            if (cast.getOp() instanceof Local) {
                Local l = (Local)cast.getOp();
                LocalTypeSet set = (LocalTypeSet)this.getFlowBefore(s2);
                s2.addTag(new CastCheckTag(set.get(set.indexOf(l, (RefType)t2))));
                continue;
            }
            NullConstant nc = (NullConstant)cast.getOp();
            s2.addTag(new CastCheckTag(true));
        }
    }

    protected void makeInitialSet() {
        Chain<Local> locals = ((UnitGraph)this.graph).getBody().getLocals();
        ArrayList<Local> refLocals = new ArrayList<Local>();
        for (Local l : locals) {
            if (!(l.getType() instanceof RefType)) continue;
            refLocals.add(l);
        }
        ArrayList<Type> types = new ArrayList<Type>();
        for (Stmt s2 : ((UnitGraph)this.graph).getBody().getUnits()) {
            Type t2;
            AssignStmt as;
            Value rhs;
            if (!(s2 instanceof AssignStmt) || !((rhs = (as = (AssignStmt)s2).getRightOp()) instanceof CastExpr) || !((t2 = ((CastExpr)rhs).getCastType()) instanceof RefType) || types.contains(t2)) continue;
            types.add(t2);
        }
        this.emptySet = new LocalTypeSet(refLocals, types);
    }

    @Override
    protected LocalTypeSet newInitialFlow() {
        LocalTypeSet ret = (LocalTypeSet)this.emptySet.clone();
        ret.setAllBits();
        return ret;
    }

    @Override
    protected void flowThrough(LocalTypeSet in, Unit unit, List<LocalTypeSet> outFallValues, List<LocalTypeSet> outBranchValues) {
        LocalTypeSet out;
        LocalTypeSet outBranch = out = (LocalTypeSet)in.clone();
        Stmt stmt = (Stmt)unit;
        for (ValueBox b : stmt.getDefBoxes()) {
            Value v = b.getValue();
            if (!(v instanceof Local) || !(v.getType() instanceof RefType)) continue;
            out.killLocal((Local)v);
        }
        if (stmt instanceof AssignStmt) {
            AssignStmt astmt = (AssignStmt)stmt;
            Value rhs = astmt.getRightOp();
            Value lhs = astmt.getLeftOp();
            if (lhs instanceof Local && rhs.getType() instanceof RefType) {
                Local l = (Local)lhs;
                if (rhs instanceof NewExpr) {
                    out.localMustBeSubtypeOf(l, (RefType)rhs.getType());
                } else if (rhs instanceof CastExpr) {
                    CastExpr cast = (CastExpr)rhs;
                    Type castType = cast.getCastType();
                    if (castType instanceof RefType && cast.getOp() instanceof Local) {
                        RefType refType = (RefType)castType;
                        Local opLocal = (Local)cast.getOp();
                        out.localCopy(l, opLocal);
                        out.localMustBeSubtypeOf(l, refType);
                        out.localMustBeSubtypeOf(opLocal, refType);
                    }
                } else if (rhs instanceof Local) {
                    out.localCopy(l, (Local)rhs);
                }
            }
        } else if (stmt instanceof IfStmt) {
            ConditionExpr c;
            InstanceOfExpr iofexpr;
            AssignStmt pred;
            Stmt predecessor;
            IfStmt ifstmt = (IfStmt)stmt;
            if (this.graph.getPredsOf(stmt).size() == 1 && (predecessor = this.graph.getPredsOf(stmt).get(0)) instanceof AssignStmt && (pred = (AssignStmt)predecessor).getRightOp() instanceof InstanceOfExpr && (iofexpr = (InstanceOfExpr)pred.getRightOp()).getCheckType() instanceof RefType && iofexpr.getOp() instanceof Local && (c = (ConditionExpr)ifstmt.getCondition()).getOp1().equals(pred.getLeftOp()) && c.getOp2() instanceof IntConstant && ((IntConstant)c.getOp2()).value == 0) {
                if (c instanceof NeExpr) {
                    outBranch = (LocalTypeSet)out.clone();
                    outBranch.localMustBeSubtypeOf((Local)iofexpr.getOp(), (RefType)iofexpr.getCheckType());
                } else if (c instanceof EqExpr) {
                    outBranch = (LocalTypeSet)out.clone();
                    out.localMustBeSubtypeOf((Local)iofexpr.getOp(), (RefType)iofexpr.getCheckType());
                }
            }
        }
        Iterator<LocalTypeSet> it = outFallValues.iterator();
        while (it.hasNext()) {
            this.copy(out, it.next());
        }
        it = outBranchValues.iterator();
        while (it.hasNext()) {
            this.copy(outBranch, it.next());
        }
    }

    @Override
    protected void copy(LocalTypeSet s2, LocalTypeSet d) {
        d.and(s2);
        d.or(s2);
    }

    @Override
    protected void merge(LocalTypeSet in1, LocalTypeSet in2, LocalTypeSet o) {
        o.setAllBits();
        o.and(in1);
        o.and(in2);
    }

    @Override
    protected LocalTypeSet entryInitialFlow() {
        LocalTypeSet ret = (LocalTypeSet)this.emptySet.clone();
        return ret;
    }
}

