/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.ide.icfg;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.DontSynchronize;
import heros.SynchronizedBy;
import heros.solver.IDESolver;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.SootMethod;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.Stmt;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.ExceptionalUnitGraph;

public abstract class AbstractJimpleBasedICFG
implements BiDiInterproceduralCFG<Unit, SootMethod> {
    protected final boolean enableExceptions;
    @DontSynchronize(value="written by single thread; read afterwards")
    private final Map<Unit, Body> unitToOwner = this.createUnitToOwnerMap();
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected LoadingCache<Body, DirectedGraph<Unit>> bodyToUnitGraph = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<Body, DirectedGraph<Unit>>(){

        @Override
        public DirectedGraph<Unit> load(Body body) throws Exception {
            return AbstractJimpleBasedICFG.this.makeGraph(body);
        }
    });
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected LoadingCache<SootMethod, List<Value>> methodToParameterRefs = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<SootMethod, List<Value>>(){

        @Override
        public List<Value> load(SootMethod m4) throws Exception {
            return m4.getActiveBody().getParameterRefs();
        }
    });
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected LoadingCache<SootMethod, Set<Unit>> methodToCallsFromWithin = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<SootMethod, Set<Unit>>(){

        @Override
        public Set<Unit> load(SootMethod m4) throws Exception {
            return AbstractJimpleBasedICFG.this.getCallsFromWithinMethod(m4);
        }
    });

    public AbstractJimpleBasedICFG() {
        this(true);
    }

    protected Map<Unit, Body> createUnitToOwnerMap() {
        return new LinkedHashMap<Unit, Body>();
    }

    public AbstractJimpleBasedICFG(boolean enableExceptions) {
        this.enableExceptions = enableExceptions;
    }

    public Body getBodyOf(Unit u) {
        assert (this.unitToOwner.containsKey(u)) : "Statement " + u + " not in unit-to-owner mapping";
        Body b = this.unitToOwner.get(u);
        return b;
    }

    @Override
    public SootMethod getMethodOf(Unit u) {
        Body b = this.getBodyOf(u);
        return b == null ? null : b.getMethod();
    }

    @Override
    public List<Unit> getSuccsOf(Unit u) {
        Body body = this.getBodyOf(u);
        if (body == null) {
            return Collections.emptyList();
        }
        DirectedGraph<Unit> unitGraph = this.getOrCreateUnitGraph(body);
        return unitGraph.getSuccsOf(u);
    }

    @Override
    public DirectedGraph<Unit> getOrCreateUnitGraph(SootMethod m4) {
        return this.getOrCreateUnitGraph(m4.getActiveBody());
    }

    @Override
    public DirectedGraph<Unit> getOrCreateUnitGraph(Body body) {
        return this.bodyToUnitGraph.getUnchecked(body);
    }

    protected DirectedGraph<Unit> makeGraph(Body body) {
        return this.enableExceptions ? new ExceptionalUnitGraph(body) : new BriefUnitGraph(body);
    }

    protected Set<Unit> getCallsFromWithinMethod(SootMethod m4) {
        LinkedHashSet<Unit> res = null;
        for (Unit u : m4.getActiveBody().getUnits()) {
            if (!this.isCallStmt(u)) continue;
            if (res == null) {
                res = new LinkedHashSet<Unit>();
            }
            res.add(u);
        }
        return res == null ? Collections.emptySet() : res;
    }

    @Override
    public boolean isExitStmt(Unit u) {
        Body body = this.getBodyOf(u);
        DirectedGraph<Unit> unitGraph = this.getOrCreateUnitGraph(body);
        return unitGraph.getTails().contains(u);
    }

    @Override
    public boolean isStartPoint(Unit u) {
        Body body = this.getBodyOf(u);
        DirectedGraph<Unit> unitGraph = this.getOrCreateUnitGraph(body);
        return unitGraph.getHeads().contains(u);
    }

    @Override
    public boolean isFallThroughSuccessor(Unit u, Unit succ) {
        assert (this.getSuccsOf(u).contains(succ));
        if (!u.fallsThrough()) {
            return false;
        }
        Body body = this.getBodyOf(u);
        return body.getUnits().getSuccOf(u) == succ;
    }

    @Override
    public boolean isBranchTarget(Unit u, Unit succ) {
        assert (this.getSuccsOf(u).contains(succ));
        if (!u.branches()) {
            return false;
        }
        for (UnitBox ub : u.getUnitBoxes()) {
            if (ub.getUnit() != succ) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Value> getParameterRefs(SootMethod m4) {
        return this.methodToParameterRefs.getUnchecked(m4);
    }

    @Override
    public Collection<Unit> getStartPointsOf(SootMethod m4) {
        if (m4.hasActiveBody()) {
            Body body = m4.getActiveBody();
            DirectedGraph<Unit> unitGraph = this.getOrCreateUnitGraph(body);
            return unitGraph.getHeads();
        }
        return Collections.emptySet();
    }

    public boolean setOwnerStatement(Unit u, Body b) {
        return this.unitToOwner.put(u, b) == null;
    }

    @Override
    public boolean isCallStmt(Unit u) {
        return ((Stmt)u).containsInvokeExpr();
    }

    @Override
    public Set<Unit> allNonCallStartNodes() {
        LinkedHashSet<Unit> res = new LinkedHashSet<Unit>(this.unitToOwner.keySet());
        Iterator iter = res.iterator();
        while (iter.hasNext()) {
            Unit u = (Unit)iter.next();
            if (!this.isStartPoint(u) && !this.isCallStmt(u)) continue;
            iter.remove();
        }
        return res;
    }

    @Override
    public Set<Unit> allNonCallEndNodes() {
        LinkedHashSet<Unit> res = new LinkedHashSet<Unit>(this.unitToOwner.keySet());
        Iterator iter = res.iterator();
        while (iter.hasNext()) {
            Unit u = (Unit)iter.next();
            if (!this.isExitStmt(u) && !this.isCallStmt(u)) continue;
            iter.remove();
        }
        return res;
    }

    @Override
    public Collection<Unit> getReturnSitesOfCallAt(Unit u) {
        return this.getSuccsOf(u);
    }

    @Override
    public Set<Unit> getCallsFromWithin(SootMethod m4) {
        return this.methodToCallsFromWithin.getUnchecked(m4);
    }

    public void initializeUnitToOwner(SootMethod m4) {
        if (m4.hasActiveBody()) {
            Body b = m4.getActiveBody();
            UnitPatchingChain units = b.getUnits();
            for (Unit unit : units) {
                this.unitToOwner.put(unit, b);
            }
        }
    }

    @Override
    public List<Unit> getPredsOf(Unit u) {
        assert (u != null);
        Body body = this.getBodyOf(u);
        if (body == null) {
            return Collections.emptyList();
        }
        DirectedGraph<Unit> unitGraph = this.getOrCreateUnitGraph(body);
        return unitGraph.getPredsOf(u);
    }

    @Override
    public Collection<Unit> getEndPointsOf(SootMethod m4) {
        if (m4.hasActiveBody()) {
            Body body = m4.getActiveBody();
            DirectedGraph<Unit> unitGraph = this.getOrCreateUnitGraph(body);
            return unitGraph.getTails();
        }
        return Collections.emptySet();
    }

    @Override
    public List<Unit> getPredsOfCallAt(Unit u) {
        return this.getPredsOf(u);
    }

    @Override
    public boolean isReturnSite(Unit n) {
        for (Unit pred : this.getPredsOf(n)) {
            if (!this.isCallStmt(pred)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReachable(Unit u) {
        return this.unitToOwner.containsKey(u);
    }
}

