/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.Local;
import soot.NullType;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.IntConstant;
import soot.jimple.NewArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.shimple.PhiExpr;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class ConstantArrayAnalysis
extends ForwardFlowAnalysis<Unit, ArrayState> {
    private Map<Local, Integer> localToInt = new HashMap<Local, Integer>();
    private Map<Type, Integer> typeToInt = new HashMap<Type, Integer>();
    private Map<Integer, Integer> sizeToInt = new HashMap<Integer, Integer>();
    private Map<Integer, Type> rvTypeToInt = new HashMap<Integer, Type>();
    private Map<Integer, Integer> rvSizeToInt = new HashMap<Integer, Integer>();
    private int size;
    private int typeSize;
    private int szSize;

    public ConstantArrayAnalysis(DirectedGraph<Unit> graph, Body b) {
        super(graph);
        for (Local l : b.getLocals()) {
            this.localToInt.put(l, this.size++);
        }
        for (Unit u : b.getUnits()) {
            int key;
            int sz;
            NewArrayExpr nae;
            Stmt s2 = (Stmt)u;
            if (!(s2 instanceof DefinitionStmt)) continue;
            Type ty = ((DefinitionStmt)s2).getRightOp().getType();
            if (!this.typeToInt.containsKey(ty)) {
                int key2;
                ++this.typeSize;
                this.typeToInt.put(ty, key2);
                this.rvTypeToInt.put(key2, ty);
            }
            if (!(((DefinitionStmt)s2).getRightOp() instanceof NewArrayExpr) || !((nae = (NewArrayExpr)((DefinitionStmt)s2).getRightOp()).getSize() instanceof IntConstant) || this.sizeToInt.containsKey(sz = ((IntConstant)nae.getSize()).value)) continue;
            ++this.szSize;
            this.sizeToInt.put(sz, key);
            this.rvSizeToInt.put(key, sz);
        }
        this.doAnalysis();
    }

    @Override
    protected void flowThrough(ArrayState in, Unit d, ArrayState out) {
        out.active.clear();
        out.active.or(in.active);
        out.state = Arrays.copyOf(in.state, in.state.length);
        if (d instanceof DefinitionStmt) {
            DefinitionStmt ds = (DefinitionStmt)d;
            Value rhs = ds.getRightOp();
            Value lhs = ds.getLeftOp();
            if (rhs instanceof NewArrayExpr) {
                Local l = (Local)lhs;
                int varRef = this.localToInt.get(l);
                NewArrayExpr nae = (NewArrayExpr)rhs;
                out.active.set(varRef);
                if (!(nae.getSize() instanceof IntConstant)) {
                    out.state[varRef] = null;
                } else {
                    int arraySize = ((IntConstant)nae.getSize()).value;
                    out.state[varRef] = new ArrayTypesInternal();
                    out.state[varRef].sizeState.set(this.sizeToInt.get(arraySize));
                    out.state[varRef].typeState = new BitSet[arraySize];
                    out.state[varRef].mustAssign = new BitSet(arraySize);
                    for (int i = 0; i < arraySize; ++i) {
                        out.state[varRef].typeState[i] = new BitSet(this.typeSize);
                    }
                }
            } else if (lhs instanceof Local && lhs.getType() instanceof ArrayType && rhs instanceof NullConstant) {
                int varRef = this.localToInt.get(lhs);
                out.active.clear(varRef);
                out.state[varRef] = null;
            } else if (lhs instanceof Local && rhs instanceof Local && in.state[this.localToInt.get(rhs)] != null && in.active.get(this.localToInt.get(rhs))) {
                int lhsRef = this.localToInt.get(lhs);
                int rhsRef = this.localToInt.get(rhs);
                out.active.set(lhsRef);
                out.state[lhsRef] = in.state[rhsRef];
                out.state[rhsRef] = null;
            } else if (lhs instanceof Local && rhs instanceof PhiExpr) {
                int i;
                PhiExpr rPhi = (PhiExpr)rhs;
                int lhsRef = this.localToInt.get(lhs);
                out.state[lhsRef] = null;
                List<Value> phiValues = rPhi.getValues();
                for (i = 0; i < phiValues.size(); ++i) {
                    Value v = phiValues.get(i);
                    int argRef = this.localToInt.get(v);
                    if (!in.active.get(argRef)) continue;
                    out.active.set(lhsRef);
                    if (in.state[argRef] == null) {
                        out.state[lhsRef] = null;
                        break;
                    }
                    out.state[lhsRef] = out.state[lhsRef] == null ? in.state[argRef] : this.mergeTypeStates(in.state[argRef], out.state[lhsRef]);
                    out.state[argRef] = null;
                }
                while (i < phiValues.size()) {
                    int argRef = this.localToInt.get(phiValues.get(i));
                    out.state[argRef] = null;
                    ++i;
                }
            } else if (lhs instanceof ArrayRef) {
                ArrayRef ar = (ArrayRef)lhs;
                Value indexVal = ar.getIndex();
                int localRef = this.localToInt.get(ar.getBase());
                if (!(indexVal instanceof IntConstant)) {
                    out.state[localRef] = null;
                    out.active.set(localRef);
                } else if (out.state[localRef] != null) {
                    Type assignType = rhs.getType();
                    int index = ((IntConstant)indexVal).value;
                    assert (index < out.state[localRef].typeState.length);
                    out.deepCloneLocalValueSlot(localRef, index);
                    assert (out.state[localRef].typeState[index] != null) : d;
                    out.state[localRef].typeState[index].set(this.typeToInt.get(assignType));
                    out.state[localRef].mustAssign.set(index);
                }
            } else {
                Value leftOp = lhs;
                if (leftOp instanceof Local) {
                    Local defLocal = (Local)leftOp;
                    int varRef = this.localToInt.get(defLocal);
                    out.active.set(varRef);
                    out.state[varRef] = null;
                }
            }
            for (ValueBox b : rhs.getUseBoxes()) {
                if (!this.localToInt.containsKey(b.getValue())) continue;
                int localRef = this.localToInt.get(b.getValue());
                out.state[localRef] = null;
                out.active.set(localRef);
            }
            if (this.localToInt.containsKey(rhs)) {
                int localRef = this.localToInt.get(rhs);
                out.state[localRef] = null;
                out.active.set(localRef);
            }
        } else {
            for (ValueBox b : d.getUseBoxes()) {
                if (!this.localToInt.containsKey(b.getValue())) continue;
                int localRef = this.localToInt.get(b.getValue());
                out.state[localRef] = null;
                out.active.set(localRef);
            }
        }
    }

    @Override
    protected ArrayState newInitialFlow() {
        return new ArrayState();
    }

    @Override
    protected void merge(ArrayState in1, ArrayState in2, ArrayState out) {
        out.active.clear();
        out.active.or(in1.active);
        out.active.or(in2.active);
        BitSet in2_excl = (BitSet)in2.active.clone();
        in2_excl.andNot(in1.active);
        int i = in1.active.nextSetBit(0);
        while (i >= 0) {
            out.state[i] = in1.state[i] == null ? null : (in2.active.get(i) ? (in2.state[i] == null ? null : this.mergeTypeStates(in1.state[i], in2.state[i])) : in1.state[i]);
            i = in1.active.nextSetBit(i + 1);
        }
        i = in2_excl.nextSetBit(0);
        while (i >= 0) {
            out.state[i] = in2.state[i];
            i = in2_excl.nextSetBit(i + 1);
        }
    }

    private ArrayTypesInternal mergeTypeStates(ArrayTypesInternal a1, ArrayTypesInternal a2) {
        int i;
        assert (a1 != null && a2 != null);
        ArrayTypesInternal toRet = new ArrayTypesInternal();
        toRet.sizeState.or(a1.sizeState);
        toRet.sizeState.or(a2.sizeState);
        int maxSize = Math.max(a1.typeState.length, a2.typeState.length);
        int commonSize = Math.min(a1.typeState.length, a2.typeState.length);
        toRet.mustAssign = new BitSet(maxSize);
        toRet.typeState = new BitSet[maxSize];
        for (i = 0; i < commonSize; ++i) {
            toRet.typeState[i] = new BitSet(this.typeSize);
            toRet.typeState[i].or(a1.typeState[i]);
            toRet.typeState[i].or(a2.typeState[i]);
            toRet.mustAssign.set(i, a1.mustAssign.get(i) && a2.mustAssign.get(i));
        }
        for (i = commonSize; i < maxSize; ++i) {
            if (a1.typeState.length > i) {
                toRet.typeState[i] = (BitSet)a1.typeState[i].clone();
                toRet.mustAssign.set(i, a1.mustAssign.get(i));
                continue;
            }
            toRet.mustAssign.set(i, a2.mustAssign.get(i));
            toRet.typeState[i] = (BitSet)a2.typeState[i].clone();
        }
        return toRet;
    }

    @Override
    protected void copy(ArrayState source, ArrayState dest) {
        dest.active = source.active;
        dest.state = source.state;
    }

    public boolean isConstantBefore(Stmt s2, Local arrayLocal) {
        ArrayState flowResults = (ArrayState)this.getFlowBefore(s2);
        int varRef = this.localToInt.get(arrayLocal);
        return flowResults.active.get(varRef) && flowResults.state[varRef] != null;
    }

    public ArrayTypes getArrayTypesBefore(Stmt s2, Local arrayLocal) {
        if (!this.isConstantBefore(s2, arrayLocal)) {
            return null;
        }
        ArrayTypes toRet = new ArrayTypes();
        int varRef = this.localToInt.get(arrayLocal);
        ArrayTypesInternal ati = ((ArrayState)this.getFlowBefore(s2)).state[varRef];
        toRet.possibleSizes = new HashSet<Integer>();
        toRet.possibleTypes = new Set[ati.typeState.length];
        int i = ati.sizeState.nextSetBit(0);
        while (i >= 0) {
            toRet.possibleSizes.add(this.rvSizeToInt.get(i));
            i = ati.sizeState.nextSetBit(i + 1);
        }
        for (i = 0; i < toRet.possibleTypes.length; ++i) {
            toRet.possibleTypes[i] = new HashSet<Type>();
            int j = ati.typeState[i].nextSetBit(0);
            while (j >= 0) {
                toRet.possibleTypes[i].add(this.rvTypeToInt.get(j));
                j = ati.typeState[i].nextSetBit(j + 1);
            }
            if (ati.mustAssign.get(i)) continue;
            toRet.possibleTypes[i].add(NullType.v());
        }
        return toRet;
    }

    public class ArrayState {
        ArrayTypesInternal[] state;
        BitSet active;

        public ArrayState() {
            this.state = new ArrayTypesInternal[ConstantArrayAnalysis.this.size];
            this.active = new BitSet(ConstantArrayAnalysis.this.size);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ArrayState)) {
                return false;
            }
            ArrayState otherState = (ArrayState)obj;
            return otherState.active.equals(this.active) && Arrays.equals(this.state, otherState.state);
        }

        public void deepCloneLocalValueSlot(int localRef, int index) {
            this.state[localRef] = (ArrayTypesInternal)this.state[localRef].clone();
            this.state[localRef].typeState[index] = (BitSet)this.state[localRef].typeState[index].clone();
        }
    }

    public static class ArrayTypes {
        public Set<Integer> possibleSizes;
        public Set<Type>[] possibleTypes;

        public String toString() {
            return "ArrayTypes [possibleSizes=" + this.possibleSizes + ", possibleTypes=" + Arrays.toString(this.possibleTypes) + "]";
        }
    }

    private class ArrayTypesInternal
    implements Cloneable {
        BitSet mustAssign;
        BitSet[] typeState;
        BitSet sizeState;

        private ArrayTypesInternal() {
            this.sizeState = new BitSet(ConstantArrayAnalysis.this.szSize);
        }

        public Object clone() {
            try {
                ArrayTypesInternal s2 = (ArrayTypesInternal)super.clone();
                s2.sizeState = (BitSet)s2.sizeState.clone();
                s2.typeState = (BitSet[])s2.typeState.clone();
                s2.mustAssign = (BitSet)s2.mustAssign.clone();
                return s2;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ArrayTypesInternal)) {
                return false;
            }
            ArrayTypesInternal otherTypes = (ArrayTypesInternal)obj;
            return otherTypes.sizeState.equals(this.sizeState) && Arrays.equals(this.typeState, otherTypes.typeState) && this.mustAssign.equals(otherTypes.mustAssign);
        }
    }
}

