/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.jimple.StmtBody;
import soot.jimple.toolkits.base.Zone;

public class Zonation {
    private int zoneCount;
    private Map<Unit, Zone> unitToZone;

    public Zonation(StmtBody body) {
        UnitPatchingChain units = body.getUnits();
        HashMap<Unit, List<Trap>> unitToTrapBoundaries = new HashMap<Unit, List<Trap>>();
        for (Trap t2 : body.getTraps()) {
            this.addTrapBoundary(t2.getBeginUnit(), t2, unitToTrapBoundaries);
            this.addTrapBoundary(t2.getEndUnit(), t2, unitToTrapBoundaries);
        }
        HashMap trapListToZone = new HashMap(10, 0.7f);
        ArrayList<Trap> currentTraps = new ArrayList<Trap>();
        this.zoneCount = 0;
        this.unitToZone = new HashMap<Unit, Zone>(units.size() * 2 + 1, 0.7f);
        Zone currentZone = new Zone("0");
        trapListToZone.put(new ArrayList(), currentZone);
        for (Unit u : units) {
            List trapBoundaries = (List)unitToTrapBoundaries.get(u);
            if (trapBoundaries != null && !trapBoundaries.isEmpty()) {
                for (Trap trap : trapBoundaries) {
                    if (currentTraps.contains(trap)) {
                        currentTraps.remove(trap);
                        continue;
                    }
                    currentTraps.add(trap);
                }
                if (trapListToZone.containsKey(currentTraps)) {
                    currentZone = (Zone)trapListToZone.get(currentTraps);
                } else {
                    ++this.zoneCount;
                    currentZone = new Zone(new Integer(this.zoneCount).toString());
                    trapListToZone.put(currentTraps, currentZone);
                }
            }
            this.unitToZone.put(u, currentZone);
        }
    }

    private void addTrapBoundary(Unit unit, Trap t2, Map<Unit, List<Trap>> unitToTrapBoundaries) {
        List<Trap> boundary = unitToTrapBoundaries.get(unit);
        if (boundary == null) {
            boundary = new ArrayList<Trap>();
            unitToTrapBoundaries.put(unit, boundary);
        }
        boundary.add(t2);
    }

    public Zone getZoneOf(Unit u) {
        Zone z = this.unitToZone.get(u);
        if (z == null) {
            throw new RuntimeException("null zone!");
        }
        return z;
    }

    public int getZoneCount() {
        return this.zoneCount;
    }
}

