/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.logic;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.BodyTransformer;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.logic.Loop;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.MHGDominatorsFinder;
import soot.toolkits.graph.UnitGraph;

public class LoopFinder
extends BodyTransformer {
    private Set<Loop> loops = null;

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        this.getLoops(b);
    }

    public Set<Loop> getLoops(Body b) {
        if (this.loops != null) {
            return this.loops;
        }
        return this.getLoops(new ExceptionalUnitGraph(b));
    }

    public Set<Loop> getLoops(UnitGraph g2) {
        if (this.loops != null) {
            return this.loops;
        }
        MHGDominatorsFinder<Unit> a = new MHGDominatorsFinder<Unit>(g2);
        HashMap<Stmt, List<Stmt>> loops = new HashMap<Stmt, List<Stmt>>();
        for (Unit u : g2.getBody().getUnits()) {
            List<Unit> succs = g2.getSuccsOf(u);
            List<Unit> dominaters = a.getDominators(u);
            ArrayList<Stmt> headers = new ArrayList<Stmt>();
            for (Unit unit : succs) {
                if (!dominaters.contains(unit)) continue;
                headers.add((Stmt)unit);
            }
            for (Unit unit : headers) {
                List<Stmt> loopBody = this.getLoopBodyFor(unit, u, g2);
                if (loops.containsKey(unit)) {
                    List lb1 = (List)loops.get(unit);
                    loops.put((Stmt)unit, this.union(lb1, loopBody));
                    continue;
                }
                loops.put((Stmt)unit, loopBody);
            }
        }
        HashSet<Loop> ret = new HashSet<Loop>();
        for (Map.Entry entry : loops.entrySet()) {
            ret.add(new Loop((Stmt)entry.getKey(), (List)entry.getValue(), g2));
        }
        this.loops = ret;
        return ret;
    }

    private List<Stmt> getLoopBodyFor(Unit header, Unit node, UnitGraph g2) {
        ArrayList<Stmt> loopBody = new ArrayList<Stmt>();
        ArrayDeque<Unit> stack = new ArrayDeque<Unit>();
        loopBody.add((Stmt)header);
        stack.push(node);
        while (!stack.isEmpty()) {
            Stmt next = (Stmt)stack.pop();
            if (loopBody.contains(next)) continue;
            loopBody.add(0, next);
            for (Unit u : g2.getPredsOf(next)) {
                stack.push(u);
            }
        }
        assert (node == header && loopBody.size() == 1 || loopBody.get(loopBody.size() - 2) == node);
        assert (loopBody.get(loopBody.size() - 1) == header);
        return loopBody;
    }

    private List<Stmt> union(List<Stmt> l1, List<Stmt> l2) {
        for (Stmt next : l2) {
            if (l1.contains(next)) continue;
            l1.add(next);
        }
        return l1;
    }
}

