/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.callgraph;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.MethodOrMethodContext;
import soot.MethodToContexts;
import soot.Scene;
import soot.Singletons;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.tagkit.Host;
import soot.tagkit.LinkTag;

public class CallGraphTagger
extends BodyTransformer {
    private MethodToContexts methodToContexts;

    public CallGraphTagger(Singletons.Global g2) {
    }

    public static CallGraphTagger v() {
        return G.v().soot_jimple_toolkits_annotation_callgraph_CallGraphTagger();
    }

    protected void internalTransform(Body b, String phaseName, Map options) {
        CallGraph cg = Scene.v().getCallGraph();
        if (this.methodToContexts == null) {
            this.methodToContexts = new MethodToContexts(Scene.v().getReachableMethods().listener());
        }
        for (Stmt s2 : b.getUnits()) {
            Iterator<Edge> edges = cg.edgesOutOf(s2);
            while (edges.hasNext()) {
                Edge e = edges.next();
                SootMethod m4 = e.tgt();
                s2.addTag(new LinkTag("CallGraph: Type: " + e.kind() + " Target Method/Context: " + e.getTgt().toString(), m4, m4.getDeclaringClass().getName(), "Call Graph"));
            }
        }
        SootMethod m5 = b.getMethod();
        for (MethodOrMethodContext momc : this.methodToContexts.get(m5)) {
            Iterator<Edge> callerEdges = cg.edgesInto(momc);
            while (callerEdges.hasNext()) {
                SootMethod methodCaller;
                Edge callEdge = callerEdges.next();
                Host src = methodCaller = callEdge.src();
                if (callEdge.srcUnit() != null) {
                    src = callEdge.srcUnit();
                }
                m5.addTag(new LinkTag("CallGraph: Source Type: " + callEdge.kind() + " Source Method/Context: " + callEdge.getSrc().toString(), src, methodCaller.getDeclaringClass().getName(), "Call Graph"));
            }
        }
    }
}

