/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.G;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.IdentityStmt;
import soot.jimple.Stmt;
import soot.tagkit.LineNumberTag;

public class LineNumberAdder
extends SceneTransformer {
    public LineNumberAdder(Singletons.Global g2) {
    }

    public static LineNumberAdder v() {
        return G.v().soot_jimple_toolkits_annotation_LineNumberAdder();
    }

    public void internalTransform(String phaseName, Map opts) {
        Iterator<SootClass> it = Scene.v().getApplicationClasses().snapshotIterator();
        while (it.hasNext()) {
            SootClass sc = it.next();
            HashMap<Integer, SootMethod> lineToMeth = new HashMap<Integer, SootMethod>();
            for (SootMethod meth : sc.getMethods()) {
                if (!meth.isConcrete()) continue;
                Body body = meth.retrieveActiveBody();
                Stmt s2 = (Stmt)body.getUnits().getFirst();
                while (s2 instanceof IdentityStmt) {
                    s2 = body.getUnits().getSuccOf(s2);
                }
                if (!s2.hasTag("LineNumberTag")) continue;
                LineNumberTag tag = (LineNumberTag)s2.getTag("LineNumberTag");
                lineToMeth.put(new Integer(tag.getLineNumber()), meth);
            }
            for (SootMethod meth : sc.getMethods()) {
                if (!meth.isConcrete()) continue;
                Body body = meth.retrieveActiveBody();
                Stmt s3 = (Stmt)body.getUnits().getFirst();
                while (s3 instanceof IdentityStmt) {
                    s3 = body.getUnits().getSuccOf(s3);
                }
                if (!s3.hasTag("LineNumberTag")) continue;
                LineNumberTag tag = (LineNumberTag)s3.getTag("LineNumberTag");
                int line_num = tag.getLineNumber() - 1;
                if (lineToMeth.containsKey(new Integer(line_num))) {
                    meth.addTag(new LineNumberTag(line_num + 1));
                    continue;
                }
                meth.addTag(new LineNumberTag(line_num));
            }
        }
    }
}

