/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.ArrayType;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.NewMultiArrayInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.ExprSwitch;
import soot.jimple.JimpleToBafContext;
import soot.jimple.NewMultiArrayExpr;
import soot.util.Switch;

public abstract class AbstractNewMultiArrayExpr
implements NewMultiArrayExpr,
ConvertToBaf {
    ArrayType baseType;
    protected final ValueBox[] sizeBoxes;

    @Override
    public abstract Object clone();

    protected AbstractNewMultiArrayExpr(ArrayType type, ValueBox[] sizeBoxes) {
        this.baseType = type;
        this.sizeBoxes = sizeBoxes;
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof AbstractNewMultiArrayExpr) {
            AbstractNewMultiArrayExpr ae = (AbstractNewMultiArrayExpr)o;
            return this.baseType.equals(ae.baseType) && this.sizeBoxes.length == ae.sizeBoxes.length;
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.baseType.hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Type t2 = this.baseType.baseType;
        buffer.append("newmultiarray (" + t2.toString() + ")");
        for (ValueBox element : this.sizeBoxes) {
            buffer.append("[" + element.getValue().toString() + "]");
        }
        for (int i = 0; i < this.baseType.numDimensions - this.sizeBoxes.length; ++i) {
            buffer.append("[]");
        }
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        Type t2 = this.baseType.baseType;
        up.literal("newmultiarray");
        up.literal(" (");
        up.type(t2);
        up.literal(")");
        for (ValueBox element : this.sizeBoxes) {
            up.literal("[");
            element.toString(up);
            up.literal("]");
        }
        for (int i = 0; i < this.baseType.numDimensions - this.sizeBoxes.length; ++i) {
            up.literal("[]");
        }
    }

    @Override
    public ArrayType getBaseType() {
        return this.baseType;
    }

    @Override
    public void setBaseType(ArrayType baseType) {
        this.baseType = baseType;
    }

    @Override
    public ValueBox getSizeBox(int index) {
        return this.sizeBoxes[index];
    }

    @Override
    public int getSizeCount() {
        return this.sizeBoxes.length;
    }

    @Override
    public Value getSize(int index) {
        return this.sizeBoxes[index].getValue();
    }

    @Override
    public List<Value> getSizes() {
        ArrayList<Value> toReturn = new ArrayList<Value>();
        for (ValueBox element : this.sizeBoxes) {
            toReturn.add(element.getValue());
        }
        return toReturn;
    }

    @Override
    public void setSize(int index, Value size) {
        this.sizeBoxes[index].setValue(size);
    }

    @Override
    public final List<ValueBox> getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        Collections.addAll(list, this.sizeBoxes);
        for (ValueBox element : this.sizeBoxes) {
            list.addAll(element.getValue().getUseBoxes());
        }
        return list;
    }

    @Override
    public Type getType() {
        return this.baseType;
    }

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseNewMultiArrayExpr(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        List<Value> sizes = this.getSizes();
        for (int i = 0; i < sizes.size(); ++i) {
            ((ConvertToBaf)((Object)sizes.get(i))).convertToBaf(context, out);
        }
        NewMultiArrayInst u = Baf.v().newNewMultiArrayInst(this.getBaseType(), sizes.size());
        out.add(u);
        u.addAllTagsOf(context.getCurrentUnit());
    }
}

