/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.util.preanalyses;

import soot.Local;
import soot.Unit;
import soot.ValueBox;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.BackwardFlowAnalysis;
import soot.toolkits.scalar.FlowSet;

public class SingleLiveVariableAnalysis
extends BackwardFlowAnalysis<Unit, FlowSet<Local>> {
    Local queryLocal;
    Unit turnUnit;
    int runtime;

    public SingleLiveVariableAnalysis(DirectedGraph<Unit> graph, Local queryLocal, Unit turnUnit) {
        super(graph);
        this.queryLocal = queryLocal;
        this.turnUnit = turnUnit;
        long timeBefore = System.nanoTime();
        this.doAnalysis();
        this.runtime = (int)Math.round((double)(System.nanoTime() - timeBefore) / 1000.0);
    }

    @Override
    protected void flowThrough(FlowSet<Local> in, Unit unit, FlowSet<Local> out) {
        if (unit == this.turnUnit) {
            out.clear();
            return;
        }
        in.copy(out);
        for (ValueBox box : unit.getDefBoxes()) {
            if (box.getValue() != this.queryLocal) continue;
            out.remove(this.queryLocal);
        }
        for (ValueBox box : unit.getUseBoxes()) {
            if (box.getValue() != this.queryLocal) continue;
            out.add(this.queryLocal);
        }
    }

    @Override
    protected FlowSet<Local> newInitialFlow() {
        return new ArraySparseSet<Local>();
    }

    @Override
    protected void merge(FlowSet<Local> in1, FlowSet<Local> in2, FlowSet<Local> out) {
        in1.union(in2, out);
    }

    @Override
    protected void copy(FlowSet<Local> in, FlowSet<Local> out) {
        in.copy(out);
    }

    public boolean canOmitAlias(Unit unit) {
        return ((FlowSet)this.getFlowBefore(unit)).size() == 0;
    }

    public int getRuntimeInMicroseconds() {
        return this.runtime;
    }
}

